/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long handle;
    int transparentPixel = -1;
    int transparentColor = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private int styleFlag = 0;
    private int currentDeviceZoom = 100;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        width = DPIUtil.autoScaleUp((int)width);
        height = DPIUtil.autoScaleUp((int)height);
        this.init(width, height);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        device = this.device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = srcImage.getBoundsInPixels();
        this.type = srcImage.type;
        this.imageDataProvider = srcImage.imageDataProvider;
        this.imageFileNameProvider = srcImage.imageFileNameProvider;
        this.styleFlag = srcImage.styleFlag | flag;
        this.currentDeviceZoom = srcImage.currentDeviceZoom;
        block0 : switch (flag) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        long hDC = device.internal_new_GC(null);
                        long hdcSource = OS.CreateCompatibleDC((long)hDC);
                        long hdcDest = OS.CreateCompatibleDC((long)hDC);
                        long hOldSrc = OS.SelectObject((long)hdcSource, (long)srcImage.handle);
                        BITMAP bm = new BITMAP();
                        OS.GetObject((long)srcImage.handle, (int)BITMAP.sizeof, (BITMAP)bm);
                        this.handle = OS.CreateCompatibleBitmap((long)hdcSource, (int)rect.width, (int)(bm.bmBits != 0L ? -rect.height : rect.height));
                        if (this.handle == 0L) {
                            SWT.error(2);
                        }
                        long hOldDest = OS.SelectObject((long)hdcDest, (long)this.handle);
                        OS.BitBlt((long)hdcDest, (int)0, (int)0, (int)rect.width, (int)rect.height, (long)hdcSource, (int)0, (int)0, (int)0xCC0020);
                        OS.SelectObject((long)hdcSource, (long)hOldSrc);
                        OS.SelectObject((long)hdcDest, (long)hOldDest);
                        OS.DeleteDC((long)hdcSource);
                        OS.DeleteDC((long)hdcDest);
                        device.internal_dispose_GC(hDC, null);
                        this.transparentPixel = srcImage.transparentPixel;
                        this.alpha = srcImage.alpha;
                        if (srcImage.alphaData == null) break block0;
                        this.alphaData = new byte[srcImage.alphaData.length];
                        System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        this.handle = OS.CopyImage((long)srcImage.handle, (int)1, (int)rect.width, (int)rect.height, (int)0);
                        if (this.handle != 0L) break block0;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(40);
                        break;
                    }
                }
                break;
            }
            case 1: {
                ImageData data = srcImage.getImageDataAtCurrentZoom();
                PaletteData palette = data.palette;
                RGB[] rgbs = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                newData.alpha = data.alpha;
                newData.alphaData = data.alphaData;
                newData.maskData = data.maskData;
                newData.maskPad = data.maskPad;
                if (data.transparentPixel != -1) {
                    newData.transparentPixel = 0;
                }
                int[] scanline = new int[rect.width];
                int[] maskScanline = null;
                ImageData mask = null;
                if (data.maskData != null) {
                    mask = data.getTransparencyMask();
                }
                if (mask != null) {
                    maskScanline = new int[rect.width];
                }
                int redMask = palette.redMask;
                int greenMask = palette.greenMask;
                int blueMask = palette.blueMask;
                int redShift = palette.redShift;
                int greenShift = palette.greenShift;
                int blueShift = palette.blueShift;
                int y = 0;
                while (y < rect.height) {
                    int offset = y * newData.bytesPerLine;
                    data.getPixels(0, y, rect.width, scanline, 0);
                    if (mask != null) {
                        mask.getPixels(0, y, rect.width, maskScanline, 0);
                    }
                    int x = 0;
                    while (x < rect.width) {
                        int pixel = scanline[x];
                        if (!(data.transparentPixel != -1 && pixel == data.transparentPixel || mask != null && maskScanline[x] == 0)) {
                            int blue;
                            int green;
                            int red;
                            if (palette.isDirect) {
                                red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                            } else {
                                red = palette.colors[pixel].red;
                                green = palette.colors[pixel].green;
                                blue = palette.colors[pixel].blue;
                            }
                            int intensity = red * red + green * green + blue * blue;
                            newData.data[offset] = intensity < 98304 ? 1 : 2;
                        }
                        ++offset;
                        ++x;
                    }
                    ++y;
                }
                this.init(newData);
                break;
            }
            case 2: {
                ImageData data = srcImage.getImageDataAtCurrentZoom();
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    int i = 0;
                    while (i < rgbs.length) {
                        if (data.transparentPixel != i) {
                            int intensity;
                            RGB color = rgbs[i];
                            int red = color.red;
                            int green = color.green;
                            int blue = color.blue;
                            color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                            color.red = color.blue;
                        }
                        ++i;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    int i = 0;
                    while (i < rgbs.length) {
                        rgbs[i] = new RGB(i, i, i);
                        ++i;
                    }
                    newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                    newData.alpha = data.alpha;
                    newData.alphaData = data.alphaData;
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    if (data.transparentPixel != -1) {
                        newData.transparentPixel = 254;
                    }
                    int[] scanline = new int[rect.width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    int y = 0;
                    while (y < rect.height) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, rect.width, scanline, 0);
                        int x = 0;
                        while (x < rect.width) {
                            int pixel = scanline[x];
                            if (pixel != data.transparentPixel) {
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                int intensity = red + red + green + green + green + green + green + blue >> 3;
                                if (newData.transparentPixel == intensity) {
                                    intensity = 255;
                                }
                                newData.data[offset] = (byte)intensity;
                            } else {
                                newData.data[offset] = -2;
                            }
                            ++offset;
                            ++x;
                        }
                        ++y;
                    }
                }
                this.init(newData);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        bounds = DPIUtil.autoScaleUp((Rectangle)bounds);
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        super(device);
        if (data == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        data = DPIUtil.autoScaleUp((Device)device, (ImageData)data);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        source = DPIUtil.autoScaleUp((Device)device, (ImageData)source);
        mask = DPIUtil.autoScaleUp((Device)device, (ImageData)mask);
        mask = ImageData.convertMask(mask);
        Image.init(this.device, this, source, mask);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        ImageData data = DPIUtil.autoScaleUp((Device)device, (ImageData)new ImageData(stream));
        this.init(data);
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        ImageData data = DPIUtil.autoScaleUp((Device)device, (ImageData)new ImageData(filename));
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageFileNameProvider = imageFileNameProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        boolean[] found = new boolean[1];
        String fileName = DPIUtil.validateAndGetImagePathAtZoom((ImageFileNameProvider)imageFileNameProvider, (int)this.currentDeviceZoom, (boolean[])found);
        if (found[0]) {
            this.initNative(fileName);
            if (this.handle == 0L) {
                this.init(new ImageData(fileName));
            }
        } else {
            ImageData resizedData = DPIUtil.autoScaleUp((Device)device, (ImageData)new ImageData(fileName));
            this.init(resizedData);
        }
        this.init();
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageDataProvider = imageDataProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        boolean[] found = new boolean[1];
        ImageData data = DPIUtil.validateAndGetImageDataAtZoom((ImageDataProvider)imageDataProvider, (int)this.currentDeviceZoom, (boolean[])found);
        if (found[0]) {
            this.init(data);
        } else {
            ImageData resizedData = DPIUtil.autoScaleUp((Device)device, (ImageData)data);
            this.init(resizedData);
        }
        this.init();
    }

    boolean refreshImageForZoom() {
        boolean refreshed = false;
        int deviceZoomLevel = DPIUtil.getDeviceZoom();
        if (this.imageFileNameProvider != null) {
            if (deviceZoomLevel != this.currentDeviceZoom) {
                boolean[] found = new boolean[1];
                String filename = DPIUtil.validateAndGetImagePathAtZoom((ImageFileNameProvider)this.imageFileNameProvider, (int)deviceZoomLevel, (boolean[])found);
                if (found[0] || this.currentDeviceZoom != 100) {
                    this.destroy();
                    this.initNative(filename);
                    if (this.handle == 0L) {
                        this.init(new ImageData(filename));
                    }
                    this.init();
                    refreshed = true;
                }
                if (!found[0]) {
                    this.destroy();
                    ImageData resizedData = DPIUtil.autoScaleUp((Device)this.device, (ImageData)new ImageData(filename));
                    this.init(resizedData);
                    this.init();
                    refreshed = true;
                }
                this.currentDeviceZoom = deviceZoomLevel;
            }
        } else if (this.imageDataProvider != null) {
            if (deviceZoomLevel != this.currentDeviceZoom) {
                boolean[] found = new boolean[1];
                ImageData data = DPIUtil.validateAndGetImageDataAtZoom((ImageDataProvider)this.imageDataProvider, (int)deviceZoomLevel, (boolean[])found);
                if (found[0] || this.currentDeviceZoom != 100) {
                    this.destroy();
                    this.init(data);
                    this.init();
                    refreshed = true;
                }
                if (!found[0]) {
                    this.destroy();
                    ImageData resizedData = DPIUtil.autoScaleUp((Device)this.device, (ImageData)data);
                    this.init(resizedData);
                    this.init();
                    refreshed = true;
                }
                this.currentDeviceZoom = deviceZoomLevel;
            }
        } else if (deviceZoomLevel != this.currentDeviceZoom) {
            ImageData data = this.getImageDataAtCurrentZoom();
            this.destroy();
            ImageData resizedData = DPIUtil.autoScaleImageData((Device)this.device, (ImageData)data, (int)deviceZoomLevel, (int)this.currentDeviceZoom);
            this.init(resizedData);
            this.init();
            refreshed = true;
            this.currentDeviceZoom = deviceZoomLevel;
        }
        return refreshed;
    }

    void initNative(String filename) {
        this.device.checkGDIP();
        boolean gdip = true;
        if (gdip && C.PTR_SIZEOF == 8 && filename.toLowerCase().endsWith(".gif")) {
            gdip = false;
        }
        if (OS.WIN32_VERSION >= OS.VERSION((int)6, (int)1) && filename.toLowerCase().endsWith(".gif")) {
            gdip = false;
        }
        if (gdip) {
            int length = filename.length();
            char[] chars = new char[length + 1];
            filename.getChars(0, length, chars, 0);
            long bitmap = Gdip.Bitmap_new((char[])chars, (boolean)false);
            if (bitmap != 0L) {
                int error = 2;
                int status = Gdip.Image_GetLastStatus((long)bitmap);
                if (status == 0) {
                    if (filename.toLowerCase().endsWith(".ico")) {
                        this.type = 1;
                        long[] hicon = new long[1];
                        status = Gdip.Bitmap_GetHICON((long)bitmap, (long[])hicon);
                        this.handle = hicon[0];
                    } else {
                        this.type = 0;
                        int width = Gdip.Image_GetWidth((long)bitmap);
                        int height = Gdip.Image_GetHeight((long)bitmap);
                        int pixelFormat = Gdip.Image_GetPixelFormat((long)bitmap);
                        switch (pixelFormat) {
                            case 135173: 
                            case 135174: {
                                this.handle = Image.createDIB(width, height, 16);
                                break;
                            }
                            case 8207: 
                            case 137224: {
                                this.handle = Image.createDIB(width, height, 24);
                                break;
                            }
                            case 139273: 
                            case 925707: 
                            case 0x101004: 
                            case 1060876: 
                            case 1851406: 
                            case 3424269: {
                                this.handle = Image.createDIB(width, height, 32);
                            }
                        }
                        if (this.handle != 0L) {
                            long hDC = this.device.internal_new_GC(null);
                            long srcHDC = OS.CreateCompatibleDC((long)hDC);
                            long oldSrcBitmap = OS.SelectObject((long)srcHDC, (long)this.handle);
                            long graphics = Gdip.Graphics_new((long)srcHDC);
                            if (graphics != 0L) {
                                Rect rect = new Rect();
                                rect.Width = width;
                                rect.Height = height;
                                status = Gdip.Graphics_DrawImage((long)graphics, (long)bitmap, (Rect)rect, (int)0, (int)0, (int)width, (int)height, (int)2, (long)0L, (long)0L, (long)0L);
                                if (status != 0) {
                                    error = 40;
                                    OS.DeleteObject((long)this.handle);
                                    this.handle = 0L;
                                }
                                Gdip.Graphics_delete((long)graphics);
                            }
                            OS.SelectObject((long)srcHDC, (long)oldSrcBitmap);
                            OS.DeleteDC((long)srcHDC);
                            this.device.internal_dispose_GC(hDC, null);
                        } else {
                            long lockedBitmapData = Gdip.BitmapData_new();
                            if (lockedBitmapData != 0L) {
                                status = Gdip.Bitmap_LockBits((long)bitmap, (long)0L, (int)0, (int)pixelFormat, (long)lockedBitmapData);
                                if (status == 0) {
                                    BitmapData bitmapData = new BitmapData();
                                    Gdip.MoveMemory((BitmapData)bitmapData, (long)lockedBitmapData);
                                    int stride = bitmapData.Stride;
                                    long pixels = bitmapData.Scan0;
                                    int depth = 0;
                                    int scanlinePad = 4;
                                    int transparentPixel = -1;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: {
                                            depth = 1;
                                            break;
                                        }
                                        case 197634: {
                                            depth = 4;
                                            break;
                                        }
                                        case 198659: {
                                            depth = 8;
                                            break;
                                        }
                                        case 135173: 
                                        case 135174: 
                                        case 397319: {
                                            depth = 16;
                                            break;
                                        }
                                        case 137224: {
                                            depth = 24;
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            depth = 32;
                                        }
                                    }
                                    if (depth != 0) {
                                        PaletteData paletteData = null;
                                        switch (bitmapData.PixelFormat) {
                                            case 196865: 
                                            case 197634: 
                                            case 198659: {
                                                int paletteSize = Gdip.Image_GetPaletteSize((long)bitmap);
                                                long hHeap = OS.GetProcessHeap();
                                                long palette = OS.HeapAlloc((long)hHeap, (int)8, (int)paletteSize);
                                                if (palette == 0L) {
                                                    SWT.error(2);
                                                }
                                                Gdip.Image_GetPalette((long)bitmap, (long)palette, (int)paletteSize);
                                                ColorPalette colorPalette = new ColorPalette();
                                                Gdip.MoveMemory((ColorPalette)colorPalette, (long)palette, (int)ColorPalette.sizeof);
                                                int[] entries = new int[colorPalette.Count];
                                                OS.MoveMemory((int[])entries, (long)(palette + 8L), (int)(entries.length * 4));
                                                OS.HeapFree((long)hHeap, (int)0, (long)palette);
                                                RGB[] rgbs = new RGB[colorPalette.Count];
                                                paletteData = new PaletteData(rgbs);
                                                int i = 0;
                                                while (i < entries.length) {
                                                    if ((entries[i] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                        transparentPixel = i;
                                                    }
                                                    rgbs[i] = new RGB((entries[i] & 0xFF0000) >> 16, (entries[i] & 0xFF00) >> 8, (entries[i] & 0xFF) >> 0);
                                                    ++i;
                                                }
                                                break;
                                            }
                                            case 135173: 
                                            case 397319: {
                                                paletteData = new PaletteData(31744, 992, 31);
                                                break;
                                            }
                                            case 135174: {
                                                paletteData = new PaletteData(63488, 2016, 31);
                                                break;
                                            }
                                            case 137224: {
                                                paletteData = new PaletteData(255, 65280, 0xFF0000);
                                                break;
                                            }
                                            case 139273: 
                                            case 2498570: {
                                                paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                            }
                                        }
                                        byte[] data = new byte[stride * height];
                                        byte[] alphaData = null;
                                        OS.MoveMemory((byte[])data, (long)pixels, (int)data.length);
                                        switch (bitmapData.PixelFormat) {
                                            case 397319: {
                                                alphaData = new byte[width * height];
                                                int i = 1;
                                                int j = 0;
                                                while (i < data.length) {
                                                    alphaData[j] = (byte)((data[i] & 0x80) != 0 ? 255 : 0);
                                                    i += 2;
                                                    ++j;
                                                }
                                                break;
                                            }
                                            case 2498570: {
                                                alphaData = new byte[width * height];
                                                int i = 3;
                                                int j = 0;
                                                while (i < data.length) {
                                                    alphaData[j] = data[i];
                                                    i += 4;
                                                    ++j;
                                                }
                                                break;
                                            }
                                        }
                                        ImageData img = new ImageData(width, height, depth, paletteData, scanlinePad, data);
                                        img.transparentPixel = transparentPixel;
                                        img.alphaData = alphaData;
                                        this.init(img);
                                    }
                                    Gdip.Bitmap_UnlockBits((long)bitmap, (long)lockedBitmapData);
                                } else {
                                    error = 40;
                                }
                                Gdip.BitmapData_delete((long)lockedBitmapData);
                            }
                        }
                    }
                }
                Gdip.Bitmap_delete((long)bitmap);
                if (status == 0 && this.handle == 0L) {
                    SWT.error(error);
                }
            }
        }
    }

    long[] createGdipImage() {
        switch (this.type) {
            case 0: {
                if (this.alpha != -1 || this.alphaData != null || this.transparentPixel != -1) {
                    int x;
                    int y;
                    BITMAP bm = new BITMAP();
                    OS.GetObject((long)this.handle, (int)BITMAP.sizeof, (BITMAP)bm);
                    int imgWidth = bm.bmWidth;
                    int imgHeight = bm.bmHeight;
                    long hDC = this.device.internal_new_GC(null);
                    long srcHdc = OS.CreateCompatibleDC((long)hDC);
                    long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)this.handle);
                    long memHdc = OS.CreateCompatibleDC((long)hDC);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject((long)memHdc, (long)memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject((long)memDib, (int)BITMAP.sizeof, (BITMAP)dibBM);
                    int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
                    OS.BitBlt((long)memHdc, (int)0, (int)0, (int)imgWidth, (int)imgHeight, (long)srcHdc, (int)0, (int)0, (int)0xCC0020);
                    byte red = 0;
                    byte green = 0;
                    byte blue = 0;
                    if (this.transparentPixel != -1) {
                        if (bm.bmBitsPixel <= 8) {
                            byte[] color = new byte[4];
                            OS.GetDIBColorTable((long)srcHdc, (int)this.transparentPixel, (int)1, (byte[])color);
                            blue = color[0];
                            green = color[1];
                            red = color[2];
                        } else {
                            switch (bm.bmBitsPixel) {
                                case 16: {
                                    int blueMask = 31;
                                    int blueShift = ImageData.getChannelShift(blueMask);
                                    byte[] blues = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(blueMask, blueShift)];
                                    blue = blues[(this.transparentPixel & blueMask) >> blueShift];
                                    int greenMask = 992;
                                    int greenShift = ImageData.getChannelShift(greenMask);
                                    byte[] greens = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(greenMask, greenShift)];
                                    green = greens[(this.transparentPixel & greenMask) >> greenShift];
                                    int redMask = 31744;
                                    int redShift = ImageData.getChannelShift(redMask);
                                    byte[] reds = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(redMask, redShift)];
                                    red = reds[(this.transparentPixel & redMask) >> redShift];
                                    break;
                                }
                                case 24: {
                                    blue = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    green = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                    red = (byte)(this.transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    blue = (byte)((this.transparentPixel & 0xFF000000) >>> 24);
                                    green = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    red = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                    }
                    OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
                    OS.SelectObject((long)memHdc, (long)oldMemBitmap);
                    OS.DeleteObject((long)srcHdc);
                    OS.DeleteObject((long)memHdc);
                    byte[] srcData = new byte[sizeInBytes];
                    OS.MoveMemory((byte[])srcData, (long)dibBM.bmBits, (int)sizeInBytes);
                    OS.DeleteObject((long)memDib);
                    this.device.internal_dispose_GC(hDC, null);
                    if (this.alpha != -1) {
                        y = 0;
                        int dp = 0;
                        while (y < imgHeight) {
                            x = 0;
                            while (x < imgWidth) {
                                srcData[dp + 3] = (byte)this.alpha;
                                dp += 4;
                                ++x;
                            }
                            ++y;
                        }
                    } else if (this.alphaData != null) {
                        y = 0;
                        int dp = 0;
                        int ap = 0;
                        while (y < imgHeight) {
                            int x2 = 0;
                            while (x2 < imgWidth) {
                                srcData[dp + 3] = this.alphaData[ap++];
                                dp += 4;
                                ++x2;
                            }
                            ++y;
                        }
                    } else if (this.transparentPixel != -1) {
                        y = 0;
                        int dp = 0;
                        while (y < imgHeight) {
                            x = 0;
                            while (x < imgWidth) {
                                srcData[dp + 3] = srcData[dp] == blue && srcData[dp + 1] == green && srcData[dp + 2] == red ? 0 : -1;
                                dp += 4;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    long hHeap = OS.GetProcessHeap();
                    long pixels = OS.HeapAlloc((long)hHeap, (int)8, (int)srcData.length);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory((long)pixels, (byte[])srcData, (int)sizeInBytes);
                    return new long[]{Gdip.Bitmap_new((int)imgWidth, (int)imgHeight, (int)dibBM.bmWidthBytes, (int)2498570, (long)pixels), pixels};
                }
                long[] lArray = new long[2];
                lArray[0] = Gdip.Bitmap_new((long)this.handle, (long)0L);
                return lArray;
            }
            case 1: {
                ICONINFO iconInfo = new ICONINFO();
                OS.GetIconInfo((long)this.handle, (ICONINFO)iconInfo);
                long hBitmap = iconInfo.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = iconInfo.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject((long)hBitmap, (int)BITMAP.sizeof, (BITMAP)bm);
                int imgWidth = bm.bmWidth;
                int imgHeight = hBitmap == iconInfo.hbmMask ? bm.bmHeight / 2 : bm.bmHeight;
                long img = 0L;
                long pixels = 0L;
                if (imgWidth > imgHeight || bm.bmBitsPixel == 32) {
                    long hDC = this.device.internal_new_GC(null);
                    long srcHdc = OS.CreateCompatibleDC((long)hDC);
                    long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)hBitmap);
                    long memHdc = OS.CreateCompatibleDC((long)hDC);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject((long)memHdc, (long)memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject((long)memDib, (int)BITMAP.sizeof, (BITMAP)dibBM);
                    OS.BitBlt((long)memHdc, (int)0, (int)0, (int)imgWidth, (int)imgHeight, (long)srcHdc, (int)0, (int)(hBitmap == iconInfo.hbmMask ? imgHeight : 0), (int)0xCC0020);
                    OS.SelectObject((long)memHdc, (long)oldMemBitmap);
                    OS.DeleteObject((long)memHdc);
                    byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
                    OS.MoveMemory((byte[])srcData, (long)dibBM.bmBits, (int)srcData.length);
                    OS.DeleteObject((long)memDib);
                    OS.SelectObject((long)srcHdc, (long)iconInfo.hbmMask);
                    int y = 0;
                    int dp = 3;
                    while (y < imgHeight) {
                        int x = 0;
                        while (x < imgWidth) {
                            if (srcData[dp] == 0) {
                                srcData[dp] = OS.GetPixel((long)srcHdc, (int)x, (int)y) != 0 ? 0 : -1;
                            }
                            dp += 4;
                            ++x;
                        }
                        ++y;
                    }
                    OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
                    OS.DeleteObject((long)srcHdc);
                    this.device.internal_dispose_GC(hDC, null);
                    long hHeap = OS.GetProcessHeap();
                    pixels = OS.HeapAlloc((long)hHeap, (int)8, (int)srcData.length);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory((long)pixels, (byte[])srcData, (int)srcData.length);
                    img = Gdip.Bitmap_new((int)imgWidth, (int)imgHeight, (int)dibBM.bmWidthBytes, (int)2498570, (long)pixels);
                } else {
                    img = Gdip.Bitmap_new((long)this.handle);
                }
                if (iconInfo.hbmColor != 0L) {
                    OS.DeleteObject((long)iconInfo.hbmColor);
                }
                if (iconInfo.hbmMask != 0L) {
                    OS.DeleteObject((long)iconInfo.hbmMask);
                }
                return new long[]{img, pixels};
            }
        }
        SWT.error(40);
        return null;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.type == 1) {
            OS.DestroyIcon((long)this.handle);
        } else {
            OS.DeleteObject((long)this.handle);
        }
        this.handle = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        return this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        long hDC = this.device.internal_new_GC(null);
        BITMAP bm = new BITMAP();
        OS.GetObject((long)this.handle, (int)BITMAP.sizeof, (BITMAP)bm);
        long hdcMem = OS.CreateCompatibleDC((long)hDC);
        long hOldObject = OS.SelectObject((long)hdcMem, (long)this.handle);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (bm.bmBitsPixel <= 8) {
            byte[] color = new byte[4];
            OS.GetDIBColorTable((long)hdcMem, (int)this.transparentPixel, (int)1, (byte[])color);
            blue = color[0] & 0xFF;
            green = color[1] & 0xFF;
            red = color[2] & 0xFF;
        } else {
            switch (bm.bmBitsPixel) {
                case 16: {
                    blue = (this.transparentPixel & 0x1F) << 3;
                    green = (this.transparentPixel & 0x3E0) >> 2;
                    red = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    blue = (this.transparentPixel & 0xFF0000) >> 16;
                    green = (this.transparentPixel & 0xFF00) >> 8;
                    red = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    blue = (this.transparentPixel & 0xFF000000) >>> 24;
                    green = (this.transparentPixel & 0xFF0000) >> 16;
                    red = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject((long)hdcMem, (long)hOldObject);
        OS.DeleteDC((long)hdcMem);
        this.device.internal_dispose_GC(hDC, null);
        return Color.win32_new(this.device, blue << 16 | green << 8 | red);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getBounds(100);
    }

    Rectangle getBounds(int zoom) {
        Rectangle bounds = this.getBoundsInPixels();
        if (bounds != null && zoom != this.currentDeviceZoom) {
            bounds = DPIUtil.autoScaleBounds((Rectangle)bounds, (int)zoom, (int)this.currentDeviceZoom);
        }
        return bounds;
    }

    @Deprecated
    public Rectangle getBoundsInPixels() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        switch (this.type) {
            case 0: {
                BITMAP bm = new BITMAP();
                OS.GetObject((long)this.handle, (int)BITMAP.sizeof, (BITMAP)bm);
                this.width = bm.bmWidth;
                this.height = bm.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
            case 1: {
                ICONINFO info = new ICONINFO();
                OS.GetIconInfo((long)this.handle, (ICONINFO)info);
                long hBitmap = info.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = info.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject((long)hBitmap, (int)BITMAP.sizeof, (BITMAP)bm);
                if (hBitmap == info.hbmMask) {
                    bm.bmHeight /= 2;
                }
                if (info.hbmColor != 0L) {
                    OS.DeleteObject((long)info.hbmColor);
                }
                if (info.hbmMask != 0L) {
                    OS.DeleteObject((long)info.hbmMask);
                }
                this.width = bm.bmWidth;
                this.height = bm.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
        }
        SWT.error(40);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    public ImageData getImageData(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (zoom == this.currentDeviceZoom) {
            return this.getImageDataAtCurrentZoom();
        }
        if (this.imageDataProvider != null) {
            boolean[] found = new boolean[1];
            ImageData data = DPIUtil.validateAndGetImageDataAtZoom((ImageDataProvider)this.imageDataProvider, (int)zoom, (boolean[])found);
            if (found[0]) {
                return data;
            }
            return DPIUtil.autoScaleImageData((Device)this.device, (ImageData)data, (int)zoom, (int)100);
        }
        if (this.imageFileNameProvider != null) {
            boolean[] found = new boolean[1];
            String fileName = DPIUtil.validateAndGetImagePathAtZoom((ImageFileNameProvider)this.imageFileNameProvider, (int)zoom, (boolean[])found);
            if (found[0]) {
                return new ImageData(fileName);
            }
            return DPIUtil.autoScaleImageData((Device)this.device, (ImageData)new ImageData(fileName), (int)zoom, (int)100);
        }
        return DPIUtil.autoScaleImageData((Device)this.device, (ImageData)this.getImageDataAtCurrentZoom(), (int)zoom, (int)this.currentDeviceZoom);
    }

    @Deprecated
    public ImageData getImageDataAtCurrentZoom() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 1: {
                int i;
                ICONINFO info = new ICONINFO();
                OS.GetIconInfo((long)this.handle, (ICONINFO)info);
                long hBitmap = info.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = info.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject((long)hBitmap, (int)BITMAP.sizeof, (BITMAP)bm);
                int depth = bm.bmPlanes * bm.bmBitsPixel;
                int width = bm.bmWidth;
                if (hBitmap == info.hbmMask) {
                    bm.bmHeight /= 2;
                }
                int height = bm.bmHeight;
                int numColors = 0;
                if (depth <= 8) {
                    numColors = 1 << depth;
                }
                BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                bmiHeader.biWidth = width;
                bmiHeader.biHeight = -height;
                bmiHeader.biPlanes = 1;
                bmiHeader.biBitCount = (short)depth;
                bmiHeader.biCompression = 0;
                byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                OS.MoveMemory((byte[])bmi, (BITMAPINFOHEADER)bmiHeader, (int)BITMAPINFOHEADER.sizeof);
                long hDC = this.device.internal_new_GC(null);
                long hBitmapDC = OS.CreateCompatibleDC((long)hDC);
                long hOldBitmap = OS.SelectObject((long)hBitmapDC, (long)hBitmap);
                OS.GetDIBits((long)hBitmapDC, (long)hBitmap, (int)0, (int)height, null, (byte[])bmi, (int)0);
                OS.MoveMemory((BITMAPINFOHEADER)bmiHeader, (byte[])bmi, (int)BITMAPINFOHEADER.sizeof);
                int imageSize = bmiHeader.biSizeImage;
                byte[] data = new byte[imageSize];
                OS.GetDIBits((long)hBitmapDC, (long)hBitmap, (int)0, (int)height, (byte[])data, (byte[])bmi, (int)0);
                PaletteData palette = null;
                if (depth <= 8) {
                    RGB[] rgbs = new RGB[numColors];
                    int srcIndex = 40;
                    i = 0;
                    while (i < numColors) {
                        rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                        srcIndex += 4;
                        ++i;
                    }
                    palette = new PaletteData(rgbs);
                } else if (depth == 16) {
                    palette = new PaletteData(31744, 992, 31);
                } else if (depth == 24) {
                    palette = new PaletteData(255, 65280, 0xFF0000);
                } else if (depth == 32) {
                    palette = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                byte[] maskData = null;
                if (info.hbmColor == 0L) {
                    maskData = new byte[imageSize];
                    OS.GetDIBits((long)hBitmapDC, (long)hBitmap, (int)height, (int)height, (byte[])maskData, (byte[])bmi, (int)0);
                } else {
                    bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biWidth = width;
                    bmiHeader.biHeight = -height;
                    bmiHeader.biPlanes = 1;
                    bmiHeader.biBitCount = 1;
                    bmiHeader.biCompression = 0;
                    bmi = new byte[BITMAPINFOHEADER.sizeof + 8];
                    OS.MoveMemory((byte[])bmi, (BITMAPINFOHEADER)bmiHeader, (int)BITMAPINFOHEADER.sizeof);
                    int offset = BITMAPINFOHEADER.sizeof;
                    bmi[offset + 6] = -1;
                    bmi[offset + 5] = -1;
                    bmi[offset + 4] = -1;
                    bmi[offset + 7] = 0;
                    OS.SelectObject((long)hBitmapDC, (long)info.hbmMask);
                    OS.GetDIBits((long)hBitmapDC, (long)info.hbmMask, (int)0, (int)height, null, (byte[])bmi, (int)0);
                    OS.MoveMemory((BITMAPINFOHEADER)bmiHeader, (byte[])bmi, (int)BITMAPINFOHEADER.sizeof);
                    imageSize = bmiHeader.biSizeImage;
                    maskData = new byte[imageSize];
                    OS.GetDIBits((long)hBitmapDC, (long)info.hbmMask, (int)0, (int)height, (byte[])maskData, (byte[])bmi, (int)0);
                    i = 0;
                    while (i < maskData.length) {
                        int n = i++;
                        maskData[n] = ~maskData[n];
                    }
                    int bpl = imageSize / height;
                    int maskPad = 1;
                    while (maskPad < 128) {
                        int calcBpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                        if (calcBpl == bpl) break;
                        ++maskPad;
                    }
                    maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, 2);
                }
                OS.SelectObject((long)hBitmapDC, (long)hOldBitmap);
                OS.DeleteDC((long)hBitmapDC);
                this.device.internal_dispose_GC(hDC, null);
                if (info.hbmColor != 0L) {
                    OS.DeleteObject((long)info.hbmColor);
                }
                if (info.hbmMask != 0L) {
                    OS.DeleteObject((long)info.hbmMask);
                }
                ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                imageData.maskData = maskData;
                imageData.maskPad = 2;
                return imageData;
            }
            case 0: {
                int imageSize;
                BITMAP bm = new BITMAP();
                OS.GetObject((long)this.handle, (int)BITMAP.sizeof, (BITMAP)bm);
                int depth = bm.bmPlanes * bm.bmBitsPixel;
                int width = bm.bmWidth;
                int height = bm.bmHeight;
                boolean isDib = bm.bmBits != 0L;
                long hDC = this.device.internal_new_GC(null);
                DIBSECTION dib = null;
                if (isDib) {
                    dib = new DIBSECTION();
                    OS.GetObject((long)this.handle, (int)DIBSECTION.sizeof, (DIBSECTION)dib);
                }
                int numColors = 0;
                if (depth <= 8) {
                    numColors = isDib ? dib.biClrUsed : 1 << depth;
                }
                byte[] bmi = null;
                BITMAPINFOHEADER bmiHeader = null;
                if (!isDib) {
                    bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biWidth = width;
                    bmiHeader.biHeight = -height;
                    bmiHeader.biPlanes = 1;
                    bmiHeader.biBitCount = (short)depth;
                    bmiHeader.biCompression = 0;
                    bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                    OS.MoveMemory((byte[])bmi, (BITMAPINFOHEADER)bmiHeader, (int)BITMAPINFOHEADER.sizeof);
                }
                long hBitmapDC = OS.CreateCompatibleDC((long)hDC);
                long hOldBitmap = OS.SelectObject((long)hBitmapDC, (long)this.handle);
                if (isDib) {
                    imageSize = dib.biSizeImage;
                } else {
                    OS.GetDIBits((long)hBitmapDC, (long)this.handle, (int)0, (int)height, null, bmi, (int)0);
                    OS.MoveMemory((BITMAPINFOHEADER)bmiHeader, bmi, (int)BITMAPINFOHEADER.sizeof);
                    imageSize = bmiHeader.biSizeImage;
                }
                byte[] data = new byte[imageSize];
                if (isDib) {
                    OS.MoveMemory((byte[])data, (long)bm.bmBits, (int)imageSize);
                } else {
                    OS.GetDIBits((long)hBitmapDC, (long)this.handle, (int)0, (int)height, (byte[])data, bmi, (int)0);
                }
                PaletteData palette = null;
                if (depth <= 8) {
                    RGB[] rgbs = new RGB[numColors];
                    if (isDib) {
                        byte[] colors = new byte[numColors * 4];
                        OS.GetDIBColorTable((long)hBitmapDC, (int)0, (int)numColors, (byte[])colors);
                        int colorIndex = 0;
                        int i = 0;
                        while (i < rgbs.length) {
                            rgbs[i] = new RGB(colors[colorIndex + 2] & 0xFF, colors[colorIndex + 1] & 0xFF, colors[colorIndex] & 0xFF);
                            colorIndex += 4;
                            ++i;
                        }
                    } else {
                        int srcIndex = BITMAPINFOHEADER.sizeof;
                        int i = 0;
                        while (i < numColors) {
                            rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                            srcIndex += 4;
                            ++i;
                        }
                    }
                    palette = new PaletteData(rgbs);
                } else if (depth == 16) {
                    palette = new PaletteData(31744, 992, 31);
                } else if (depth == 24) {
                    palette = new PaletteData(255, 65280, 0xFF0000);
                } else if (depth == 32) {
                    palette = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                OS.SelectObject((long)hBitmapDC, (long)hOldBitmap);
                OS.DeleteDC((long)hBitmapDC);
                this.device.internal_dispose_GC(hDC, null);
                ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                imageData.transparentPixel = this.transparentPixel;
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
                return imageData;
            }
        }
        SWT.error(40);
        return null;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        return (int)this.handle;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        long hDC = this.device.internal_new_GC(null);
        this.handle = OS.CreateCompatibleBitmap((long)hDC, (int)width, (int)height);
        if (this.handle == 0L) {
            int planes;
            int bits = OS.GetDeviceCaps((long)hDC, (int)12);
            int depth = bits * (planes = OS.GetDeviceCaps((long)hDC, (int)14));
            if (depth < 16) {
                depth = 16;
            }
            this.handle = Image.createDIB(width, height, depth);
        }
        if (this.handle != 0L) {
            long memDC = OS.CreateCompatibleDC((long)hDC);
            long hOldBitmap = OS.SelectObject((long)memDC, (long)this.handle);
            OS.PatBlt((long)memDC, (int)0, (int)0, (int)width, (int)height, (int)15728673);
            OS.SelectObject((long)memDC, (long)hOldBitmap);
            OS.DeleteDC((long)memDC);
        }
        this.device.internal_dispose_GC(hDC, null);
        if (this.handle == 0L) {
            SWT.error(2, null, this.device.getLastError());
        }
    }

    static long createDIB(int width, int height, int depth) {
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)depth;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory((byte[])bmi, (BITMAPINFOHEADER)bmiHeader, (int)BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        return OS.CreateDIBSection((long)0L, (byte[])bmi, (int)0, (long[])pBits, (long)0L, (int)0);
    }

    static long[] init(Device device, Image image, ImageData i) {
        long[] pBits;
        long hDib;
        if (i.depth == 2) {
            ImageData img = new ImageData(i.width, i.height, 4, i.palette);
            ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, null, null, null, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, i.getByteOrder(), 0, 0, img.width, img.height, null, null, null, false, false);
            img.transparentPixel = i.transparentPixel;
            img.maskPad = i.maskPad;
            img.maskData = i.maskData;
            img.alpha = i.alpha;
            img.alphaData = i.alphaData;
            i = img;
        }
        if (i.palette.isDirect) {
            PaletteData palette = i.palette;
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int newDepth = i.depth;
            int newOrder = 1;
            PaletteData newPalette = null;
            switch (i.depth) {
                case 8: {
                    newDepth = 16;
                    newOrder = 0;
                    newPalette = new PaletteData(31744, 992, 31);
                    break;
                }
                case 16: {
                    newOrder = 0;
                    if (redMask == 31744 && greenMask == 992 && blueMask == 31) break;
                    newPalette = new PaletteData(31744, 992, 31);
                    break;
                }
                case 24: {
                    if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) break;
                    newPalette = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) break;
                    newPalette = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (newPalette != null) {
                ImageData img = new ImageData(i.width, i.height, newDepth, newPalette);
                ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, redMask, greenMask, blueMask, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, newOrder, 0, 0, img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
                if (i.transparentPixel != -1) {
                    img.transparentPixel = newPalette.getPixel(palette.getRGB(i.transparentPixel));
                }
                img.maskPad = i.maskPad;
                img.maskData = i.maskData;
                img.alpha = i.alpha;
                img.alphaData = i.alphaData;
                i = img;
            }
        }
        RGB[] rgbs = i.palette.getRGBs();
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = i.width;
        bmiHeader.biHeight = -i.height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)i.depth;
        bmiHeader.biCompression = 0;
        bmiHeader.biClrUsed = rgbs == null ? 0 : rgbs.length;
        byte[] bmi = i.palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof] : new byte[BITMAPINFOHEADER.sizeof + rgbs.length * 4];
        OS.MoveMemory((byte[])bmi, (BITMAPINFOHEADER)bmiHeader, (int)BITMAPINFOHEADER.sizeof);
        int offset = BITMAPINFOHEADER.sizeof;
        if (!i.palette.isDirect) {
            int j = 0;
            while (j < rgbs.length) {
                bmi[offset] = (byte)rgbs[j].blue;
                bmi[offset + 1] = (byte)rgbs[j].green;
                bmi[offset + 2] = (byte)rgbs[j].red;
                bmi[offset + 3] = 0;
                offset += 4;
                ++j;
            }
        }
        if ((hDib = OS.CreateDIBSection((long)0L, (byte[])bmi, (int)0, (long[])(pBits = new long[1]), (long)0L, (int)0)) == 0L) {
            SWT.error(2);
        }
        byte[] data = i.data;
        if (i.scanlinePad != 4 && i.bytesPerLine % 4 != 0) {
            data = ImageData.convertPad(data, i.width, i.height, i.depth, i.scanlinePad, 4);
        }
        OS.MoveMemory((long)pBits[0], (byte[])data, (int)data.length);
        long[] result = null;
        if (i.getTransparencyType() == 2) {
            long hDC = device.internal_new_GC(null);
            long hdcSrc = OS.CreateCompatibleDC((long)hDC);
            OS.SelectObject((long)hdcSrc, (long)hDib);
            long hBitmap = OS.CreateCompatibleBitmap((long)hDC, (int)i.width, (int)i.height);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            long hdcDest = OS.CreateCompatibleDC((long)hDC);
            OS.SelectObject((long)hdcDest, (long)hBitmap);
            OS.BitBlt((long)hdcDest, (int)0, (int)0, (int)i.width, (int)i.height, (long)hdcSrc, (int)0, (int)0, (int)0xCC0020);
            device.internal_dispose_GC(hDC, null);
            byte[] maskData = ImageData.convertPad(i.maskData, i.width, i.height, 1, i.maskPad, 2);
            long hMask = OS.CreateBitmap((int)i.width, (int)i.height, (int)1, (int)1, (byte[])maskData);
            if (hMask == 0L) {
                SWT.error(2);
            }
            OS.SelectObject((long)hdcSrc, (long)hMask);
            OS.PatBlt((long)hdcSrc, (int)0, (int)0, (int)i.width, (int)i.height, (int)0x550009);
            OS.DeleteDC((long)hdcSrc);
            OS.DeleteDC((long)hdcDest);
            OS.DeleteObject((long)hDib);
            if (image == null) {
                result = new long[]{hBitmap, hMask};
            } else {
                ICONINFO info = new ICONINFO();
                info.fIcon = true;
                info.hbmColor = hBitmap;
                info.hbmMask = hMask;
                long hIcon = OS.CreateIconIndirect((ICONINFO)info);
                if (hIcon == 0L) {
                    SWT.error(2);
                }
                OS.DeleteObject((long)hBitmap);
                OS.DeleteObject((long)hMask);
                image.handle = hIcon;
                image.type = 1;
            }
        } else if (image == null) {
            result = new long[]{hDib};
        } else {
            image.handle = hDib;
            image.type = 0;
            image.transparentPixel = i.transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = i.alpha;
                if (i.alpha == -1 && i.alphaData != null) {
                    int length = i.alphaData.length;
                    image.alphaData = new byte[length];
                    System.arraycopy(i.alphaData, 0, image.alphaData, 0, length);
                }
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static long[] init(Device device, Image image, ImageData source, ImageData mask) {
        block13: {
            block12: {
                blackIndex = 0;
                if (!source.palette.isDirect) break block12;
                imageData = new ImageData(source.width, source.height, source.depth, source.palette);
                break block13;
            }
            black = new RGB(0, 0, 0);
            rgbs = source.getRGBs();
            if (source.transparentPixel == -1) ** GOTO lbl27
            newRGBs = new RGB[rgbs.length];
            System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
            if (source.transparentPixel >= newRGBs.length) {
                rgbs = new RGB[source.transparentPixel + 1];
                System.arraycopy(newRGBs, 0, rgbs, 0, newRGBs.length);
                i = newRGBs.length;
                while (i <= source.transparentPixel) {
                    rgbs[i] = new RGB(0, 0, 0);
                    ++i;
                }
            } else {
                newRGBs[source.transparentPixel] = black;
                rgbs = newRGBs;
            }
            blackIndex = source.transparentPixel;
            imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
            break block13;
            while (!rgbs[blackIndex].equals(black)) {
                ++blackIndex;
lbl27:
                // 2 sources

                if (blackIndex < rgbs.length) continue;
            }
            if (blackIndex == rgbs.length) {
                if (1 << source.depth > rgbs.length) {
                    newRGBs = new RGB[rgbs.length + 1];
                    System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
                    newRGBs[rgbs.length] = black;
                    rgbs = newRGBs;
                } else {
                    blackIndex = -1;
                }
            }
            imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
        }
        if (blackIndex == -1) {
            System.arraycopy(source.data, 0, imageData.data, 0, imageData.data.length);
        } else {
            imagePixels = new int[imageData.width];
            maskPixels = new int[mask.width];
            y = 0;
            while (y < imageData.height) {
                source.getPixels(0, y, imageData.width, imagePixels, 0);
                mask.getPixels(0, y, mask.width, maskPixels, 0);
                i = 0;
                while (i < imagePixels.length) {
                    if (maskPixels[i] == 0) {
                        imagePixels[i] = blackIndex;
                    }
                    ++i;
                }
                imageData.setPixels(0, y, source.width, imagePixels, 0);
                ++y;
            }
        }
        imageData.maskPad = mask.scanlinePad;
        imageData.maskData = mask.data;
        return Image.init(device, image, imageData);
    }

    void init(ImageData i) {
        if (i == null) {
            SWT.error(4);
        }
        Image.init(this.device, this, i);
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long hDC = this.device.internal_new_GC(null);
        long imageDC = OS.CreateCompatibleDC((long)hDC);
        this.device.internal_dispose_GC(hDC, null);
        if (imageDC == 0L) {
            SWT.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.image = this;
            data.font = this.device.systemFont;
        }
        return imageDC;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        OS.DeleteDC((long)hDC);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        this.transparentColor = -1;
        long hDC = this.device.internal_new_GC(null);
        BITMAP bm = new BITMAP();
        OS.GetObject((long)this.handle, (int)BITMAP.sizeof, (BITMAP)bm);
        long hdcMem = OS.CreateCompatibleDC((long)hDC);
        OS.SelectObject((long)hdcMem, (long)this.handle);
        int maxColors = 1 << bm.bmBitsPixel;
        byte[] colors = new byte[maxColors * 4];
        int numColors = OS.GetDIBColorTable((long)hdcMem, (int)0, (int)maxColors, (byte[])colors);
        int offset = this.transparentPixel * 4;
        colors[offset] = (byte)color.getBlue();
        colors[offset + 1] = (byte)color.getGreen();
        colors[offset + 2] = (byte)color.getRed();
        OS.SetDIBColorTable((long)hdcMem, (int)0, (int)numColors, (byte[])colors);
        OS.DeleteDC((long)hdcMem);
        this.device.internal_dispose_GC(hDC, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image win32_new(Device device, int type, long handle) {
        Image image = new Image(device);
        image.type = type;
        image.handle = handle;
        return image;
    }
}

