/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.BLENDFUNCTION;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_WIDTH = 16;
    static final int LINE_CAP = 32;
    static final int LINE_JOIN = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_TEXT = 256;
    static final int BACKGROUND_TEXT = 512;
    static final int BRUSH = 1024;
    static final int PEN = 2048;
    static final int NULL_BRUSH = 4096;
    static final int NULL_PEN = 8192;
    static final int DRAW_OFFSET = 16384;
    static final int DRAW = 22777;
    static final int FILL = 9218;
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        long hDC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, hDC);
        this.init();
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    void checkGC(int mask) {
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            long pen = this.data.gdipPen;
            float width = this.data.lineWidth;
            if ((state & 1) != 0 || pen == 0L && (state & 0xF8) != 0) {
                long brush;
                if (this.data.gdipFgBrush != 0L) {
                    Gdip.SolidBrush_delete((long)this.data.gdipFgBrush);
                }
                this.data.gdipFgBrush = 0L;
                Pattern pattern = this.data.foregroundPattern;
                if (pattern != null) {
                    brush = pattern.handle;
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType((long)brush)) {
                            case 2: {
                                brush = Gdip.Brush_Clone((long)brush);
                                if (brush == 0L) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform((long)brush, (float)-1.0f, (float)1.0f, (int)0);
                                this.data.gdipFgBrush = brush;
                            }
                        }
                    }
                } else {
                    int foreground = this.data.foreground;
                    int color = this.data.alpha << 24 | foreground >> 16 & 0xFF | foreground & 0xFF00 | (foreground & 0xFF) << 16;
                    brush = Gdip.SolidBrush_new((int)color);
                    if (brush == 0L) {
                        SWT.error(2);
                    }
                    this.data.gdipFgBrush = brush;
                }
                if (pen != 0L) {
                    Gdip.Pen_SetBrush((long)pen, (long)brush);
                } else {
                    pen = this.data.gdipPen = Gdip.Pen_new((long)brush, (float)width);
                }
            }
            if ((state & 0x10) != 0) {
                Gdip.Pen_SetWidth((long)pen, (float)width);
                switch (this.data.lineStyle) {
                    case 6: {
                        state |= 8;
                    }
                }
            }
            if ((state & 8) != 0) {
                float[] dashes = null;
                float dashOffset = 0.0f;
                int dashStyle = 0;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        dashStyle = 2;
                        if (width != 0.0f) break;
                        dashes = LINE_DOT_ZERO;
                        break;
                    }
                    case 2: {
                        dashStyle = 1;
                        if (width != 0.0f) break;
                        dashes = LINE_DASH_ZERO;
                        break;
                    }
                    case 4: {
                        dashStyle = 3;
                        if (width != 0.0f) break;
                        dashes = LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        dashStyle = 4;
                        if (width != 0.0f) break;
                        dashes = LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        if (this.data.lineDashes == null) break;
                        dashOffset = this.data.lineDashesOffset / Math.max(1.0f, width);
                        dashes = new float[this.data.lineDashes.length * 2];
                        int i = 0;
                        while (i < this.data.lineDashes.length) {
                            float dash;
                            dashes[i] = dash = this.data.lineDashes[i] / Math.max(1.0f, width);
                            dashes[i + this.data.lineDashes.length] = dash;
                            ++i;
                        }
                        break;
                    }
                }
                if (dashes != null) {
                    Gdip.Pen_SetDashPattern((long)pen, dashes, (int)dashes.length);
                    Gdip.Pen_SetDashStyle((long)pen, (int)5);
                    Gdip.Pen_SetDashOffset((long)pen, (float)dashOffset);
                } else {
                    Gdip.Pen_SetDashStyle((long)pen, (int)dashStyle);
                }
            }
            if ((state & 0x80) != 0) {
                Gdip.Pen_SetMiterLimit((long)pen, (float)this.data.lineMiterLimit);
            }
            if ((state & 0x40) != 0) {
                int joinStyle = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        joinStyle = 0;
                        break;
                    }
                    case 3: {
                        joinStyle = 1;
                        break;
                    }
                    case 2: {
                        joinStyle = 2;
                    }
                }
                Gdip.Pen_SetLineJoin((long)pen, (int)joinStyle);
            }
            if ((state & 0x20) != 0) {
                int dashCap = 0;
                int capStyle = 0;
                switch (this.data.lineCap) {
                    case 1: {
                        capStyle = 0;
                        break;
                    }
                    case 2: {
                        capStyle = 2;
                        dashCap = 2;
                        break;
                    }
                    case 3: {
                        capStyle = 1;
                    }
                }
                Gdip.Pen_SetLineCap((long)pen, (int)capStyle, (int)capStyle, (int)dashCap);
            }
            if ((state & 2) != 0) {
                if (this.data.gdipBgBrush != 0L) {
                    Gdip.SolidBrush_delete((long)this.data.gdipBgBrush);
                }
                this.data.gdipBgBrush = 0L;
                Pattern pattern = this.data.backgroundPattern;
                if (pattern != null) {
                    this.data.gdipBrush = pattern.handle;
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType((long)this.data.gdipBrush)) {
                            case 2: {
                                long brush = Gdip.Brush_Clone((long)this.data.gdipBrush);
                                if (brush == 0L) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform((long)brush, (float)-1.0f, (float)1.0f, (int)0);
                                this.data.gdipBrush = this.data.gdipBgBrush = brush;
                            }
                        }
                    }
                } else {
                    int background = this.data.background;
                    int color = this.data.alpha << 24 | background >> 16 & 0xFF | background & 0xFF00 | (background & 0xFF) << 16;
                    long brush = Gdip.SolidBrush_new((int)color);
                    if (brush == 0L) {
                        SWT.error(2);
                    }
                    this.data.gdipBrush = this.data.gdipBgBrush = brush;
                }
            }
            if ((state & 4) != 0) {
                Font font = this.data.font;
                OS.SelectObject((long)this.handle, (long)font.handle);
                long[] hFont = new long[1];
                long gdipFont = GC.createGdipFont(this.handle, font.handle, gdipGraphics, this.device.fontCollection, null, hFont);
                if (hFont[0] != 0L) {
                    OS.SelectObject((long)this.handle, (long)hFont[0]);
                }
                if (this.data.hGDIFont != 0L) {
                    OS.DeleteObject((long)this.data.hGDIFont);
                }
                this.data.hGDIFont = hFont[0];
                if (this.data.gdipFont != 0L) {
                    Gdip.Font_delete((long)this.data.gdipFont);
                }
                this.data.gdipFont = gdipFont;
            }
            if ((state & 0x4000) != 0) {
                float penWidth;
                this.data.gdipYOffset = 0.0f;
                this.data.gdipXOffset = 0.0f;
                long matrix = Gdip.Matrix_new((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                PointF point = new PointF();
                point.Y = 1.0f;
                point.X = 1.0f;
                Gdip.Graphics_GetTransform((long)gdipGraphics, (long)matrix);
                Gdip.Matrix_TransformVectors((long)matrix, (PointF)point, (int)1);
                Gdip.Matrix_delete((long)matrix);
                float scaling = point.X;
                if (scaling < 0.0f) {
                    scaling = -scaling;
                }
                if ((penWidth = this.data.lineWidth * scaling) == 0.0f || (int)penWidth % 2 == 1) {
                    this.data.gdipXOffset = 0.5f / scaling;
                }
                if ((scaling = point.Y) < 0.0f) {
                    scaling = -scaling;
                }
                if ((penWidth = this.data.lineWidth * scaling) == 0.0f || (int)penWidth % 2 == 1) {
                    this.data.gdipYOffset = 0.5f / scaling;
                }
            }
            return;
        }
        if ((state & 0x79) != 0) {
            long newPen;
            int color = this.data.foreground;
            int width = (int)this.data.lineWidth;
            int[] dashes = null;
            int lineStyle = 0;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    lineStyle = 1;
                    break;
                }
                case 3: {
                    lineStyle = 2;
                    break;
                }
                case 4: {
                    lineStyle = 3;
                    break;
                }
                case 5: {
                    lineStyle = 4;
                    break;
                }
                case 6: {
                    if (this.data.lineDashes == null) break;
                    lineStyle = 7;
                    dashes = new int[this.data.lineDashes.length];
                    int i = 0;
                    while (i < dashes.length) {
                        dashes[i] = (int)this.data.lineDashes[i];
                        ++i;
                    }
                    break;
                }
            }
            if ((state & 8) != 0) {
                OS.SetBkMode((long)this.handle, (int)(this.data.lineStyle == 1 ? 2 : 1));
            }
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 8192;
                    break;
                }
                case 2: {
                    joinStyle = 0;
                    break;
                }
                case 3: {
                    joinStyle = 4096;
                }
            }
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 2: {
                    capStyle = 0;
                    break;
                }
                case 1: {
                    capStyle = 512;
                    break;
                }
                case 3: {
                    capStyle = 256;
                }
            }
            int style = lineStyle | joinStyle | capStyle;
            if (width == 0 && lineStyle != 7 || style == 0) {
                newPen = OS.CreatePen((int)(style & 0xF), (int)width, (int)color);
            } else {
                LOGBRUSH logBrush = new LOGBRUSH();
                logBrush.lbStyle = 0;
                logBrush.lbColor = color;
                newPen = OS.ExtCreatePen((int)(style | 0x10000), (int)Math.max(1, width), (LOGBRUSH)logBrush, (int)(dashes != null ? dashes.length : 0), (int[])dashes);
            }
            OS.SelectObject((long)this.handle, (long)newPen);
            this.data.state |= 0x800;
            this.data.state &= 0xFFFFDFFF;
            if (this.data.hPen != 0L) {
                OS.DeleteObject((long)this.data.hPen);
            }
            this.data.hPen = this.data.hOldPen = newPen;
        } else if ((state & 0x800) != 0) {
            OS.SelectObject((long)this.handle, (long)this.data.hOldPen);
            this.data.state &= 0xFFFFDFFF;
        } else if ((state & 0x2000) != 0) {
            this.data.hOldPen = OS.SelectObject((long)this.handle, (long)OS.GetStockObject((int)8));
            this.data.state &= 0xFFFFF7FF;
        }
        if ((state & 2) != 0) {
            long newBrush = OS.CreateSolidBrush((int)this.data.background);
            OS.SelectObject((long)this.handle, (long)newBrush);
            this.data.state |= 0x400;
            this.data.state &= 0xFFFFEFFF;
            if (this.data.hBrush != 0L) {
                OS.DeleteObject((long)this.data.hBrush);
            }
            this.data.hOldBrush = this.data.hBrush = newBrush;
        } else if ((state & 0x400) != 0) {
            OS.SelectObject((long)this.handle, (long)this.data.hOldBrush);
            this.data.state &= 0xFFFFEFFF;
        } else if ((state & 0x1000) != 0) {
            this.data.hOldBrush = OS.SelectObject((long)this.handle, (long)OS.GetStockObject((int)5));
            this.data.state &= 0xFFFFFBFF;
        }
        if ((state & 0x200) != 0) {
            OS.SetBkColor((long)this.handle, (int)this.data.background);
        }
        if ((state & 0x100) != 0) {
            OS.SetTextColor((long)this.handle, (int)this.data.foreground);
        }
        if ((state & 4) != 0) {
            Font font = this.data.font;
            OS.SelectObject((long)this.handle, (long)font.handle);
        }
    }

    public void copyArea(Image image, int x, int y) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.copyAreaInPixels(image, x, y);
    }

    void copyAreaInPixels(Image image, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBoundsInPixels();
        long memHdc = OS.CreateCompatibleDC((long)this.handle);
        long hOldBitmap = OS.SelectObject((long)memHdc, (long)image.handle);
        OS.BitBlt((long)memHdc, (int)0, (int)0, (int)rect.width, (int)rect.height, (long)this.handle, (int)x, (int)y, (int)0xCC0020);
        OS.SelectObject((long)memHdc, (long)hOldBitmap);
        OS.DeleteDC((long)memHdc);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        srcX = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)srcX);
        srcY = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)srcY);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        destX = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)destX);
        destY = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)destY);
        this.copyAreaInPixels(srcX, srcY, width, height, destX, destY, paint);
    }

    void copyAreaInPixels(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        long hwnd;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((hwnd = this.data.hwnd) == 0L) {
            OS.BitBlt((long)this.handle, (int)destX, (int)destY, (int)width, (int)height, (long)this.handle, (int)srcX, (int)srcY, (int)0xCC0020);
        } else {
            RECT lprcClip = null;
            long hrgn = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
            if (OS.GetClipRgn((long)this.handle, (long)hrgn) == 1) {
                lprcClip = new RECT();
                OS.GetRgnBox((long)hrgn, (RECT)lprcClip);
            }
            OS.DeleteObject((long)hrgn);
            RECT lprcScroll = new RECT();
            OS.SetRect((RECT)lprcScroll, (int)srcX, (int)srcY, (int)(srcX + width), (int)(srcY + height));
            int flags = paint ? 6 : 0;
            OS.ScrollWindowEx((long)hwnd, (int)(destX - srcX), (int)(destY - srcY), (RECT)lprcScroll, (RECT)lprcClip, (long)0L, null, (int)flags);
        }
    }

    static long createGdipFont(long hDC, long hFont, long graphics, long fontCollection, long[] outFamily, long[] outFont) {
        long font = Gdip.Font_new((long)hDC, (long)hFont);
        if (font == 0L) {
            SWT.error(2);
        }
        long family = 0L;
        if (!Gdip.Font_IsAvailable((long)font)) {
            Gdip.Font_delete((long)font);
            LOGFONT logFont = new LOGFONT();
            OS.GetObject((long)hFont, (int)LOGFONT.sizeof, (LOGFONT)logFont);
            int size = Math.abs(logFont.lfHeight);
            int style = 0;
            if (logFont.lfWeight == 700) {
                style |= 1;
            }
            if (logFont.lfItalic != 0) {
                style |= 2;
            }
            char[] chars = logFont.lfFaceName;
            int index = 0;
            while (index < chars.length) {
                if (chars[index] == '\u0000') break;
                ++index;
            }
            String name = new String(chars, 0, index);
            if (name.equalsIgnoreCase("Courier")) {
                name = "Courier New";
            }
            char[] buffer = new char[name.length() + 1];
            name.getChars(0, name.length(), buffer, 0);
            if (fontCollection != 0L && !Gdip.FontFamily_IsAvailable((long)(family = Gdip.FontFamily_new((char[])buffer, (long)fontCollection)))) {
                Gdip.FontFamily_delete((long)family);
                family = Gdip.FontFamily_new((char[])buffer, (long)0L);
                if (!Gdip.FontFamily_IsAvailable((long)family)) {
                    Gdip.FontFamily_delete((long)family);
                    family = 0L;
                }
            }
            font = family != 0L ? Gdip.Font_new((long)family, (float)size, (int)style, (int)2) : Gdip.Font_new((char[])buffer, (float)size, (int)style, (int)2, (long)0L);
            if (outFont != null && font != 0L) {
                long hHeap = OS.GetProcessHeap();
                long pLogFont = OS.HeapAlloc((long)hHeap, (int)8, (int)LOGFONT.sizeof);
                Gdip.Font_GetLogFontW((long)font, (long)graphics, (long)pLogFont);
                outFont[0] = OS.CreateFontIndirect((long)pLogFont);
                OS.HeapFree((long)hHeap, (int)0, (long)pLogFont);
            }
        }
        if (outFamily != null && font != 0L) {
            if (family == 0L) {
                family = Gdip.FontFamily_new();
                Gdip.Font_GetFamily((long)font, (long)family);
            }
            outFamily[0] = family;
        } else if (family != 0L) {
            Gdip.FontFamily_delete((long)family);
        }
        if (font == 0L) {
            SWT.error(2);
        }
        return font;
    }

    static void destroyGdipBrush(long brush) {
        int type = Gdip.Brush_GetType((long)brush);
        switch (type) {
            case 0: {
                Gdip.SolidBrush_delete((long)brush);
                break;
            }
            case 1: {
                Gdip.HatchBrush_delete((long)brush);
                break;
            }
            case 4: {
                Gdip.LinearGradientBrush_delete((long)brush);
                break;
            }
            case 2: {
                Gdip.TextureBrush_delete((long)brush);
            }
        }
    }

    @Override
    void destroy() {
        Image image;
        long hNullBitmap;
        boolean gdip = this.data.gdipGraphics != 0L;
        this.disposeGdip();
        if (gdip && (this.data.style & 0x8000000) != 0) {
            OS.SetLayout((long)this.handle, (int)(OS.GetLayout((long)this.handle) | 1));
        }
        if (this.data.hPen != 0L) {
            OS.SelectObject((long)this.handle, (long)OS.GetStockObject((int)8));
            OS.DeleteObject((long)this.data.hPen);
            this.data.hPen = 0L;
        }
        if (this.data.hBrush != 0L) {
            OS.SelectObject((long)this.handle, (long)OS.GetStockObject((int)5));
            OS.DeleteObject((long)this.data.hBrush);
            this.data.hBrush = 0L;
        }
        if ((hNullBitmap = this.data.hNullBitmap) != 0L) {
            OS.SelectObject((long)this.handle, (long)hNullBitmap);
            this.data.hNullBitmap = 0L;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.ps = null;
        this.data = null;
    }

    void disposeGdip() {
        if (this.data.gdipPen != 0L) {
            Gdip.Pen_delete((long)this.data.gdipPen);
        }
        if (this.data.gdipBgBrush != 0L) {
            GC.destroyGdipBrush(this.data.gdipBgBrush);
        }
        if (this.data.gdipFgBrush != 0L) {
            GC.destroyGdipBrush(this.data.gdipFgBrush);
        }
        if (this.data.gdipFont != 0L) {
            Gdip.Font_delete((long)this.data.gdipFont);
        }
        if (this.data.hGDIFont != 0L) {
            OS.DeleteObject((long)this.data.hGDIFont);
        }
        if (this.data.gdipGraphics != 0L) {
            Gdip.Graphics_delete((long)this.data.gdipGraphics);
        }
        this.data.hGDIFont = 0L;
        this.data.gdipPen = 0L;
        this.data.gdipFont = 0L;
        this.data.gdipFgBrush = 0L;
        this.data.gdipBgBrush = 0L;
        this.data.gdipBrush = 0L;
        this.data.gdipGraphics = 0L;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.drawArcInPixels(x, y, width, height, startAngle, arcAngle);
    }

    void drawArcInPixels(int x, int y, int width, int height, int startAngle, int arcAngle) {
        int y1;
        int y2;
        int x1;
        int x2;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(22777);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
            if (width == height) {
                Gdip.Graphics_DrawArc((long)gdipGraphics, (long)this.data.gdipPen, (int)x, (int)y, (int)width, (int)height, (float)(-startAngle), (float)(-arcAngle));
            } else {
                long matrix;
                long path = Gdip.GraphicsPath_new((int)0);
                if (path == 0L) {
                    SWT.error(2);
                }
                if ((matrix = Gdip.Matrix_new((float)width, (float)0.0f, (float)0.0f, (float)height, (float)x, (float)y)) == 0L) {
                    SWT.error(2);
                }
                Gdip.GraphicsPath_AddArc((long)path, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)(-startAngle), (float)(-arcAngle));
                Gdip.GraphicsPath_Transform((long)path, (long)matrix);
                Gdip.Graphics_DrawPath((long)gdipGraphics, (long)this.data.gdipPen, (long)path);
                Gdip.Matrix_delete((long)matrix);
                Gdip.GraphicsPath_delete((long)path);
            }
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x;
        }
        if (arcAngle >= 360 || arcAngle <= -360) {
            x1 = x2 = x + width;
            y1 = y2 = y + height / 2;
        } else {
            boolean isNegative = arcAngle < 0;
            arcAngle += startAngle;
            if (isNegative) {
                int tmp = startAngle;
                startAngle = arcAngle;
                arcAngle = tmp;
            }
            x1 = GC.cos(startAngle, width) + x + width / 2;
            y1 = -1 * GC.sin(startAngle, height) + y + height / 2;
            x2 = GC.cos(arcAngle, width) + x + width / 2;
            y2 = -1 * GC.sin(arcAngle, height) + y + height / 2;
        }
        OS.Arc((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1), (int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void drawFocus(int x, int y, int width, int height) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.drawFocusInPixels(x, y, width, height);
    }

    void drawFocusInPixels(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((this.data.uiState & 1) != 0) {
            return;
        }
        this.data.focusDrawn = true;
        long hdc = this.handle;
        int state = 0;
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            long clipRgn = 0L;
            Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)3);
            long rgn = Gdip.Region_new();
            if (rgn == 0L) {
                SWT.error(2);
            }
            Gdip.Graphics_GetClip((long)gdipGraphics, (long)rgn);
            if (!Gdip.Region_IsInfinite((long)rgn, (long)gdipGraphics)) {
                clipRgn = Gdip.Region_GetHRGN((long)rgn, (long)gdipGraphics);
            }
            Gdip.Region_delete((long)rgn);
            Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)4);
            float[] lpXform = null;
            long matrix = Gdip.Matrix_new((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (matrix == 0L) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform((long)gdipGraphics, (long)matrix);
            if (!Gdip.Matrix_IsIdentity((long)matrix)) {
                lpXform = new float[6];
                Gdip.Matrix_GetElements((long)matrix, (float[])lpXform);
            }
            Gdip.Matrix_delete((long)matrix);
            hdc = Gdip.Graphics_GetHDC((long)gdipGraphics);
            state = OS.SaveDC((long)hdc);
            if (lpXform != null) {
                OS.SetGraphicsMode((long)hdc, (int)2);
                OS.SetWorldTransform((long)hdc, (float[])lpXform);
            }
            if (clipRgn != 0L) {
                OS.SelectClipRgn((long)hdc, (long)clipRgn);
                OS.DeleteObject((long)clipRgn);
            }
        }
        OS.SetBkColor((long)hdc, (int)0xFFFFFF);
        OS.SetTextColor((long)hdc, (int)0);
        RECT rect = new RECT();
        OS.SetRect((RECT)rect, (int)x, (int)y, (int)(x + width), (int)(y + height));
        OS.DrawFocusRect((long)hdc, (RECT)rect);
        if (gdipGraphics != 0L) {
            OS.RestoreDC((long)hdc, (int)state);
            Gdip.Graphics_ReleaseHDC((long)gdipGraphics, (long)hdc);
        } else {
            this.data.state &= 0xFFFFFCFF;
        }
    }

    public void drawImage(Image image, int x, int y) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawImageInPixels(image, x, y);
    }

    void drawImageInPixels(Image image, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle src = DPIUtil.autoScaleUp((Drawable)this.drawable, (Rectangle)new Rectangle(srcX, srcY, srcWidth, srcHeight));
        Rectangle dest = DPIUtil.autoScaleUp((Drawable)this.drawable, (Rectangle)new Rectangle(destX, destY, destWidth, destHeight));
        int deviceZoom = DPIUtil.getDeviceZoom();
        if (deviceZoom != 100) {
            Rectangle b = image.getBoundsInPixels();
            int errX = src.x + src.width - b.width;
            int errY = src.y + src.height - b.height;
            if (errX != 0 || errY != 0) {
                if (errX <= deviceZoom / 100 && errY <= deviceZoom / 100) {
                    src.intersect(b);
                } else {
                    SWT.error(5);
                }
            }
        }
        this.drawImage(image, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        srcImage.refreshImageForZoom();
        if (this.data.gdipGraphics != 0L) {
            long[] gdipImage = srcImage.createGdipImage();
            long img = gdipImage[0];
            int imgWidth = Gdip.Image_GetWidth((long)img);
            int imgHeight = Gdip.Image_GetHeight((long)img);
            if (simple) {
                srcWidth = destWidth = imgWidth;
                srcHeight = destHeight = imgHeight;
            } else {
                if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                    SWT.error(5);
                }
                simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            }
            Rect rect = new Rect();
            rect.X = destX;
            rect.Y = destY;
            rect.Width = destWidth;
            rect.Height = destHeight;
            long attrib = Gdip.ImageAttributes_new();
            Gdip.ImageAttributes_SetWrapMode((long)attrib, (int)3);
            if (this.data.alpha != 255) {
                float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (float)this.data.alpha / 255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                Gdip.ImageAttributes_SetColorMatrix((long)attrib, (float[])matrix, (int)0, (int)1);
            }
            int gstate = 0;
            if ((this.data.style & 0x8000000) != 0) {
                gstate = Gdip.Graphics_Save((long)this.data.gdipGraphics);
                Gdip.Graphics_ScaleTransform((long)this.data.gdipGraphics, (float)-1.0f, (float)1.0f, (int)0);
                Gdip.Graphics_TranslateTransform((long)this.data.gdipGraphics, (float)(-2 * destX - destWidth), (float)0.0f, (int)0);
            }
            Gdip.Graphics_DrawImage((long)this.data.gdipGraphics, (long)img, (Rect)rect, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)2, (long)attrib, (long)0L, (long)0L);
            if ((this.data.style & 0x8000000) != 0) {
                Gdip.Graphics_Restore((long)this.data.gdipGraphics, (int)gstate);
            }
            Gdip.ImageAttributes_delete((long)attrib);
            Gdip.Bitmap_delete((long)img);
            if (gdipImage[1] != 0L) {
                long hHeap = OS.GetProcessHeap();
                OS.HeapFree((long)hHeap, (int)0, (long)gdipImage[1]);
            }
            return;
        }
        switch (srcImage.type) {
            case 0: {
                this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            case 1: {
                this.drawIcon(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
            }
        }
    }

    void drawIcon(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        boolean failed;
        int technology = OS.GetDeviceCaps((long)this.handle, (int)2);
        boolean drawIcon = true;
        int flags = 3;
        int offsetX = 0;
        int offsetY = 0;
        if ((OS.GetLayout((long)this.handle) & 1) != 0) {
            flags |= 0x10;
            POINT pt = new POINT();
            OS.GetWindowOrgEx((long)this.handle, (POINT)pt);
            offsetX = pt.x;
            offsetY = pt.y;
        }
        if (simple && technology != 2 && drawIcon) {
            if (offsetX != 0 || offsetY != 0) {
                OS.SetWindowOrgEx((long)this.handle, (int)0, (int)0, null);
            }
            OS.DrawIconEx((long)this.handle, (int)(destX - offsetX), (int)(destY - offsetY), (long)srcImage.handle, (int)0, (int)0, (int)0, (long)0L, (int)flags);
            if (offsetX != 0 || offsetY != 0) {
                OS.SetWindowOrgEx((long)this.handle, (int)offsetX, (int)offsetY, null);
            }
            return;
        }
        ICONINFO srcIconInfo = new ICONINFO();
        OS.GetIconInfo((long)srcImage.handle, (ICONINFO)srcIconInfo);
        long hBitmap = srcIconInfo.hbmColor;
        if (hBitmap == 0L) {
            hBitmap = srcIconInfo.hbmMask;
        }
        BITMAP bm = new BITMAP();
        OS.GetObject((long)hBitmap, (int)BITMAP.sizeof, (BITMAP)bm);
        int iconWidth = bm.bmWidth;
        int iconHeight = bm.bmHeight;
        if (hBitmap == srcIconInfo.hbmMask) {
            iconHeight /= 2;
        }
        if (simple) {
            srcWidth = destWidth = iconWidth;
            srcHeight = destHeight = iconHeight;
        }
        boolean bl = failed = srcX + srcWidth > iconWidth || srcY + srcHeight > iconHeight;
        if (!failed) {
            boolean bl2 = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && srcHeight == destHeight && srcWidth == iconWidth && srcHeight == iconHeight;
            if (!drawIcon) {
                this.drawBitmapMask(srcImage, srcIconInfo.hbmColor, srcIconInfo.hbmMask, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, iconWidth, iconHeight, false);
            } else if (simple && technology != 2) {
                if (offsetX != 0 || offsetY != 0) {
                    OS.SetWindowOrgEx((long)this.handle, (int)0, (int)0, null);
                }
                OS.DrawIconEx((long)this.handle, (int)(destX - offsetX), (int)(destY - offsetY), (long)srcImage.handle, (int)0, (int)0, (int)0, (long)0L, (int)flags);
                if (offsetX != 0 || offsetY != 0) {
                    OS.SetWindowOrgEx((long)this.handle, (int)offsetX, (int)offsetY, null);
                }
            } else {
                boolean stretch;
                ICONINFO newIconInfo = new ICONINFO();
                newIconInfo.fIcon = true;
                long srcHdc = OS.CreateCompatibleDC((long)this.handle);
                long dstHdc = OS.CreateCompatibleDC((long)this.handle);
                int srcColorY = srcY;
                long srcColor = srcIconInfo.hbmColor;
                if (srcColor == 0L) {
                    srcColor = srcIconInfo.hbmMask;
                    srcColorY += iconHeight;
                }
                long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)srcColor);
                newIconInfo.hbmColor = OS.CreateCompatibleBitmap((long)srcHdc, (int)destWidth, (int)destHeight);
                if (newIconInfo.hbmColor == 0L) {
                    SWT.error(2);
                }
                long oldDestBitmap = OS.SelectObject((long)dstHdc, (long)newIconInfo.hbmColor);
                boolean bl3 = stretch = !simple && (srcWidth != destWidth || srcHeight != destHeight);
                if (stretch) {
                    OS.SetStretchBltMode((long)dstHdc, (int)3);
                    OS.StretchBlt((long)dstHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcColorY, (int)srcWidth, (int)srcHeight, (int)0xCC0020);
                } else {
                    OS.BitBlt((long)dstHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcColorY, (int)0xCC0020);
                }
                OS.SelectObject((long)srcHdc, (long)srcIconInfo.hbmMask);
                newIconInfo.hbmMask = OS.CreateBitmap((int)destWidth, (int)destHeight, (int)1, (int)1, null);
                if (newIconInfo.hbmMask == 0L) {
                    SWT.error(2);
                }
                OS.SelectObject((long)dstHdc, (long)newIconInfo.hbmMask);
                if (stretch) {
                    OS.StretchBlt((long)dstHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)0xCC0020);
                } else {
                    OS.BitBlt((long)dstHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)0xCC0020);
                }
                if (technology == 2) {
                    OS.SelectObject((long)srcHdc, (long)newIconInfo.hbmColor);
                    OS.SelectObject((long)dstHdc, (long)newIconInfo.hbmMask);
                    this.drawBitmapTransparentByClipping(srcHdc, dstHdc, 0, 0, destWidth, destHeight, destX, destY, destWidth, destHeight, true, destWidth, destHeight);
                    OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
                    OS.SelectObject((long)dstHdc, (long)oldDestBitmap);
                } else {
                    OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
                    OS.SelectObject((long)dstHdc, (long)oldDestBitmap);
                    long hIcon = OS.CreateIconIndirect((ICONINFO)newIconInfo);
                    if (hIcon == 0L) {
                        SWT.error(2);
                    }
                    if (offsetX != 0 || offsetY != 0) {
                        OS.SetWindowOrgEx((long)this.handle, (int)0, (int)0, null);
                    }
                    OS.DrawIconEx((long)this.handle, (int)(destX - offsetX), (int)(destY - offsetY), (long)hIcon, (int)destWidth, (int)destHeight, (int)0, (long)0L, (int)flags);
                    if (offsetX != 0 || offsetY != 0) {
                        OS.SetWindowOrgEx((long)this.handle, (int)offsetX, (int)offsetY, null);
                    }
                    OS.DestroyIcon((long)hIcon);
                }
                OS.DeleteObject((long)newIconInfo.hbmMask);
                OS.DeleteObject((long)newIconInfo.hbmColor);
                OS.DeleteDC((long)dstHdc);
                OS.DeleteDC((long)srcHdc);
            }
        }
        OS.DeleteObject((long)srcIconInfo.hbmMask);
        if (srcIconInfo.hbmColor != 0L) {
            OS.DeleteObject((long)srcIconInfo.hbmColor);
        }
        if (failed) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        BITMAP bm = new BITMAP();
        OS.GetObject((long)srcImage.handle, (int)BITMAP.sizeof, (BITMAP)bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
        }
        boolean mustRestore = false;
        GC memGC = srcImage.memGC;
        if (memGC != null && !memGC.isDisposed()) {
            memGC.flush();
            mustRestore = true;
            GCData data = memGC.data;
            if (data.hNullBitmap != 0L) {
                OS.SelectObject((long)memGC.handle, (long)data.hNullBitmap);
                data.hNullBitmap = 0L;
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawBitmapAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1) {
            this.drawBitmapTransparent(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        }
        if (mustRestore) {
            long hOldBitmap;
            memGC.data.hNullBitmap = hOldBitmap = OS.SelectObject((long)memGC.handle, (long)srcImage.handle);
        }
    }

    void drawBitmapAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        boolean hasAlphaChannel;
        int caps;
        boolean isPrinter;
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
            return;
        }
        boolean alphaBlendSupport = true;
        boolean bl = isPrinter = OS.GetDeviceCaps((long)this.handle, (int)2) == 2;
        if (isPrinter && (caps = OS.GetDeviceCaps((long)this.handle, (int)120)) != 0) {
            if (srcImage.alpha != -1) {
                alphaBlendSupport = (caps & 1) != 0;
            } else {
                boolean bl2 = alphaBlendSupport = (caps & 2) != 0;
            }
        }
        if (alphaBlendSupport) {
            BLENDFUNCTION blend = new BLENDFUNCTION();
            blend.BlendOp = 0;
            long srcHdc = OS.CreateCompatibleDC((long)this.handle);
            long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)srcImage.handle);
            if (srcImage.alpha != -1) {
                blend.SourceConstantAlpha = (byte)srcImage.alpha;
                OS.AlphaBlend((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (BLENDFUNCTION)blend);
            } else {
                long memDib = Image.createDIB(srcWidth, srcHeight, 32);
                if (memDib == 0L) {
                    SWT.error(2);
                }
                long memHdc = OS.CreateCompatibleDC((long)this.handle);
                long oldMemBitmap = OS.SelectObject((long)memHdc, (long)memDib);
                BITMAP dibBM = new BITMAP();
                OS.GetObject((long)memDib, (int)BITMAP.sizeof, (BITMAP)dibBM);
                OS.BitBlt((long)memHdc, (int)0, (int)0, (int)srcWidth, (int)srcHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)0xCC0020);
                byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
                OS.MoveMemory((byte[])srcData, (long)dibBM.bmBits, (int)srcData.length);
                int apinc = imgWidth - srcWidth;
                int ap = srcY * imgWidth + srcX;
                int sp = 0;
                byte[] alphaData = srcImage.alphaData;
                int y = 0;
                while (y < srcHeight) {
                    int x = 0;
                    while (x < srcWidth) {
                        int alpha = alphaData[ap++] & 0xFF;
                        int r = (srcData[sp + 0] & 0xFF) * alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (srcData[sp + 1] & 0xFF) * alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (srcData[sp + 2] & 0xFF) * alpha + 128;
                        b = b + (b >> 8) >> 8;
                        srcData[sp + 0] = (byte)r;
                        srcData[sp + 1] = (byte)g;
                        srcData[sp + 2] = (byte)b;
                        srcData[sp + 3] = (byte)alpha;
                        sp += 4;
                        ++x;
                    }
                    ap += apinc;
                    ++y;
                }
                OS.MoveMemory((long)dibBM.bmBits, (byte[])srcData, (int)srcData.length);
                blend.SourceConstantAlpha = (byte)-1;
                blend.AlphaFormat = 1;
                OS.AlphaBlend((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)memHdc, (int)0, (int)0, (int)srcWidth, (int)srcHeight, (BLENDFUNCTION)blend);
                OS.SelectObject((long)memHdc, (long)oldMemBitmap);
                OS.DeleteDC((long)memHdc);
                OS.DeleteObject((long)memDib);
            }
            OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
            OS.DeleteDC((long)srcHdc);
            return;
        }
        Rectangle rect = this.getClippingInPixels();
        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
            return;
        }
        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
        destX = rect.x;
        destY = rect.y;
        destWidth = rect.width;
        destHeight = rect.height;
        srcX = sx1;
        srcY = sy1;
        srcWidth = Math.max(1, sx2 - sx1);
        srcHeight = Math.max(1, sy2 - sy1);
        long srcHdc = OS.CreateCompatibleDC((long)this.handle);
        long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)srcImage.handle);
        long memHdc = OS.CreateCompatibleDC((long)this.handle);
        long memDib = Image.createDIB(Math.max(srcWidth, destWidth), Math.max(srcHeight, destHeight), 32);
        if (memDib == 0L) {
            SWT.error(2);
        }
        long oldMemBitmap = OS.SelectObject((long)memHdc, (long)memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject((long)memDib, (int)BITMAP.sizeof, (BITMAP)dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt((long)memHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)this.handle, (int)destX, (int)destY, (int)0xCC0020);
        byte[] destData = new byte[sizeInBytes];
        OS.MoveMemory((byte[])destData, (long)dibBM.bmBits, (int)sizeInBytes);
        OS.BitBlt((long)memHdc, (int)0, (int)0, (int)srcWidth, (int)srcHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)0xCC0020);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory((byte[])srcData, (long)dibBM.bmBits, (int)sizeInBytes);
        int alpha = srcImage.alpha;
        boolean bl3 = hasAlphaChannel = srcImage.alpha == -1;
        if (hasAlphaChannel) {
            int apinc = imgWidth - srcWidth;
            int spinc = dibBM.bmWidthBytes - srcWidth * 4;
            int ap = srcY * imgWidth + srcX;
            int sp = 3;
            byte[] alphaData = srcImage.alphaData;
            int y = 0;
            while (y < srcHeight) {
                int x = 0;
                while (x < srcWidth) {
                    srcData[sp] = alphaData[ap++];
                    sp += 4;
                    ++x;
                }
                ap += apinc;
                sp += spinc;
                ++y;
            }
        }
        OS.MoveMemory((long)dibBM.bmBits, (byte[])srcData, (int)sizeInBytes);
        if (isPrinter) {
            long tempHdc = OS.CreateCompatibleDC((long)this.handle);
            long tempDib = Image.createDIB(destWidth, destHeight, 32);
            if (tempDib == 0L) {
                SWT.error(2);
            }
            long oldTempBitmap = OS.SelectObject((long)tempHdc, (long)tempDib);
            if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                OS.SetStretchBltMode((long)memHdc, (int)3);
                OS.StretchBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)memHdc, (int)0, (int)0, (int)srcWidth, (int)srcHeight, (int)0xCC0020);
            } else {
                OS.BitBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)memHdc, (int)0, (int)0, (int)0xCC0020);
            }
            OS.BitBlt((long)memHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)tempHdc, (int)0, (int)0, (int)0xCC0020);
            OS.SelectObject((long)tempHdc, (long)oldTempBitmap);
            OS.DeleteObject((long)tempDib);
            OS.DeleteDC((long)tempHdc);
        } else if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            OS.SetStretchBltMode((long)memHdc, (int)3);
            OS.StretchBlt((long)memHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)memHdc, (int)0, (int)0, (int)srcWidth, (int)srcHeight, (int)0xCC0020);
        } else {
            OS.BitBlt((long)memHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)memHdc, (int)0, (int)0, (int)0xCC0020);
        }
        OS.MoveMemory((byte[])srcData, (long)dibBM.bmBits, (int)sizeInBytes);
        int dpinc = dibBM.bmWidthBytes - destWidth * 4;
        int dp = 0;
        int y = 0;
        while (y < destHeight) {
            int x = 0;
            while (x < destWidth) {
                if (hasAlphaChannel) {
                    alpha = srcData[dp + 3] & 0xFF;
                }
                int n = dp;
                destData[n] = (byte)(destData[n] + ((srcData[dp] & 0xFF) - (destData[dp] & 0xFF)) * alpha / 255);
                int n2 = dp + 1;
                destData[n2] = (byte)(destData[n2] + ((srcData[dp + 1] & 0xFF) - (destData[dp + 1] & 0xFF)) * alpha / 255);
                int n3 = dp + 2;
                destData[n3] = (byte)(destData[n3] + ((srcData[dp + 2] & 0xFF) - (destData[dp + 2] & 0xFF)) * alpha / 255);
                dp += 4;
                ++x;
            }
            dp += dpinc;
            ++y;
        }
        OS.MoveMemory((long)dibBM.bmBits, (byte[])destData, (int)sizeInBytes);
        OS.BitBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)memHdc, (int)0, (int)0, (int)0xCC0020);
        OS.SelectObject((long)memHdc, (long)oldMemBitmap);
        OS.DeleteDC((long)memHdc);
        OS.DeleteObject((long)memDib);
        OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
        OS.DeleteDC((long)srcHdc);
    }

    void drawBitmapTransparentByClipping(long srcHdc, long maskHdc, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int dwRop;
        long rgn = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
        int y = 0;
        while (y < imgHeight) {
            int x = 0;
            while (x < imgWidth) {
                if (OS.GetPixel((long)maskHdc, (int)x, (int)y) == 0) {
                    long tempRgn = OS.CreateRectRgn((int)x, (int)y, (int)(x + 1), (int)(y + 1));
                    OS.CombineRgn((long)rgn, (long)rgn, (long)tempRgn, (int)2);
                    OS.DeleteObject((long)tempRgn);
                }
                ++x;
            }
            ++y;
        }
        if (destWidth != srcWidth || destHeight != srcHeight) {
            int nBytes = OS.GetRegionData((long)rgn, (int)0, null);
            int[] lpRgnData = new int[nBytes / 4];
            OS.GetRegionData((long)rgn, (int)nBytes, (int[])lpRgnData);
            float[] lpXform = new float[]{(float)destWidth / (float)srcWidth, 0.0f, 0.0f, (float)destHeight / (float)srcHeight, 0.0f, 0.0f};
            long tmpRgn = OS.ExtCreateRegion((float[])lpXform, (int)nBytes, (int[])lpRgnData);
            OS.DeleteObject((long)rgn);
            rgn = tmpRgn;
        }
        OS.OffsetRgn((long)rgn, (int)destX, (int)destY);
        long clip = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
        int result = OS.GetClipRgn((long)this.handle, (long)clip);
        if (result == 1) {
            OS.CombineRgn((long)rgn, (long)rgn, (long)clip, (int)1);
        }
        OS.SelectClipRgn((long)this.handle, (long)rgn);
        int n = dwRop = OS.GetROP2((long)this.handle) == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = OS.SetStretchBltMode((long)this.handle, (int)3);
            OS.StretchBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)dwRop);
            OS.SetStretchBltMode((long)this.handle, (int)mode);
        } else {
            OS.BitBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)dwRop);
        }
        OS.SelectClipRgn((long)this.handle, (long)(result == 1 ? clip : 0L));
        OS.DeleteObject((long)clip);
        OS.DeleteObject((long)rgn);
    }

    void drawBitmapMask(Image srcImage, long srcColor, long srcMask, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, boolean offscreen) {
        int srcColorY = srcY;
        if (srcColor == 0L) {
            srcColor = srcMask;
            srcColorY += imgHeight;
        }
        long srcHdc = OS.CreateCompatibleDC((long)this.handle);
        long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)srcColor);
        long destHdc = this.handle;
        int x = destX;
        int y = destY;
        long tempHdc = 0L;
        long tempBitmap = 0L;
        long oldTempBitmap = 0L;
        int oldBkColor = 0;
        int oldTextColor = 0;
        if (offscreen) {
            tempHdc = OS.CreateCompatibleDC((long)this.handle);
            tempBitmap = OS.CreateCompatibleBitmap((long)this.handle, (int)destWidth, (int)destHeight);
            oldTempBitmap = OS.SelectObject((long)tempHdc, (long)tempBitmap);
            OS.BitBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)this.handle, (int)destX, (int)destY, (int)0xCC0020);
            destHdc = tempHdc;
            y = 0;
            x = 0;
        } else {
            oldBkColor = OS.SetBkColor((long)this.handle, (int)0xFFFFFF);
            oldTextColor = OS.SetTextColor((long)this.handle, (int)0);
        }
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = OS.SetStretchBltMode((long)this.handle, (int)3);
            OS.StretchBlt((long)destHdc, (int)x, (int)y, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcColorY, (int)srcWidth, (int)srcHeight, (int)0x660046);
            OS.SelectObject((long)srcHdc, (long)srcMask);
            OS.StretchBlt((long)destHdc, (int)x, (int)y, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)8913094);
            OS.SelectObject((long)srcHdc, (long)srcColor);
            OS.StretchBlt((long)destHdc, (int)x, (int)y, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcColorY, (int)srcWidth, (int)srcHeight, (int)0x660046);
            OS.SetStretchBltMode((long)this.handle, (int)mode);
        } else {
            OS.BitBlt((long)destHdc, (int)x, (int)y, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcColorY, (int)0x660046);
            OS.SetTextColor((long)destHdc, (int)0);
            OS.SelectObject((long)srcHdc, (long)srcMask);
            OS.BitBlt((long)destHdc, (int)x, (int)y, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)8913094);
            OS.SelectObject((long)srcHdc, (long)srcColor);
            OS.BitBlt((long)destHdc, (int)x, (int)y, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcColorY, (int)0x660046);
        }
        if (offscreen) {
            OS.BitBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)tempHdc, (int)0, (int)0, (int)0xCC0020);
            OS.SelectObject((long)tempHdc, (long)oldTempBitmap);
            OS.DeleteDC((long)tempHdc);
            OS.DeleteObject((long)tempBitmap);
        } else {
            OS.SetBkColor((long)this.handle, (int)oldBkColor);
            OS.SetTextColor((long)this.handle, (int)oldTextColor);
        }
        OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
        OS.DeleteDC((long)srcHdc);
    }

    void drawBitmapTransparent(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        boolean isDib = bm.bmBits != 0L;
        long hBitmap = srcImage.handle;
        long srcHdc = OS.CreateCompatibleDC((long)this.handle);
        long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)hBitmap);
        byte[] originalColors = null;
        int transparentColor = srcImage.transparentColor;
        if (transparentColor == -1) {
            int transBlue = 0;
            int transGreen = 0;
            int transRed = 0;
            boolean fixPalette = false;
            if (bm.bmBitsPixel <= 8) {
                if (isDib) {
                    int maxColors = 1 << bm.bmBitsPixel;
                    byte[] oldColors = new byte[maxColors * 4];
                    OS.GetDIBColorTable((long)srcHdc, (int)0, (int)maxColors, (byte[])oldColors);
                    int offset = srcImage.transparentPixel * 4;
                    int i = 0;
                    while (i < oldColors.length) {
                        if (i != offset && oldColors[offset] == oldColors[i] && oldColors[offset + 1] == oldColors[i + 1] && oldColors[offset + 2] == oldColors[i + 2]) {
                            fixPalette = true;
                            break;
                        }
                        i += 4;
                    }
                    if (fixPalette) {
                        byte[] newColors = new byte[oldColors.length];
                        transBlue = 255;
                        transGreen = 255;
                        transRed = 255;
                        newColors[offset] = (byte)transBlue;
                        newColors[offset + 1] = (byte)transGreen;
                        newColors[offset + 2] = (byte)transRed;
                        OS.SetDIBColorTable((long)srcHdc, (int)0, (int)maxColors, (byte[])newColors);
                        originalColors = oldColors;
                    } else {
                        transBlue = oldColors[offset] & 0xFF;
                        transGreen = oldColors[offset + 1] & 0xFF;
                        transRed = oldColors[offset + 2] & 0xFF;
                    }
                } else {
                    int numColors = 1 << bm.bmBitsPixel;
                    BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biPlanes = bm.bmPlanes;
                    bmiHeader.biBitCount = bm.bmBitsPixel;
                    byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                    OS.MoveMemory((byte[])bmi, (BITMAPINFOHEADER)bmiHeader, (int)BITMAPINFOHEADER.sizeof);
                    OS.GetDIBits((long)srcHdc, (long)srcImage.handle, (int)0, (int)0, null, (byte[])bmi, (int)0);
                    int offset = BITMAPINFOHEADER.sizeof + 4 * srcImage.transparentPixel;
                    transRed = bmi[offset + 2] & 0xFF;
                    transGreen = bmi[offset + 1] & 0xFF;
                    transBlue = bmi[offset] & 0xFF;
                }
            } else {
                int pixel = srcImage.transparentPixel;
                switch (bm.bmBitsPixel) {
                    case 16: {
                        transBlue = (pixel & 0x1F) << 3;
                        transGreen = (pixel & 0x3E0) >> 2;
                        transRed = (pixel & 0x7C00) >> 7;
                        break;
                    }
                    case 24: {
                        transBlue = (pixel & 0xFF0000) >> 16;
                        transGreen = (pixel & 0xFF00) >> 8;
                        transRed = pixel & 0xFF;
                        break;
                    }
                    case 32: {
                        transBlue = (pixel & 0xFF000000) >>> 24;
                        transGreen = (pixel & 0xFF0000) >> 16;
                        transRed = (pixel & 0xFF00) >> 8;
                    }
                }
            }
            transparentColor = transBlue << 16 | transGreen << 8 | transRed;
            if (!fixPalette) {
                srcImage.transparentColor = transparentColor;
            }
        }
        if (originalColors == null) {
            int mode = OS.SetStretchBltMode((long)this.handle, (int)3);
            OS.TransparentBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)transparentColor);
            OS.SetStretchBltMode((long)this.handle, (int)mode);
        } else {
            long maskHdc = OS.CreateCompatibleDC((long)this.handle);
            long maskBitmap = OS.CreateBitmap((int)imgWidth, (int)imgHeight, (int)1, (int)1, null);
            long oldMaskBitmap = OS.SelectObject((long)maskHdc, (long)maskBitmap);
            OS.SetBkColor((long)srcHdc, (int)transparentColor);
            OS.BitBlt((long)maskHdc, (int)0, (int)0, (int)imgWidth, (int)imgHeight, (long)srcHdc, (int)0, (int)0, (int)0xCC0020);
            if (originalColors != null) {
                OS.SetDIBColorTable((long)srcHdc, (int)0, (int)(1 << bm.bmBitsPixel), originalColors);
            }
            if (OS.GetDeviceCaps((long)this.handle, (int)2) == 2) {
                this.drawBitmapTransparentByClipping(srcHdc, maskHdc, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            } else {
                long tempHdc = OS.CreateCompatibleDC((long)this.handle);
                long tempBitmap = OS.CreateCompatibleBitmap((long)this.handle, (int)destWidth, (int)destHeight);
                long oldTempBitmap = OS.SelectObject((long)tempHdc, (long)tempBitmap);
                OS.BitBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)this.handle, (int)destX, (int)destY, (int)0xCC0020);
                if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                    OS.SetStretchBltMode((long)tempHdc, (int)3);
                    OS.StretchBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)0x660046);
                    OS.StretchBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)maskHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)8913094);
                    OS.StretchBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)0x660046);
                } else {
                    OS.BitBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)0x660046);
                    OS.BitBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)maskHdc, (int)srcX, (int)srcY, (int)8913094);
                    OS.BitBlt((long)tempHdc, (int)0, (int)0, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)0x660046);
                }
                OS.BitBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)tempHdc, (int)0, (int)0, (int)0xCC0020);
                OS.SelectObject((long)tempHdc, (long)oldTempBitmap);
                OS.DeleteDC((long)tempHdc);
                OS.DeleteObject((long)tempBitmap);
            }
            OS.SelectObject((long)maskHdc, (long)oldMaskBitmap);
            OS.DeleteDC((long)maskHdc);
            OS.DeleteObject((long)maskBitmap);
        }
        OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
        if (hBitmap != srcImage.handle) {
            OS.DeleteObject((long)hBitmap);
        }
        OS.DeleteDC((long)srcHdc);
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        int dwRop;
        long srcHdc = OS.CreateCompatibleDC((long)this.handle);
        long oldSrcBitmap = OS.SelectObject((long)srcHdc, (long)srcImage.handle);
        int n = dwRop = OS.GetROP2((long)this.handle) == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = OS.SetStretchBltMode((long)this.handle, (int)3);
            OS.StretchBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)dwRop);
            OS.SetStretchBltMode((long)this.handle, (int)mode);
        } else {
            OS.BitBlt((long)this.handle, (int)destX, (int)destY, (int)destWidth, (int)destHeight, (long)srcHdc, (int)srcX, (int)srcY, (int)dwRop);
        }
        OS.SelectObject((long)srcHdc, (long)oldSrcBitmap);
        OS.DeleteDC((long)srcHdc);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        x1 = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x1);
        x2 = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x2);
        y1 = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y1);
        y2 = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y2);
        this.drawLineInPixels(x1, y1, x2, y2);
    }

    void drawLineInPixels(int x1, int y1, int x2, int y2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
            Gdip.Graphics_DrawLine((long)gdipGraphics, (long)this.data.gdipPen, (int)x1, (int)y1, (int)x2, (int)y2);
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x1;
            --x2;
        }
        OS.MoveToEx((long)this.handle, (int)x1, (int)y1, (long)0L);
        OS.LineTo((long)this.handle, (int)x2, (int)y2);
        if (this.data.lineWidth <= 1.0f) {
            OS.SetPixel((long)this.handle, (int)x2, (int)y2, (int)this.data.foreground);
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.drawOvalInPixels(x, y, width, height);
    }

    void drawOvalInPixels(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
            Gdip.Graphics_DrawEllipse((long)gdipGraphics, (long)this.data.gdipPen, (int)x, (int)y, (int)width, (int)height);
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x;
        }
        OS.Ellipse((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1));
    }

    public void drawPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initGdip();
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
        Gdip.Graphics_DrawPath((long)gdipGraphics, (long)this.data.gdipPen, (long)path.handle);
        Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
    }

    public void drawPoint(int x, int y) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawPointInPixels(x, y);
    }

    void drawPointInPixels(int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics != 0L) {
            this.checkGC(22777);
            Gdip.Graphics_FillRectangle((long)this.data.gdipGraphics, (long)this.getFgBrush(), (int)x, (int)y, (int)1, (int)1);
            return;
        }
        OS.SetPixel((long)this.handle, (int)x, (int)y, (int)this.data.foreground);
    }

    public void drawPolygon(int[] pointArray) {
        if (pointArray == null) {
            SWT.error(4);
        }
        this.drawPolygonInPixels(DPIUtil.autoScaleUp((Drawable)this.drawable, (int[])pointArray));
    }

    void drawPolygonInPixels(int[] pointArray) {
        int i;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
            Gdip.Graphics_DrawPolygon((long)gdipGraphics, (long)this.data.gdipPen, (int[])pointArray, (int)(pointArray.length / 2));
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            i = 0;
            while (i < pointArray.length) {
                int n = i;
                pointArray[n] = pointArray[n] - 1;
                i += 2;
            }
        }
        OS.Polygon((long)this.handle, (int[])pointArray, (int)(pointArray.length / 2));
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            i = 0;
            while (i < pointArray.length) {
                int n = i;
                pointArray[n] = pointArray[n] + 1;
                i += 2;
            }
        }
    }

    public void drawPolyline(int[] pointArray) {
        this.drawPolylineInPixels(DPIUtil.autoScaleUp((Drawable)this.drawable, (int[])pointArray));
    }

    void drawPolylineInPixels(int[] pointArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
            Gdip.Graphics_DrawLines((long)gdipGraphics, (long)this.data.gdipPen, (int[])pointArray, (int)(pointArray.length / 2));
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            int i = 0;
            while (i < pointArray.length) {
                int n = i;
                pointArray[n] = pointArray[n] - 1;
                i += 2;
            }
        }
        OS.Polyline((long)this.handle, (int[])pointArray, (int)(pointArray.length / 2));
        int length = pointArray.length;
        if (length >= 2 && this.data.lineWidth <= 1.0f) {
            OS.SetPixel((long)this.handle, (int)pointArray[length - 2], (int)pointArray[length - 1], (int)this.data.foreground);
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            int i = 0;
            while (i < pointArray.length) {
                int n = i;
                pointArray[n] = pointArray[n] + 1;
                i += 2;
            }
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.drawRectangleInPixels(x, y, width, height);
    }

    void drawRectangleInPixels(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
            Gdip.Graphics_DrawRectangle((long)gdipGraphics, (long)this.data.gdipPen, (int)x, (int)y, (int)width, (int)height);
            Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            if (this.data.lineWidth > 1.0f) {
                if (this.data.lineWidth % 2.0f == 1.0f) {
                    ++x;
                }
            } else if (this.data.hPen != 0L && OS.GetObject((long)this.data.hPen, (int)0, (long)0L) != LOGPEN.sizeof) {
                ++x;
            }
        }
        OS.Rectangle((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1));
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        rect = DPIUtil.autoScaleUp((Drawable)this.drawable, (Rectangle)rect);
        this.drawRectangleInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        arcWidth = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)arcWidth);
        arcHeight = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)arcHeight);
        this.drawRoundRectangleInPixels(x, y, width, height, arcWidth, arcHeight);
    }

    void drawRoundRectangleInPixels(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(22777);
        if (this.data.gdipGraphics != 0L) {
            this.drawRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipPen, x, y, width, height, arcWidth, arcHeight);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x;
        }
        OS.RoundRect((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1), (int)arcWidth, (int)arcHeight);
    }

    void drawRoundRectangleGdip(long gdipGraphics, long pen, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)this.data.gdipXOffset, (float)this.data.gdipYOffset, (int)0);
        if (naw == 0 || nah == 0) {
            Gdip.Graphics_DrawRectangle((long)gdipGraphics, (long)this.data.gdipPen, (int)x, (int)y, (int)width, (int)height);
        } else {
            long path = Gdip.GraphicsPath_new((int)0);
            if (path == 0L) {
                SWT.error(2);
            }
            if (nw > naw) {
                if (nh > nah) {
                    Gdip.GraphicsPath_AddArc((long)path, (float)(nx + nw - naw), (float)ny, (float)naw, (float)nah, (float)0.0f, (float)-90.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)naw, (float)nah, (float)-90.0f, (float)-90.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)(ny + nh - nah), (float)naw, (float)nah, (float)-180.0f, (float)-90.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)(nx + nw - naw), (float)(ny + nh - nah), (float)naw, (float)nah, (float)-270.0f, (float)-90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc((long)path, (float)(nx + nw - naw), (float)ny, (float)naw, (float)nh, (float)-270.0f, (float)-180.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)naw, (float)nh, (float)-90.0f, (float)-180.0f);
                }
            } else if (nh > nah) {
                Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)nw, (float)nah, (float)0.0f, (float)-180.0f);
                Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)(ny + nh - nah), (float)nw, (float)nah, (float)-180.0f, (float)-180.0f);
            } else {
                Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)nw, (float)nh, (float)0.0f, (float)360.0f);
            }
            Gdip.GraphicsPath_CloseFigure((long)path);
            Gdip.Graphics_DrawPath((long)gdipGraphics, (long)pen, (long)path);
            Gdip.GraphicsPath_delete((long)path);
        }
        Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-this.data.gdipXOffset), (float)(-this.data.gdipYOffset), (int)0);
    }

    public void drawString(String string, int x, int y) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawStringInPixels(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawStringInPixels(string, x, y, isTransparent);
    }

    void drawStringInPixels(String string, int x, int y, boolean isTransparent) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.isEmpty()) {
            return;
        }
        char[] buffer = string.toCharArray();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            this.checkGC(5 | (isTransparent ? 0 : 2));
            this.drawText(gdipGraphics, string, x, y, isTransparent ? 1 : 0, null);
            return;
        }
        this.checkGC(772);
        int oldBkMode = OS.SetBkMode((long)this.handle, (int)(isTransparent ? 1 : 2));
        RECT rect = null;
        SIZE size = null;
        int flags = 0;
        if ((this.data.style & 0x8000000) != 0) {
            if (!isTransparent) {
                size = new SIZE();
                OS.GetTextExtentPoint32((long)this.handle, (char[])buffer, (int)buffer.length, (SIZE)size);
                rect = new RECT();
                rect.left = x;
                rect.right = x + size.cx;
                rect.top = y;
                rect.bottom = y + size.cy;
                flags = 4;
            }
            --x;
        }
        if (OS.GetROP2((long)this.handle) != 7) {
            OS.ExtTextOut((long)this.handle, (int)x, (int)y, (int)flags, rect, (char[])buffer, (int)buffer.length, null);
        } else {
            int foreground = OS.GetTextColor((long)this.handle);
            if (isTransparent) {
                int height;
                int width;
                long hBitmap;
                if (size == null) {
                    size = new SIZE();
                    OS.GetTextExtentPoint32((long)this.handle, (char[])buffer, (int)buffer.length, (SIZE)size);
                }
                if ((hBitmap = OS.CreateCompatibleBitmap((long)this.handle, (int)(width = size.cx), (int)(height = size.cy))) == 0L) {
                    SWT.error(2);
                }
                long memDC = OS.CreateCompatibleDC((long)this.handle);
                long hOldBitmap = OS.SelectObject((long)memDC, (long)hBitmap);
                OS.PatBlt((long)memDC, (int)0, (int)0, (int)width, (int)height, (int)66);
                OS.SetBkMode((long)memDC, (int)1);
                OS.SetTextColor((long)memDC, (int)foreground);
                OS.SelectObject((long)memDC, (long)OS.GetCurrentObject((long)this.handle, (int)6));
                OS.ExtTextOut((long)memDC, (int)0, (int)0, (int)0, null, (char[])buffer, (int)buffer.length, null);
                OS.BitBlt((long)this.handle, (int)x, (int)y, (int)width, (int)height, (long)memDC, (int)0, (int)0, (int)0x660046);
                OS.SelectObject((long)memDC, (long)hOldBitmap);
                OS.DeleteDC((long)memDC);
                OS.DeleteObject((long)hBitmap);
            } else {
                int background = OS.GetBkColor((long)this.handle);
                OS.SetTextColor((long)this.handle, (int)(foreground ^ background));
                OS.ExtTextOut((long)this.handle, (int)x, (int)y, (int)flags, (RECT)rect, (char[])buffer, (int)buffer.length, null);
                OS.SetTextColor((long)this.handle, (int)foreground);
            }
        }
        OS.SetBkMode((long)this.handle, (int)oldBkMode);
    }

    public void drawText(String string, int x, int y) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawTextInPixels(string, x, y);
    }

    void drawTextInPixels(String string, int x, int y) {
        this.drawTextInPixels(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawTextInPixels(string, x, y, isTransparent);
    }

    void drawTextInPixels(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawTextInPixels(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        this.drawTextInPixels(string, x, y, flags);
    }

    void drawTextInPixels(String string, int x, int y, int flags) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.isEmpty()) {
            return;
        }
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            this.checkGC(5 | ((flags & 1) != 0 ? 0 : 2));
            this.drawText(gdipGraphics, string, x, y, flags, null);
            return;
        }
        char[] buffer = string.toCharArray();
        RECT rect = new RECT();
        OS.SetRect((RECT)rect, (int)x, (int)y, (int)0x6FFFFFF, (int)0x6FFFFFF);
        int uFormat = 0;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        if ((flags & 8) != 0 && (this.data.uiState & 2) != 0) {
            uFormat |= 0x100000;
        }
        this.checkGC(772);
        int oldBkMode = OS.SetBkMode((long)this.handle, (int)((flags & 1) != 0 ? 1 : 2));
        if (OS.GetROP2((long)this.handle) != 7) {
            OS.DrawText((long)this.handle, (char[])buffer, (int)buffer.length, (RECT)rect, (int)uFormat);
        } else {
            int foreground = OS.GetTextColor((long)this.handle);
            if ((flags & 1) != 0) {
                OS.DrawText((long)this.handle, (char[])buffer, (int)buffer.length, (RECT)rect, (int)(uFormat | 0x400));
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                long hBitmap = OS.CreateCompatibleBitmap((long)this.handle, (int)width, (int)height);
                if (hBitmap == 0L) {
                    SWT.error(2);
                }
                long memDC = OS.CreateCompatibleDC((long)this.handle);
                long hOldBitmap = OS.SelectObject((long)memDC, (long)hBitmap);
                OS.PatBlt((long)memDC, (int)0, (int)0, (int)width, (int)height, (int)66);
                OS.SetBkMode((long)memDC, (int)1);
                OS.SetTextColor((long)memDC, (int)foreground);
                OS.SelectObject((long)memDC, (long)OS.GetCurrentObject((long)this.handle, (int)6));
                OS.SetRect((RECT)rect, (int)0, (int)0, (int)Short.MAX_VALUE, (int)Short.MAX_VALUE);
                OS.DrawText((long)memDC, (char[])buffer, (int)buffer.length, (RECT)rect, (int)uFormat);
                OS.BitBlt((long)this.handle, (int)x, (int)y, (int)width, (int)height, (long)memDC, (int)0, (int)0, (int)0x660046);
                OS.SelectObject((long)memDC, (long)hOldBitmap);
                OS.DeleteDC((long)memDC);
                OS.DeleteObject((long)hBitmap);
            } else {
                int background = OS.GetBkColor((long)this.handle);
                OS.SetTextColor((long)this.handle, (int)(foreground ^ background));
                OS.DrawText((long)this.handle, (char[])buffer, (int)buffer.length, (RECT)rect, (int)uFormat);
                OS.SetTextColor((long)this.handle, (int)foreground);
            }
        }
        OS.SetBkMode((long)this.handle, (int)oldBkMode);
    }

    boolean useGDIP(long hdc, char[] buffer) {
        short[] glyphs = new short[buffer.length];
        OS.GetGlyphIndices((long)hdc, (char[])buffer, (int)buffer.length, (short[])glyphs, (int)1);
        int i = 0;
        while (i < glyphs.length) {
            if (glyphs[i] == -1) {
                switch (buffer[i]) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    void drawText(long gdipGraphics, String string, int x, int y, int flags, Point size) {
        int length = string.length();
        char[] chars = string.toCharArray();
        long hdc = Gdip.Graphics_GetHDC((long)gdipGraphics);
        long hFont = this.data.hGDIFont;
        if (hFont == 0L && this.data.font != null) {
            hFont = this.data.font.handle;
        }
        long oldFont = 0L;
        if (hFont != 0L) {
            oldFont = OS.SelectObject((long)hdc, (long)hFont);
        }
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics((long)hdc, (TEXTMETRIC)lptm);
        boolean gdip = this.useGDIP(hdc, chars);
        if (hFont != 0L) {
            OS.SelectObject((long)hdc, (long)oldFont);
        }
        Gdip.Graphics_ReleaseHDC((long)gdipGraphics, (long)hdc);
        if (gdip) {
            this.drawTextGDIP(gdipGraphics, string, x, y, flags, size == null, size);
            return;
        }
        int i = 0;
        int start = 0;
        int end = 0;
        int drawX = x;
        int drawY = y;
        int width = 0;
        int mnemonicIndex = -1;
        if ((flags & 0xE) != 0) {
            int tabWidth = lptm.tmAveCharWidth * 8;
            while (i < length) {
                int n = end++;
                char c = chars[i++];
                chars[n] = c;
                char c2 = c;
                switch (c2) {
                    case '\t': {
                        if ((flags & 4) == 0) break;
                        int l = end - start - 1;
                        RectF bounds = this.drawText(gdipGraphics, chars, start, l, drawX, drawY, flags, mnemonicIndex, lptm, size == null);
                        drawX = (int)((double)drawX + Math.ceil(bounds.Width));
                        drawX = x + ((drawX - x) / tabWidth + 1) * tabWidth;
                        mnemonicIndex = -1;
                        start = end;
                        break;
                    }
                    case '&': {
                        if ((flags & 8) == 0) break;
                        if (i == length) {
                            --end;
                            break;
                        }
                        if (chars[i] == '&') {
                            ++i;
                            break;
                        }
                        mnemonicIndex = --end - start;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((flags & 2) == 0) break;
                        int l = end - start - 1;
                        if (c2 == '\r' && end != length && chars[end] == '\n') {
                            ++end;
                            ++i;
                        }
                        RectF bounds = this.drawText(gdipGraphics, chars, start, l, drawX, drawY, flags, mnemonicIndex, lptm, size == null);
                        drawY = (int)((double)drawY + Math.ceil(bounds.Height));
                        width = Math.max(width, drawX + (int)Math.ceil(bounds.Width));
                        drawX = x;
                        mnemonicIndex = -1;
                        start = end;
                    }
                }
            }
            length = end;
        }
        RectF bounds = this.drawText(gdipGraphics, chars, start, length - start, drawX, drawY, flags, mnemonicIndex, lptm, size == null);
        if (size != null) {
            drawY = (int)((double)drawY + Math.ceil(bounds.Height));
            size.x = width = Math.max(width, drawX + (int)Math.ceil(bounds.Width));
            size.y = drawY;
        }
    }

    RectF drawText(long gdipGraphics, char[] buffer, int start, int length, int x, int y, int flags, int mnemonicIndex, TEXTMETRIC lptm, boolean draw) {
        boolean needsBounds;
        boolean drawMnemonic = draw && mnemonicIndex != -1 && (this.data.uiState & 2) == 0;
        boolean bl = needsBounds = !draw || drawMnemonic || (flags & 1) == 0 || (this.data.style & 0x8000000) != 0 || (flags & 2) != 0;
        if (length <= 0) {
            RectF bounds = null;
            if (needsBounds) {
                bounds = new RectF();
                bounds.Height = lptm.tmHeight;
            }
            return bounds;
        }
        int nGlyphs = length * 3 / 2 + 16;
        GCP_RESULTS result = new GCP_RESULTS();
        result.lStructSize = GCP_RESULTS.sizeof;
        result.nGlyphs = nGlyphs;
        long hHeap = OS.GetProcessHeap();
        long lpDx = result.lpDx = OS.HeapAlloc((long)hHeap, (int)8, (int)(nGlyphs * 4));
        long lpGlyphs = result.lpGlyphs = OS.HeapAlloc((long)hHeap, (int)8, (int)(nGlyphs * 2));
        long lpOrder = 0L;
        int dwFlags = 50;
        if (drawMnemonic) {
            lpOrder = result.lpOrder = OS.HeapAlloc((long)hHeap, (int)8, (int)(nGlyphs * 4));
        }
        long hdc = Gdip.Graphics_GetHDC((long)gdipGraphics);
        long hFont = this.data.hGDIFont;
        if (hFont == 0L && this.data.font != null) {
            hFont = this.data.font.handle;
        }
        long oldFont = 0L;
        if (hFont != 0L) {
            oldFont = OS.SelectObject((long)hdc, (long)hFont);
        }
        if (start != 0) {
            char[] temp = new char[length];
            System.arraycopy(buffer, start, temp, 0, length);
            buffer = temp;
        }
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout((long)hdc, (int)(OS.GetLayout((long)hdc) | 1));
        }
        OS.GetCharacterPlacement((long)hdc, (char[])buffer, (int)length, (int)0, (GCP_RESULTS)result, (int)dwFlags);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout((long)hdc, (int)(OS.GetLayout((long)hdc) & 0xFFFFFFFE));
        }
        if (hFont != 0L) {
            OS.SelectObject((long)hdc, (long)oldFont);
        }
        Gdip.Graphics_ReleaseHDC((long)gdipGraphics, (long)hdc);
        nGlyphs = result.nGlyphs;
        int drawX = x;
        int drawY = y + lptm.tmAscent;
        int[] dx = new int[nGlyphs];
        OS.MoveMemory((int[])dx, (long)result.lpDx, (int)(nGlyphs * 4));
        float[] points = new float[dx.length * 2];
        int i = 0;
        int j = 0;
        while (i < dx.length) {
            points[j++] = drawX;
            points[j++] = drawY;
            drawX += dx[i];
            ++i;
        }
        RectF bounds = null;
        if (needsBounds) {
            bounds = new RectF();
            Gdip.Graphics_MeasureDriverString((long)gdipGraphics, (long)lpGlyphs, (int)nGlyphs, (long)this.data.gdipFont, (float[])points, (int)0, (long)0L, (RectF)bounds);
        }
        if (draw) {
            long pen;
            if ((flags & 1) == 0) {
                Gdip.Graphics_FillRectangle((long)gdipGraphics, (long)this.data.gdipBrush, (int)x, (int)y, (int)((int)Math.ceil(bounds.Width)), (int)((int)Math.ceil(bounds.Height)));
            }
            int gstate = 0;
            long brush = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType((long)brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform((long)brush, (float)-1.0f, (float)1.0f, (int)0);
                        Gdip.LinearGradientBrush_TranslateTransform((long)brush, (float)((float)(-2 * x) - bounds.Width), (float)0.0f, (int)0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform((long)brush, (float)-1.0f, (float)1.0f, (int)0);
                        Gdip.TextureBrush_TranslateTransform((long)brush, (float)((float)(-2 * x) - bounds.Width), (float)0.0f, (int)0);
                    }
                }
                gstate = Gdip.Graphics_Save((long)gdipGraphics);
                Gdip.Graphics_ScaleTransform((long)gdipGraphics, (float)-1.0f, (float)1.0f, (int)0);
                Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)((float)(-2 * x) - bounds.Width), (float)0.0f, (int)0);
            }
            Gdip.Graphics_DrawDriverString((long)gdipGraphics, (long)lpGlyphs, (int)result.nGlyphs, (long)this.data.gdipFont, (long)brush, (float[])points, (int)0, (long)0L);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType((long)brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform((long)brush);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform((long)brush);
                    }
                }
                Gdip.Graphics_Restore((long)gdipGraphics, (int)gstate);
            }
            if (drawMnemonic && (pen = Gdip.Pen_new((long)brush, (float)1.0f)) != 0L) {
                int mnemonicRight;
                int mnemonicLeft;
                int[] order = new int[1];
                OS.MoveMemory((int[])order, (long)(result.lpOrder + (long)(mnemonicIndex * 4)), (int)4);
                if ((this.data.style & 0x8000000) != 0) {
                    mnemonicLeft = (int)Math.ceil(bounds.Width) - (int)points[order[0] * 2] + 2 * x;
                    mnemonicRight = mnemonicLeft - dx[order[0]];
                } else {
                    mnemonicLeft = (int)points[order[0] * 2];
                    mnemonicRight = mnemonicLeft + dx[order[0]];
                }
                int mnemonicY = y + lptm.tmAscent + 2;
                int smoothingMode = Gdip.Graphics_GetSmoothingMode((long)gdipGraphics);
                Gdip.Graphics_SetSmoothingMode((long)gdipGraphics, (int)3);
                Gdip.Graphics_DrawLine((long)gdipGraphics, (long)pen, (int)mnemonicLeft, (int)mnemonicY, (int)mnemonicRight, (int)mnemonicY);
                Gdip.Graphics_SetSmoothingMode((long)gdipGraphics, (int)smoothingMode);
                Gdip.Pen_delete((long)pen);
            }
        }
        if (lpOrder != 0L) {
            OS.HeapFree((long)hHeap, (int)0, (long)lpOrder);
        }
        OS.HeapFree((long)hHeap, (int)0, (long)lpGlyphs);
        OS.HeapFree((long)hHeap, (int)0, (long)lpDx);
        return bounds;
    }

    void drawTextGDIP(long gdipGraphics, String string, int x, int y, int flags, boolean draw, Point size) {
        int hotkeyPrefix;
        float[] fArray;
        char[] buffer;
        boolean needsBounds = !draw || (flags & 1) == 0;
        int length = string.length();
        if (length != 0) {
            buffer = string.toCharArray();
        } else {
            if (draw) {
                return;
            }
            buffer = new char[]{' '};
        }
        PointF pt = new PointF();
        long format = Gdip.StringFormat_Clone((long)Gdip.StringFormat_GenericTypographic());
        int formatFlags = Gdip.StringFormat_GetFormatFlags((long)format) | 0x800;
        if ((this.data.style & 0x8000000) != 0) {
            formatFlags |= 1;
        }
        Gdip.StringFormat_SetFormatFlags((long)format, (int)formatFlags);
        if ((flags & 4) != 0) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = this.measureSpace(this.data.gdipFont, format) * 8.0f;
        } else {
            fArray = new float[1];
        }
        float[] tabs = fArray;
        Gdip.StringFormat_SetTabStops((long)format, (float)0.0f, (int)tabs.length, (float[])tabs);
        int n = hotkeyPrefix = (flags & 8) != 0 ? 1 : 0;
        if ((flags & 8) != 0 && (this.data.uiState & 2) != 0) {
            hotkeyPrefix = 2;
        }
        Gdip.StringFormat_SetHotkeyPrefix((long)format, (int)hotkeyPrefix);
        RectF bounds = null;
        if (needsBounds) {
            bounds = new RectF();
            Gdip.Graphics_MeasureString((long)gdipGraphics, (char[])buffer, (int)buffer.length, (long)this.data.gdipFont, (PointF)pt, (long)format, (RectF)bounds);
        }
        if (draw) {
            if ((flags & 1) == 0) {
                Gdip.Graphics_FillRectangle((long)gdipGraphics, (long)this.data.gdipBrush, (int)x, (int)y, (int)((int)Math.ceil(bounds.Width)), (int)((int)Math.ceil(bounds.Height)));
            }
            int gstate = 0;
            long brush = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType((long)brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform((long)brush, (float)-1.0f, (float)1.0f, (int)0);
                        Gdip.LinearGradientBrush_TranslateTransform((long)brush, (float)(-2 * x), (float)0.0f, (int)0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform((long)brush, (float)-1.0f, (float)1.0f, (int)0);
                        Gdip.TextureBrush_TranslateTransform((long)brush, (float)(-2 * x), (float)0.0f, (int)0);
                    }
                }
                gstate = Gdip.Graphics_Save((long)gdipGraphics);
                Gdip.Graphics_ScaleTransform((long)gdipGraphics, (float)-1.0f, (float)1.0f, (int)0);
                Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)(-2 * x), (float)0.0f, (int)0);
            }
            pt.X = x;
            pt.Y = y;
            Gdip.Graphics_DrawString((long)gdipGraphics, (char[])buffer, (int)buffer.length, (long)this.data.gdipFont, (PointF)pt, (long)format, (long)brush);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType((long)brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform((long)brush);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform((long)brush);
                    }
                }
                Gdip.Graphics_Restore((long)gdipGraphics, (int)gstate);
            }
        }
        Gdip.StringFormat_delete((long)format);
        if (length == 0) {
            bounds.Width = 0.0f;
        }
        if (size != null) {
            size.x = (int)Math.ceil(bounds.Width);
            size.y = (int)Math.ceil(bounds.Height);
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.fillArcInPixels(x, y, width, height, startAngle, arcAngle);
    }

    void fillArcInPixels(int x, int y, int width, int height, int startAngle, int arcAngle) {
        int y1;
        int y2;
        int x1;
        int x2;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            if (width == height) {
                Gdip.Graphics_FillPie((long)gdipGraphics, (long)this.data.gdipBrush, (int)x, (int)y, (int)width, (int)height, (float)(-startAngle), (float)(-arcAngle));
            } else {
                int state = Gdip.Graphics_Save((long)gdipGraphics);
                Gdip.Graphics_TranslateTransform((long)gdipGraphics, (float)x, (float)y, (int)0);
                Gdip.Graphics_ScaleTransform((long)gdipGraphics, (float)width, (float)height, (int)0);
                Gdip.Graphics_FillPie((long)gdipGraphics, (long)this.data.gdipBrush, (int)0, (int)0, (int)1, (int)1, (float)(-startAngle), (float)(-arcAngle));
                Gdip.Graphics_Restore((long)gdipGraphics, (int)state);
            }
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --x;
        }
        if (arcAngle >= 360 || arcAngle <= -360) {
            x1 = x2 = x + width;
            y1 = y2 = y + height / 2;
        } else {
            boolean isNegative = arcAngle < 0;
            arcAngle += startAngle;
            if (isNegative) {
                int tmp = startAngle;
                startAngle = arcAngle;
                arcAngle = tmp;
            }
            x1 = GC.cos(startAngle, width) + x + width / 2;
            y1 = -1 * GC.sin(startAngle, height) + y + height / 2;
            x2 = GC.cos(arcAngle, width) + x + width / 2;
            y2 = -1 * GC.sin(arcAngle, height) + y + height / 2;
        }
        OS.Pie((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1), (int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.fillGradientRectangleInPixels(x, y, width, height, vertical);
    }

    void fillGradientRectangleInPixels(int x, int y, int width, int height, boolean vertical) {
        int depth;
        RGB foregroundRGB;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangleInPixels(x, y, width, height);
            return;
        }
        if (this.data.gdipGraphics != 0L) {
            this.initGdip();
            PointF p1 = new PointF();
            PointF p2 = new PointF();
            p1.X = x;
            p1.Y = y;
            if (vertical) {
                p2.X = p1.X;
                p2.Y = p1.Y + (float)height;
            } else {
                p2.X = p1.X + (float)width;
                p2.Y = p1.Y;
            }
            int fromGpColor = this.data.alpha << 24 | (fromRGB.red & 0xFF) << 16 | (fromRGB.green & 0xFF) << 8 | fromRGB.blue & 0xFF;
            int toGpColor = this.data.alpha << 24 | (toRGB.red & 0xFF) << 16 | (toRGB.green & 0xFF) << 8 | toRGB.blue & 0xFF;
            long brush = Gdip.LinearGradientBrush_new((PointF)p1, (PointF)p2, (int)fromGpColor, (int)toGpColor);
            Gdip.Graphics_FillRectangle((long)this.data.gdipGraphics, (long)brush, (int)x, (int)y, (int)width, (int)height);
            Gdip.LinearGradientBrush_delete((long)brush);
            return;
        }
        if (OS.GetROP2((long)this.handle) != 7 && OS.GetDeviceCaps((long)this.handle, (int)2) != 2) {
            long hHeap = OS.GetProcessHeap();
            long pMesh = OS.HeapAlloc((long)hHeap, (int)8, (int)(GRADIENT_RECT.sizeof + TRIVERTEX.sizeof * 2));
            if (pMesh == 0L) {
                SWT.error(2);
            }
            long pVertex = pMesh + (long)GRADIENT_RECT.sizeof;
            GRADIENT_RECT gradientRect = new GRADIENT_RECT();
            gradientRect.UpperLeft = 0;
            gradientRect.LowerRight = 1;
            OS.MoveMemory((long)pMesh, (GRADIENT_RECT)gradientRect, (int)GRADIENT_RECT.sizeof);
            TRIVERTEX trivertex = new TRIVERTEX();
            trivertex.x = x;
            trivertex.y = y;
            trivertex.Red = (short)(fromRGB.red << 8 | fromRGB.red);
            trivertex.Green = (short)(fromRGB.green << 8 | fromRGB.green);
            trivertex.Blue = (short)(fromRGB.blue << 8 | fromRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory((long)pVertex, (TRIVERTEX)trivertex, (int)TRIVERTEX.sizeof);
            trivertex.x = x + width;
            trivertex.y = y + height;
            trivertex.Red = (short)(toRGB.red << 8 | toRGB.red);
            trivertex.Green = (short)(toRGB.green << 8 | toRGB.green);
            trivertex.Blue = (short)(toRGB.blue << 8 | toRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory((long)(pVertex + (long)TRIVERTEX.sizeof), (TRIVERTEX)trivertex, (int)TRIVERTEX.sizeof);
            boolean success = OS.GradientFill((long)this.handle, (long)pVertex, (int)2, (long)pMesh, (int)1, (int)(vertical ? 1 : 0));
            OS.HeapFree((long)hHeap, (int)0, (long)pMesh);
            if (success) {
                return;
            }
        }
        int bitResolution = (depth = OS.GetDeviceCaps((long)this.handle, (int)12)) >= 24 ? 8 : (depth >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, bitResolution, bitResolution, bitResolution);
    }

    public void fillOval(int x, int y, int width, int height) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.fillOvalInPixels(x, y, width, height);
    }

    void fillOvalInPixels(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            Gdip.Graphics_FillEllipse((long)this.data.gdipGraphics, (long)this.data.gdipBrush, (int)x, (int)y, (int)width, (int)height);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --x;
        }
        OS.Ellipse((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1));
    }

    public void fillPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initGdip();
        this.checkGC(9218);
        int mode = OS.GetPolyFillMode((long)this.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode((long)path.handle, (int)mode);
        Gdip.Graphics_FillPath((long)this.data.gdipGraphics, (long)this.data.gdipBrush, (long)path.handle);
    }

    public void fillPolygon(int[] pointArray) {
        if (pointArray == null) {
            SWT.error(4);
        }
        this.fillPolygonInPixels(DPIUtil.autoScaleUp((Drawable)this.drawable, (int[])pointArray));
    }

    void fillPolygonInPixels(int[] pointArray) {
        int i;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            int mode = OS.GetPolyFillMode((long)this.handle) == 2 ? 1 : 0;
            float offsetCorrection = 0.5f;
            Gdip.Graphics_TranslateTransform((long)this.data.gdipGraphics, (float)(this.data.gdipXOffset + offsetCorrection), (float)(this.data.gdipYOffset + offsetCorrection), (int)0);
            Gdip.Graphics_FillPolygon((long)this.data.gdipGraphics, (long)this.data.gdipBrush, (int[])pointArray, (int)(pointArray.length / 2), (int)mode);
            Gdip.Graphics_TranslateTransform((long)this.data.gdipGraphics, (float)(-(this.data.gdipXOffset + offsetCorrection)), (float)(-(this.data.gdipYOffset + offsetCorrection)), (int)0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            i = 0;
            while (i < pointArray.length) {
                int n = i;
                pointArray[n] = pointArray[n] - 1;
                i += 2;
            }
        }
        OS.Polygon((long)this.handle, (int[])pointArray, (int)(pointArray.length / 2));
        if ((this.data.style & 0x8000000) != 0) {
            i = 0;
            while (i < pointArray.length) {
                int n = i;
                pointArray[n] = pointArray[n] + 1;
                i += 2;
            }
        }
    }

    public void fillRectangle(int x, int y, int width, int height) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.fillRectangleInPixels(x, y, width, height);
    }

    void fillRectangleInPixels(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            Gdip.Graphics_FillRectangle((long)this.data.gdipGraphics, (long)this.data.gdipBrush, (int)x, (int)y, (int)width, (int)height);
            return;
        }
        int dwRop = OS.GetROP2((long)this.handle) == 7 ? 5898313 : 15728673;
        OS.PatBlt((long)this.handle, (int)x, (int)y, (int)width, (int)height, (int)dwRop);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        rect = DPIUtil.autoScaleUp((Drawable)this.drawable, (Rectangle)rect);
        this.fillRectangleInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        arcWidth = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)arcWidth);
        arcHeight = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)arcHeight);
        this.fillRoundRectangleInPixels(x, y, width, height, arcWidth, arcHeight);
    }

    void fillRoundRectangleInPixels(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            this.fillRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height, arcWidth, arcHeight);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --x;
        }
        OS.RoundRect((long)this.handle, (int)x, (int)y, (int)(x + width + 1), (int)(y + height + 1), (int)arcWidth, (int)arcHeight);
    }

    void fillRoundRectangleGdip(long gdipGraphics, long brush, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw == 0 || nah == 0) {
            Gdip.Graphics_FillRectangle((long)this.data.gdipGraphics, (long)this.data.gdipBrush, (int)x, (int)y, (int)width, (int)height);
        } else {
            long path = Gdip.GraphicsPath_new((int)0);
            if (path == 0L) {
                SWT.error(2);
            }
            if (nw > naw) {
                if (nh > nah) {
                    Gdip.GraphicsPath_AddArc((long)path, (float)(nx + nw - naw), (float)ny, (float)naw, (float)nah, (float)0.0f, (float)-90.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)naw, (float)nah, (float)-90.0f, (float)-90.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)(ny + nh - nah), (float)naw, (float)nah, (float)-180.0f, (float)-90.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)(nx + nw - naw), (float)(ny + nh - nah), (float)naw, (float)nah, (float)-270.0f, (float)-90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc((long)path, (float)(nx + nw - naw), (float)ny, (float)naw, (float)nh, (float)-270.0f, (float)-180.0f);
                    Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)naw, (float)nh, (float)-90.0f, (float)-180.0f);
                }
            } else if (nh > nah) {
                Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)nw, (float)nah, (float)0.0f, (float)-180.0f);
                Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)(ny + nh - nah), (float)nw, (float)nah, (float)-180.0f, (float)-180.0f);
            } else {
                Gdip.GraphicsPath_AddArc((long)path, (float)nx, (float)ny, (float)nw, (float)nh, (float)0.0f, (float)360.0f);
            }
            Gdip.GraphicsPath_CloseFigure((long)path);
            Gdip.Graphics_FillPath((long)gdipGraphics, (long)brush, (long)path);
            Gdip.GraphicsPath_delete((long)path);
        }
    }

    void flush() {
        if (this.data.gdipGraphics != 0L) {
            Gdip.Graphics_Flush((long)this.data.gdipGraphics, (int)0);
            long hdc = Gdip.Graphics_GetHDC((long)this.data.gdipGraphics);
            Gdip.Graphics_ReleaseHDC((long)this.data.gdipGraphics, (long)hdc);
        }
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(4);
        int[] width = new int[1];
        OS.GetCharWidth((long)this.handle, (int)ch, (int)ch, (int[])width);
        return width[0];
    }

    public boolean getAdvanced() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.gdipGraphics != 0L;
    }

    public int getAlpha() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L) {
            return -1;
        }
        int mode = Gdip.Graphics_GetSmoothingMode((long)this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return Color.win32_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(4);
        int[] width = new int[3];
        if (OS.GetCharABCWidths((long)this.handle, (int)ch, (int)ch, (int[])width)) {
            return width[1];
        }
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics((long)this.handle, (TEXTMETRIC)lptm);
        SIZE size = new SIZE();
        OS.GetTextExtentPoint32((long)this.handle, (char[])new char[]{ch}, (int)1, (SIZE)size);
        return size.cx - lptm.tmOverhang;
    }

    public Rectangle getClipping() {
        return DPIUtil.autoScaleDown((Drawable)this.drawable, (Rectangle)this.getClippingInPixels());
    }

    Rectangle getClippingInPixels() {
        long gdipGraphics;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0L) {
            Rect rect = new Rect();
            Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)3);
            Gdip.Graphics_GetVisibleClipBounds((long)gdipGraphics, (Rect)rect);
            Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)4);
            return new Rectangle(rect.X, rect.Y, rect.Width, rect.Height);
        }
        RECT rect = new RECT();
        OS.GetClipBox((long)this.handle, (RECT)rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void getClipping(Region region) {
        long gdipGraphics;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0L) {
            long rgn = Gdip.Region_new();
            Gdip.Graphics_GetClip((long)this.data.gdipGraphics, (long)rgn);
            if (Gdip.Region_IsInfinite((long)rgn, (long)gdipGraphics)) {
                Rect rect = new Rect();
                Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)3);
                Gdip.Graphics_GetVisibleClipBounds((long)gdipGraphics, (Rect)rect);
                Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)4);
                OS.SetRectRgn((long)region.handle, (int)rect.X, (int)rect.Y, (int)(rect.X + rect.Width), (int)(rect.Y + rect.Height));
            } else {
                long matrix = Gdip.Matrix_new((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                long identity = Gdip.Matrix_new((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Gdip.Graphics_GetTransform((long)gdipGraphics, (long)matrix);
                Gdip.Graphics_SetTransform((long)gdipGraphics, (long)identity);
                long hRgn = Gdip.Region_GetHRGN((long)rgn, (long)this.data.gdipGraphics);
                Gdip.Graphics_SetTransform((long)gdipGraphics, (long)matrix);
                Gdip.Matrix_delete((long)identity);
                Gdip.Matrix_delete((long)matrix);
                POINT pt = new POINT();
                OS.GetWindowOrgEx((long)this.handle, (POINT)pt);
                OS.OffsetRgn((long)hRgn, (int)pt.x, (int)pt.y);
                OS.CombineRgn((long)region.handle, (long)hRgn, (long)0L, (int)5);
                OS.DeleteObject((long)hRgn);
            }
            Gdip.Region_delete((long)rgn);
            return;
        }
        POINT pt = new POINT();
        OS.GetWindowOrgEx((long)this.handle, (POINT)pt);
        int result = OS.GetClipRgn((long)this.handle, (long)region.handle);
        if (result != 1) {
            RECT rect = new RECT();
            OS.GetClipBox((long)this.handle, (RECT)rect);
            OS.SetRectRgn((long)region.handle, (int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom);
        } else {
            OS.OffsetRgn((long)region.handle, (int)pt.x, (int)pt.y);
        }
        long metaRgn = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
        if (OS.GetMetaRgn((long)this.handle, (long)metaRgn) != 0) {
            OS.OffsetRgn((long)metaRgn, (int)pt.x, (int)pt.y);
            OS.CombineRgn((long)region.handle, (long)metaRgn, (long)region.handle, (int)1);
        }
        OS.DeleteObject((long)metaRgn);
        long hwnd = this.data.hwnd;
        if (hwnd != 0L && this.data.ps != null) {
            long sysRgn = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
            if (OS.GetRandomRgn((long)this.handle, (long)sysRgn, (int)4) == 1) {
                if ((OS.GetLayout((long)this.handle) & 1) != 0) {
                    int nBytes = OS.GetRegionData((long)sysRgn, (int)0, null);
                    int[] lpRgnData = new int[nBytes / 4];
                    OS.GetRegionData((long)sysRgn, (int)nBytes, (int[])lpRgnData);
                    long newSysRgn = OS.ExtCreateRegion((float[])new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, (int)nBytes, (int[])lpRgnData);
                    OS.DeleteObject((long)sysRgn);
                    sysRgn = newSysRgn;
                }
                OS.MapWindowPoints((long)0L, (long)hwnd, (POINT)pt, (int)1);
                OS.OffsetRgn((long)sysRgn, (int)pt.x, (int)pt.y);
                OS.CombineRgn((long)region.handle, (long)sysRgn, (long)region.handle, (int)1);
            }
            OS.DeleteObject((long)sysRgn);
        }
    }

    long getFgBrush() {
        return this.data.foregroundPattern != null ? this.data.foregroundPattern.handle : this.data.gdipFgBrush;
    }

    public int getFillRule() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return OS.GetPolyFillMode((long)this.handle) == 2 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(4);
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics((long)this.handle, (TEXTMETRIC)lptm);
        return FontMetrics.win32_new(lptm);
    }

    public Color getForeground() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return Color.win32_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L) {
            return -1;
        }
        int mode = Gdip.Graphics_GetInterpolationMode((long)this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 5: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        LineAttributes attributes = this.getLineAttributesInPixels();
        attributes.width = DPIUtil.autoScaleDown((Drawable)this.drawable, (float)attributes.width);
        return attributes;
    }

    LineAttributes getLineAttributesInPixels() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        int i = 0;
        while (i < lineDashes.length) {
            lineDashes[i] = (int)this.data.lineDashes[i];
            ++i;
        }
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        return DPIUtil.autoScaleDown((Drawable)this.drawable, (int)this.getLineWidthInPixels());
    }

    int getLineWidthInPixels() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L) {
            return -1;
        }
        int mode = Gdip.Graphics_GetTextRenderingHint((long)this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        long gdipGraphics;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0L) {
            Gdip.Graphics_GetTransform((long)gdipGraphics, (long)transform.handle);
            long identity = this.identity();
            Gdip.Matrix_Invert((long)identity);
            Gdip.Matrix_Multiply((long)transform.handle, (long)identity, (int)1);
            Gdip.Matrix_delete((long)identity);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return OS.GetROP2((long)this.handle) == 7;
    }

    void initGdip() {
        this.data.device.checkGDIP();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            return;
        }
        long hRgn = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
        int result = OS.GetClipRgn((long)this.handle, (long)hRgn);
        POINT pt = new POINT();
        OS.GetWindowOrgEx((long)this.handle, (POINT)pt);
        OS.OffsetRgn((long)hRgn, (int)pt.x, (int)pt.y);
        OS.SelectClipRgn((long)this.handle, (long)0L);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout((long)this.handle, (int)(OS.GetLayout((long)this.handle) & 0xFFFFFFFE));
        }
        if ((gdipGraphics = (this.data.gdipGraphics = Gdip.Graphics_new((long)this.handle))) == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_SetPageUnit((long)gdipGraphics, (int)2);
        Gdip.Graphics_SetPixelOffsetMode((long)gdipGraphics, (int)4);
        if ((this.data.style & 0x8000000) != 0) {
            long matrix = this.identity();
            Gdip.Graphics_SetTransform((long)gdipGraphics, (long)matrix);
            Gdip.Matrix_delete((long)matrix);
        }
        if (result == 1) {
            this.setClipping(hRgn);
        }
        OS.DeleteObject((long)hRgn);
        this.data.state = 0;
        if (this.data.hPen != 0L) {
            OS.SelectObject((long)this.handle, (long)OS.GetStockObject((int)8));
            OS.DeleteObject((long)this.data.hPen);
            this.data.hPen = 0L;
        }
        if (this.data.hBrush != 0L) {
            OS.SelectObject((long)this.handle, (long)OS.GetStockObject((int)5));
            OS.DeleteObject((long)this.data.hBrush);
            this.data.hBrush = 0L;
        }
    }

    long identity() {
        if ((this.data.style & 0x8000000) != 0) {
            int width = 0;
            int technology = OS.GetDeviceCaps((long)this.handle, (int)2);
            if (technology == 2) {
                width = OS.GetDeviceCaps((long)this.handle, (int)110);
            } else {
                Image image = this.data.image;
                if (image != null) {
                    BITMAP bm = new BITMAP();
                    OS.GetObject((long)image.handle, (int)BITMAP.sizeof, (BITMAP)bm);
                    width = bm.bmWidth;
                } else {
                    long hwnd = OS.WindowFromDC((long)this.handle);
                    if (hwnd != 0L) {
                        RECT rect = new RECT();
                        OS.GetClientRect((long)hwnd, (RECT)rect);
                        width = rect.right - rect.left;
                    } else {
                        long hBitmap = OS.GetCurrentObject((long)this.handle, (int)7);
                        BITMAP bm = new BITMAP();
                        OS.GetObject((long)hBitmap, (int)BITMAP.sizeof, (BITMAP)bm);
                        width = bm.bmWidth;
                    }
                }
            }
            POINT pt = new POINT();
            OS.GetWindowOrgEx((long)this.handle, (POINT)pt);
            return Gdip.Matrix_new((float)-1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)(width + 2 * pt.x), (float)0.0f);
        }
        return Gdip.Matrix_new((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    void init(Drawable drawable, GCData data, long hDC) {
        int layout;
        int foreground = data.foreground;
        if (foreground != -1) {
            data.state &= 0xFFFFF6FE;
        } else {
            data.foreground = OS.GetTextColor((long)hDC);
        }
        int background = data.background;
        if (background != -1) {
            data.state &= 0xFFFFF9FD;
        } else {
            data.background = OS.GetBkColor((long)hDC);
        }
        data.state &= 0xFFFFCFFF;
        Font font = data.font;
        if (font != null) {
            data.state &= 0xFFFFFFFB;
        } else {
            data.font = Font.win32_new(this.device, OS.GetCurrentObject((long)hDC, (int)6));
        }
        Image image = data.image;
        if (image != null) {
            data.hNullBitmap = OS.SelectObject((long)hDC, (long)image.handle);
            image.memGC = this;
        }
        if ((layout = data.layout) != -1) {
            int flags = OS.GetLayout((long)hDC);
            if ((flags & 1) != (layout & 1)) {
                OS.SetLayout((long)hDC, (int)((flags &= 0xFFFFFFFE) | layout));
            }
            if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = hDC;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public boolean isClipped() {
        long gdipGraphics;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0L) {
            long rgn = Gdip.Region_new();
            Gdip.Graphics_GetClip((long)this.data.gdipGraphics, (long)rgn);
            boolean isInfinite = Gdip.Region_IsInfinite((long)rgn, (long)gdipGraphics);
            Gdip.Region_delete((long)rgn);
            return !isInfinite;
        }
        long region = OS.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
        int result = OS.GetClipRgn((long)this.handle, (long)region);
        OS.DeleteObject((long)region);
        return result > 0;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    float measureSpace(long font, long format) {
        PointF pt = new PointF();
        RectF bounds = new RectF();
        Gdip.Graphics_MeasureString((long)this.data.gdipGraphics, (char[])new char[]{' '}, (int)1, (long)font, (PointF)pt, (long)format, (RectF)bounds);
        return bounds.Width;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (advanced && this.data.gdipGraphics != 0L) {
            return;
        }
        if (advanced) {
            this.initGdip();
        } else {
            this.disposeGdip();
            this.data.alpha = 255;
            this.data.foregroundPattern = null;
            this.data.backgroundPattern = null;
            this.data.state = 0;
            this.setClipping(0L);
            if ((this.data.style & 0x8000000) != 0) {
                OS.SetLayout((long)this.handle, (int)(OS.GetLayout((long)this.handle) | 1));
            }
        }
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 3;
                break;
            }
            case 1: {
                mode = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetSmoothingMode((long)this.data.gdipGraphics, (int)mode);
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L && (alpha & 0xFF) == 255) {
            return;
        }
        this.initGdip();
        this.data.alpha = alpha & 0xFF;
        this.data.state &= 0xFFFFFFFC;
    }

    public void setBackground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == null && this.data.background == color.handle) {
            return;
        }
        this.data.backgroundPattern = null;
        this.data.background = color.handle;
        this.data.state &= 0xFFFFFDFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0L && pattern == null) {
            return;
        }
        this.initGdip();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    void setClipping(long clipRgn) {
        long hRgn = clipRgn;
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            if (hRgn != 0L) {
                long region = Gdip.Region_new((long)hRgn);
                Gdip.Graphics_SetClip((long)gdipGraphics, (long)region, (int)0);
                Gdip.Region_delete((long)region);
            } else {
                Gdip.Graphics_ResetClip((long)gdipGraphics);
            }
        } else {
            POINT pt = null;
            if (hRgn != 0L) {
                pt = new POINT();
                OS.GetWindowOrgEx((long)this.handle, (POINT)pt);
                OS.OffsetRgn((long)hRgn, (int)(-pt.x), (int)(-pt.y));
            }
            OS.SelectClipRgn((long)this.handle, (long)hRgn);
            if (hRgn != 0L) {
                OS.OffsetRgn((long)hRgn, (int)pt.x, (int)pt.y);
            }
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        x = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)x);
        y = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)y);
        width = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)width);
        height = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)height);
        this.setClippingInPixels(x, y, width, height);
    }

    void setClippingInPixels(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        long hRgn = OS.CreateRectRgn((int)x, (int)y, (int)(x + width), (int)(y + height));
        this.setClipping(hRgn);
        OS.DeleteObject((long)hRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0L);
        if (path != null) {
            this.initGdip();
            int mode = OS.GetPolyFillMode((long)this.handle) == 2 ? 1 : 0;
            Gdip.GraphicsPath_SetFillMode((long)path.handle, (int)mode);
            Gdip.Graphics_SetClipPath((long)this.data.gdipGraphics, (long)path.handle);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping(0L);
        } else {
            rect = DPIUtil.autoScaleUp((Drawable)this.drawable, (Rectangle)rect);
            this.setClippingInPixels(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0L);
    }

    public void setFillRule(int rule) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int mode = 1;
        switch (rule) {
            case 2: {
                mode = 2;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.SetPolyFillMode((long)this.handle, (int)mode);
    }

    public void setFont(Font font) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == null && color.handle == this.data.foreground) {
            return;
        }
        this.data.foregroundPattern = null;
        this.data.foreground = color.handle;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0L && pattern == null) {
            return;
        }
        this.initGdip();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L && interpolation == -1) {
            return;
        }
        int mode = 0;
        switch (interpolation) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 5;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetInterpolationMode((long)this.data.gdipGraphics, (int)mode);
    }

    public void setLineAttributes(LineAttributes attributes) {
        if (attributes == null) {
            SWT.error(4);
        }
        attributes.width = DPIUtil.autoScaleUp((Drawable)this.drawable, (float)attributes.width);
        this.setLineAttributesInPixels(attributes);
    }

    void setLineAttributesInPixels(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x4010;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x40;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x20;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != dash) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        this.initGdip();
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != (float)dash) {
                    changed = true;
                }
                ++i;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            i = 0;
            while (i < dashes.length) {
                this.data.lineDashes[i] = dashes[i];
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFBF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        lineWidth = DPIUtil.autoScaleUp((Drawable)this.drawable, (int)lineWidth);
        this.setLineWidthInPixels(lineWidth);
    }

    void setLineWidthInPixels(int lineWidth) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFBFEF;
    }

    @Deprecated
    public void setXORMode(boolean xor) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        OS.SetROP2((long)this.handle, (int)(xor ? 7 : 13));
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.gdipGraphics == 0L && antialias == -1) {
            return;
        }
        int textMode = 0;
        switch (antialias) {
            case -1: {
                textMode = 0;
                break;
            }
            case 0: {
                textMode = 1;
                break;
            }
            case 1: {
                int[] type = new int[1];
                OS.SystemParametersInfo((int)8202, (int)0, (int[])type, (int)0);
                if (type[0] == 2) {
                    textMode = 5;
                    break;
                }
                textMode = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initGdip();
        Gdip.Graphics_SetTextRenderingHint((long)this.data.gdipGraphics, (int)textMode);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.gdipGraphics == 0L && transform == null) {
            return;
        }
        this.initGdip();
        long identity = this.identity();
        if (transform != null) {
            Gdip.Matrix_Multiply((long)identity, (long)transform.handle, (int)0);
        }
        Gdip.Graphics_SetTransform((long)this.data.gdipGraphics, (long)identity);
        Gdip.Matrix_delete((long)identity);
        this.data.state &= 0xFFFFBFFF;
    }

    public Point stringExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        return DPIUtil.autoScaleDown((Drawable)this.drawable, (Point)this.stringExtentInPixels(string));
    }

    Point stringExtentInPixels(String string) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.checkGC(4);
        int length = string.length();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Point size = new Point(0, 0);
            this.drawText(gdipGraphics, string, 0, 0, 0, size);
            return size;
        }
        SIZE size = new SIZE();
        if (length == 0) {
            OS.GetTextExtentPoint32((long)this.handle, (char[])new char[]{' '}, (int)1, (SIZE)size);
            return new Point(0, size.cy);
        }
        char[] buffer = string.toCharArray();
        OS.GetTextExtentPoint32((long)this.handle, (char[])buffer, (int)length, (SIZE)size);
        return new Point(size.cx, size.cy);
    }

    public Point textExtent(String string) {
        return DPIUtil.autoScaleDown((Drawable)this.drawable, (Point)this.textExtentInPixels(string, 6));
    }

    public Point textExtent(String string, int flags) {
        return DPIUtil.autoScaleDown((Drawable)this.drawable, (Point)this.textExtentInPixels(string, flags));
    }

    Point textExtentInPixels(String string, int flags) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(4);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Point size = new Point(0, 0);
            this.drawText(gdipGraphics, string, 0, 0, flags, size);
            return size;
        }
        if (string.length() == 0) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32((long)this.handle, (char[])new char[]{' '}, (int)1, (SIZE)size);
            return new Point(0, size.cy);
        }
        RECT rect = new RECT();
        char[] buffer = string.toCharArray();
        int uFormat = 1024;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        OS.DrawText((long)this.handle, (char[])buffer, (int)buffer.length, (RECT)rect, (int)uFormat);
        return new Point(rect.right, rect.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        long hDC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, hDC);
        return gc;
    }

    public static GC win32_new(long hDC, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        data.style |= 0x2000000;
        int flags = OS.GetLayout((long)hDC);
        if ((flags & 1) != 0) {
            data.style |= 0xC000000;
        }
        gc.init(null, data, hDC);
        return gc;
    }

    private static int cos(int angle, int length) {
        return (int)(Math.cos((double)angle * (Math.PI / 180)) * (double)length);
    }

    private static int sin(int angle, int length) {
        return (int)(Math.sin((double)angle * (Math.PI / 180)) * (double)length);
    }
}

