/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.geom;

import com.tridium.gx.geom.AbstractVectorPathPainter;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;

public final class PathGeomPainter {
    private Point lastControlPoint;
    private final IPathGeom pathGeom;
    private final AbstractVectorPathPainter painter;

    private PathGeomPainter(IPathGeom pathGeom, AbstractVectorPathPainter painter) {
        this.pathGeom = pathGeom;
        this.painter = painter;
    }

    public static void paint(IPathGeom pathGeom, AbstractVectorPathPainter painter) {
        new PathGeomPainter(pathGeom, painter).paint();
    }

    private void paint() {
        int size = this.pathGeom.size();
        for (int i = 0; i < size; ++i) {
            IPathGeom.Segment seg;
            if (i == 0) {
                this.painter.beginPath();
            }
            if ((seg = this.pathGeom.segment(i)) instanceof IPathGeom.ClosePath) {
                this.closePath(i < size - 1);
                continue;
            }
            if (seg instanceof IPathGeom.MoveTo) {
                this.moveTo((IPathGeom.MoveTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.LineTo) {
                this.lineTo((IPathGeom.LineTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.CurveTo) {
                this.curveTo((IPathGeom.CurveTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.SmoothCurveTo) {
                this.smoothCurveTo((IPathGeom.SmoothCurveTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.QuadTo) {
                this.quadTo((IPathGeom.QuadTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.SmoothQuadTo) {
                this.smoothQuadTo((IPathGeom.SmoothQuadTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.HLineTo) {
                this.hLineTo((IPathGeom.HLineTo)seg);
                continue;
            }
            if (seg instanceof IPathGeom.VLineTo) {
                this.vLineTo((IPathGeom.VLineTo)seg);
                continue;
            }
            if (!(seg instanceof IPathGeom.ArcTo)) continue;
            this.arcTo((IPathGeom.ArcTo)seg);
        }
        this.painter.finish();
    }

    private void arcTo(IPathGeom.ArcTo arcTo) {
        double rx = arcTo.getRadiusX();
        double ry = arcTo.getRadiusY();
        double angle = arcTo.getXAxisRotation();
        boolean largeArcFlag = arcTo.getLargeArcFlag();
        boolean sweepFlag = arcTo.getSweepFlag();
        double x = arcTo.getX();
        double y = arcTo.getY();
        if (arcTo.isRelative()) {
            Point lastPoint = this.painter.getLastPoint();
            x += lastPoint.x;
            y += lastPoint.y;
        }
        this.painter.arcTo(x, y, rx, ry, angle, largeArcFlag, sweepFlag);
        this.painter.setLastPoint(new Point(x, y));
    }

    private void closePath(boolean beginNew) {
        if (this.lastControlPoint != null) {
            this.painter.closePath();
            if (beginNew) {
                this.painter.beginPath();
                this.painter.moveTo(this.lastControlPoint.x, this.lastControlPoint.y);
            } else {
                this.painter.setLastPoint(null);
                this.lastControlPoint = null;
            }
        }
    }

    private void curveTo(IPathGeom.CurveTo curveTo) {
        Point lastPoint = this.painter.getLastPoint();
        double x = curveTo.getX();
        double y = curveTo.getY();
        double x1 = curveTo.getX1();
        double y1 = curveTo.getY1();
        double x2 = curveTo.getX2();
        double y2 = curveTo.getY2();
        if (curveTo.isRelative()) {
            x += lastPoint.x;
            y += lastPoint.y;
            x1 += lastPoint.x;
            y1 += lastPoint.y;
            x2 += lastPoint.x;
            y2 += lastPoint.y;
        }
        this.painter.bezierCurveTo(x, y, x1, y1, x2, y2);
        this.painter.setLastPoint(new Point(x, y));
        this.lastControlPoint = new Point(x2, y2);
    }

    private void hLineTo(IPathGeom.HLineTo hLineTo) {
        Point lastPoint = this.painter.getLastPoint();
        double x = hLineTo.getX();
        double y = lastPoint.y;
        if (hLineTo.isRelative()) {
            x += lastPoint.x;
        }
        this.painter.lineTo(x, y);
        this.painter.setLastPoint(new Point(x, y));
    }

    private void lineTo(IPathGeom.LineTo lineTo) {
        double x = lineTo.getX();
        double y = lineTo.getY();
        if (lineTo.isRelative()) {
            Point lastPoint = this.painter.getLastPoint();
            x += lastPoint.x;
            y += lastPoint.y;
        }
        this.painter.lineTo(x, y);
        this.painter.setLastPoint(new Point(x, y));
    }

    private void moveTo(IPathGeom.MoveTo moveTo) {
        double x = moveTo.getX();
        double y = moveTo.getY();
        if (moveTo.isRelative()) {
            Point lastPoint = this.painter.getLastPoint();
            x += lastPoint.x;
            y += lastPoint.y;
        }
        this.painter.moveTo(x, y);
        this.painter.setLastPoint(new Point(x, y));
        this.lastControlPoint = new Point(x, y);
    }

    private void quadTo(IPathGeom.QuadTo quadTo) {
        double x = quadTo.getX();
        double y = quadTo.getY();
        double x1 = quadTo.getX1();
        double y1 = quadTo.getY1();
        if (quadTo.isRelative()) {
            Point lastPoint = this.painter.getLastPoint();
            x += lastPoint.x;
            y += lastPoint.y;
            x1 += lastPoint.x;
            y1 += lastPoint.y;
        }
        this.painter.quadraticCurveTo(x, y, x1, y1);
        this.painter.setLastPoint(new Point(x, y));
        this.lastControlPoint = new Point(x1, y1);
    }

    private void smoothCurveTo(IPathGeom.SmoothCurveTo smoothCurveTo) {
        Point lastPoint = this.painter.getLastPoint();
        double x = smoothCurveTo.getX();
        double y = smoothCurveTo.getY();
        double x1 = lastPoint.x;
        double y1 = lastPoint.y;
        double x2 = smoothCurveTo.getX2();
        double y2 = smoothCurveTo.getY2();
        if (this.lastControlPoint != null) {
            x1 += lastPoint.x - this.lastControlPoint.x;
            y1 += lastPoint.y - this.lastControlPoint.y;
        }
        if (smoothCurveTo.isRelative()) {
            x += lastPoint.x;
            y += lastPoint.y;
            x2 += lastPoint.x;
            y2 += lastPoint.y;
        }
        this.painter.bezierCurveTo(x, y, x1, y1, x2, y2);
        this.painter.setLastPoint(new Point(x, y));
        this.lastControlPoint = new Point(x2, y2);
    }

    private void smoothQuadTo(IPathGeom.SmoothQuadTo smoothQuadTo) {
        Point lastPoint = this.painter.getLastPoint();
        double x = smoothQuadTo.getX();
        double y = smoothQuadTo.getY();
        double x1 = lastPoint.x;
        double y1 = lastPoint.y;
        if (this.lastControlPoint != null) {
            x1 += lastPoint.x - this.lastControlPoint.x;
            y1 += lastPoint.y - this.lastControlPoint.y;
        }
        if (smoothQuadTo.isRelative()) {
            x += lastPoint.x;
            y += lastPoint.y;
        }
        this.painter.quadraticCurveTo(x, y, x1, y1);
        this.painter.setLastPoint(new Point(x, y));
        this.lastControlPoint = new Point(x1, y1);
    }

    private void vLineTo(IPathGeom.VLineTo vLineTo) {
        Point lastPoint = this.painter.getLastPoint();
        double x = lastPoint.x;
        double y = vLineTo.getY();
        if (vLineTo.isRelative()) {
            y += lastPoint.y;
        }
        this.painter.lineTo(x, y);
        this.painter.setLastPoint(new Point(x, y));
    }
}

