/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.DefaultGeomPeer;
import com.tridium.gx.awt.se.BatikPathPainter;
import com.tridium.gx.geom.PathGeomPainter;
import com.tridium.gx.geom.PolygonGeomPainter;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;

public abstract class AwtGeomPeer
extends DefaultGeomPeer {
    public static DefaultGeomPeer make(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                return new Line((ILineGeom)geom);
            }
            case 2: {
                return new Rect((IRectGeom)geom);
            }
            case 3: {
                return new Ellipse((IEllipseGeom)geom);
            }
            case 4: {
                return new Polygon((IPolygonGeom)geom);
            }
            case 5: {
                return new Path((IPathGeom)geom);
            }
        }
        throw new IllegalStateException();
    }

    public abstract Shape shape();

    public boolean contains(double x, double y) {
        return this.shape().contains(x, y);
    }

    public boolean contains(IGeom geom) {
        IRectGeom r = AwtGeomPeer.toRect((IGeom)geom);
        return this.shape().contains(r.x(), r.y(), r.width(), r.height());
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.shape().contains(x, y, w, h);
    }

    public boolean intersects(IGeom geom) {
        IRectGeom r = AwtGeomPeer.toRect((IGeom)geom);
        return this.shape().intersects(r.x(), r.y(), r.width(), r.height());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.shape().intersects(x, y, w, h);
    }

    public static class Path
    extends PathPeer {
        IPathGeom geom;

        Path(IPathGeom geom) {
            this.geom = geom;
            this.shape = new ExtendedGeneralPath(1, geom.size() + 4);
            this.draw();
        }

        public final IGeom geom() {
            return this.geom;
        }

        void draw() {
            PathGeomPainter.paint(this.geom, new BatikPathPainter(this.shape));
        }
    }

    public static class Polygon
    extends PathPeer {
        IPolygonGeom geom;

        Polygon(IPolygonGeom geom) {
            this.geom = geom;
            this.shape = new ExtendedGeneralPath(1, geom.size() + 4);
            this.draw();
        }

        public final IGeom geom() {
            return this.geom;
        }

        void draw() {
            PolygonGeomPainter.paint(this.geom, new BatikPathPainter(this.shape));
        }
    }

    public static abstract class PathPeer
    extends AwtGeomPeer {
        ExtendedGeneralPath shape;
        Rectangle2D bounds;

        @Override
        public final Shape shape() {
            return this.shape;
        }

        public final double x() {
            return this.b().getX();
        }

        public final double y() {
            return this.b().getY();
        }

        public final double width() {
            return this.b().getWidth();
        }

        public final double height() {
            return this.b().getHeight();
        }

        final Rectangle2D b() {
            if (this.bounds == null) {
                this.bounds = this.shape.getBounds2D();
            }
            return this.bounds;
        }
    }

    public static class Ellipse
    extends AwtGeomPeer {
        IEllipseGeom geom;
        Ellipse2D.Double shape = new Ellipse2D.Double();

        Ellipse(IEllipseGeom geom) {
            this.geom = geom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public final Shape shape() {
            this.shape.setFrame(this.geom.x(), this.geom.y(), this.geom.width(), this.geom.height());
            return this.shape;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }
    }

    public static class Rect
    extends AwtGeomPeer {
        IRectGeom geom;
        Rectangle2D.Double shape = new Rectangle2D.Double();

        Rect(IRectGeom geom) {
            this.geom = geom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public final Shape shape() {
            this.shape.setRect(this.geom.x(), this.geom.y(), this.geom.width(), this.geom.height());
            return this.shape;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }
    }

    public static class Line
    extends AwtGeomPeer {
        ILineGeom geom;
        Line2D.Double shape = new Line2D.Double();

        Line(ILineGeom geom) {
            this.geom = geom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        @Override
        public final Shape shape() {
            this.shape.setLine(this.geom.x1(), this.geom.y1(), this.geom.x2(), this.geom.y2());
            return this.shape;
        }

        public final double x() {
            return Math.min(this.geom.x1(), this.geom.x2());
        }

        public final double y() {
            return Math.min(this.geom.y1(), this.geom.y2());
        }

        public final double width() {
            return Math.max(this.geom.x1(), this.geom.x2()) - this.x();
        }

        public final double height() {
            return Math.max(this.geom.y1(), this.geom.y2()) - this.y();
        }
    }
}

