/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.DefaultGeomPeer;
import com.tridium.gx.awt.AwtEnv;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.Map;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;

public abstract class AwtGraphics
implements javax.baja.gx.Graphics {
    protected BFont font;
    protected BBrush brush;
    protected BPen pen;
    protected Graphics2D g;
    Stack<Graphics> stack = new Stack();
    private static final TextAttribute FONT = TextAttribute.FONT;
    private static final TextAttribute FAMILY = TextAttribute.FAMILY;

    public AwtGraphics(Graphics2D g) {
        this.g = g;
        this.brush = BBrush.DEFAULT;
        this.font = BFont.DEFAULT;
        this.pen = BPen.DEFAULT;
    }

    public final Graphics2D getAwtGraphics() {
        return this.g;
    }

    public final BBrush getBrush() {
        return this.brush;
    }

    public final void setBrush(BColor c) {
        this.setBrush(c.toBrush());
    }

    public final BPen getPen() {
        return this.pen;
    }

    public final BFont getFont() {
        return this.font;
    }

    public final void setFont(BFont font) {
        this.font = font;
        this.g.setFont(AwtEnv.peer((BFont)font).awtFont);
    }

    public final IGeom getClip() {
        return this.getClipBounds();
    }

    public final IRectGeom getClipBounds() {
        Rectangle r = this.g.getClipBounds();
        return new RectGeom((double)r.x, (double)r.y, (double)r.width, (double)r.height);
    }

    public final void clip(IGeom geom) {
        IRectGeom r = DefaultGeomPeer.toRect((IGeom)geom);
        this.clip(r.x(), r.y(), r.width(), r.height());
    }

    public void drawString(String str, double x, double y) {
        if (str == null) {
            return;
        }
        AttributedString as = this.asAttributedString(str);
        if (as != null) {
            this.drawString(as.getIterator(), x, y);
        } else {
            this.g.drawString(str, (int)x, (int)y);
        }
        if (this.font.isUnderline()) {
            this.drawUnderline(str, x, y);
        }
    }

    public void drawString(char[] data, int offset, int length, double x, double y) {
        if (data == null) {
            return;
        }
        this.drawString(new String(data, offset, length), x, y);
    }

    public final void drawImage(BImage img, double x, double y) {
        Image image = AwtEnv.peer(img).image();
        if (image != null) {
            this.g.drawImage(image, (int)x, (int)y, null);
        }
    }

    private void drawUnderline(String str, double x, double y) {
        int tw = (int)this.font.width(str);
        this.g.drawLine((int)x, (int)y + 2, (int)x + tw, (int)y + 2);
    }

    protected void drawString(AttributedCharacterIterator it, double x, double y) {
        if (null == it) {
            return;
        }
        this.g.drawString(it, (int)x, (int)y);
    }

    protected static AttributedString asAttributedString(BFont font, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        AttributedString as = null;
        Font awtFont = AwtEnv.peer((BFont)font).awtFont;
        int[] points = str.codePoints().toArray();
        if (AwtGraphics.offsetWasApplied(awtFont, points)) {
            str = new String(points, 0, points.length);
            as = AwtGraphics.createAttributedString(str, font);
        }
        int point = points[0];
        Font lastFont = FontSupport.supportedFont(font, point);
        int currentByte = Character.isSupplementaryCodePoint(point) ? 2 : 1;
        int lastMark = 0;
        for (int i = 1; i < points.length; ++i) {
            point = points[i];
            Font currentFont = FontSupport.supportedFont(font, point);
            if (!currentFont.equals(lastFont)) {
                if (as == null) {
                    as = AwtGraphics.createAttributedString(str, font);
                }
                as.addAttribute(FONT, lastFont, lastMark, currentByte);
                lastMark = currentByte;
            }
            currentByte += Character.isSupplementaryCodePoint(point) ? 2 : 1;
            lastFont = currentFont;
        }
        if (!lastFont.equals(awtFont) && as == null) {
            as = AwtGraphics.createAttributedString(str, font);
        }
        if (as != null) {
            as.addAttribute(FONT, lastFont, lastMark, str.length());
        }
        return as;
    }

    protected AttributedString asAttributedString(String str) {
        return AwtGraphics.asAttributedString(this.getFont(), str);
    }

    private static int getCodePointOffset(Font font) {
        String fontName = font.getName().toLowerCase();
        if ("symbol".equals(fontName) || "webdings".equals(fontName) || "wingdings".equals(fontName) || "wingdings 2".equals(fontName) || "wingdings 3".equals(fontName)) {
            return 61440;
        }
        return 0;
    }

    private static boolean offsetWasApplied(Font awtFont, int[] points) {
        int offset = AwtGraphics.getCodePointOffset(awtFont);
        boolean neededOffset = false;
        if (offset != 0) {
            for (int i = 0; i < points.length; ++i) {
                int offsetPoint = points[i] + offset;
                if (!awtFont.canDisplay(offsetPoint)) continue;
                points[i] = offsetPoint;
                neededOffset = true;
            }
        }
        return neededOffset;
    }

    private static AttributedString createAttributedString(String str, BFont font) {
        return new AttributedString(str, AwtGraphics.getAwtFont(font).getAttributes());
    }

    private static Font getAwtFont(BFont font) {
        return AwtEnv.peer((BFont)font).awtFont;
    }

    public void push() {
        this.stack.push(this.g.create());
    }

    public void pop() {
        if (!this.stack.empty()) {
            this.g.dispose();
            this.g = (Graphics2D)this.stack.pop();
        }
    }

    public final void dispose() {
        this.g.dispose();
        this.g = null;
        while (!this.stack.empty()) {
            this.g = (Graphics2D)this.stack.pop();
            this.g.dispose();
            this.g = null;
        }
    }

    private static class FontSupport {
        private static final String EXTENDED_FONTS_PROP = AccessController.doPrivileged(() -> System.getProperty("niagara.ui.extendedFontList", "Segoe UI Emoji,Segoe UI Symbol,Apple Color Emoji"));
        private static String MONOSPACED = "Monospaced";
        private static String SANS_SERIF = "SansSerif";
        private static Font[] EXTENDED_FONTS = (Font[])Arrays.stream(EXTENDED_FONTS_PROP.split(",")).map(s -> new Font(s.trim(), 0, 0)).toArray(Font[]::new);

        private FontSupport() {
        }

        private static boolean isMonospaced(BFont font) {
            FontMetrics fm = AwtEnv.peer(font).fm();
            return fm.charWidth('.') == fm.charWidth('m');
        }

        private static Font supportedFont(BFont font, int codePoint) {
            Font awtFont = AwtGraphics.getAwtFont(font);
            if (awtFont.canDisplay(codePoint)) {
                return awtFont;
            }
            if (Character.isSupplementaryCodePoint(codePoint)) {
                for (Font f : EXTENDED_FONTS) {
                    if (!f.canDisplay(codePoint)) continue;
                    return FontSupport.withFamily(awtFont, f.getFamily());
                }
            }
            return FontSupport.withFamily(awtFont, FontSupport.isMonospaced(font) ? MONOSPACED : SANS_SERIF);
        }

        private static Font withFamily(Font font, String family) {
            Map<TextAttribute, ?> atts = font.getAttributes();
            atts.put(FAMILY, family);
            return new Font(atts);
        }
    }
}

