/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platCrypto.certs;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.PrivateKeyDecryptionException;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.util.CommandLineArguments;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.Sys;
import javax.baja.user.BPasswordStrength;

public final class ConvertCertificate {
    private static final String IN_FORMAT_FLAG = "informat";
    private static final String OUT_FORMAT_FLAG = "outformat";
    private static final String IN_FILE_FLAG = "infile";
    private static final String OUT_FILE_FLAG = "outfile";
    private static final String IN_PASSWORD_FLAG = "inpass";
    private static final String OUT_PASSWORD_FLAG = "outpass";
    private static final Set<String> SUPPORTED_INPUT_FORMATS = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("PEM")));
    private static final Set<String> SUPPORTED_OUTPUT_FORMATS = BICertificateFormatHandler.getCertificateFormatHandlers().stream().map(it -> it.getCertificateFormatName(null)).collect(Collectors.toSet());

    private ConvertCertificate() {
    }

    public static void main(String[] args) throws IOException, PrivateKeyDecryptionException {
        ConvertCertificate.convert(System.out, args);
    }

    private static void usage(PrintStream out) {
        out.println("usage:");
        out.println("  convertCertificate <flags>");
        out.println("required flags:");
        out.println("  -informat:<format>      input format (" + String.join((CharSequence)",", SUPPORTED_INPUT_FORMATS) + ')');
        out.println("  -infile:<path>          FilePath of file to convert");
        out.println("  -outformat:<format>     output format (" + String.join((CharSequence)",", SUPPORTED_OUTPUT_FORMATS) + ')');
        out.println("  -outfile:<path>         FilePath to write converted file to");
        out.println("optional flags:");
        out.println("  -inpass:<password>      password for 'infile' if it is password protected");
        out.println("  -outpass:<password>     password to project 'outfile' with");
        out.println("  -o                      overwrite output file if it exists already");
    }

    private static void convert(PrintStream out, String[] args) throws IOException, PrivateKeyDecryptionException {
        IX509CertificateEntry inputEntry;
        CommandLineArguments arguments = new CommandLineArguments(args);
        if (arguments.hasHelpOption()) {
            ConvertCertificate.usage(out);
            return;
        }
        String inFormatArg = arguments.getOption(IN_FORMAT_FLAG);
        String outFormatArg = arguments.getOption(OUT_FORMAT_FLAG);
        String inFileArg = arguments.getOption(IN_FILE_FLAG);
        String outFileArg = arguments.getOption(OUT_FILE_FLAG);
        String inPassword = arguments.getOption(IN_PASSWORD_FLAG);
        String outPasswordArg = arguments.getOption(OUT_PASSWORD_FLAG);
        boolean overwrite = arguments.hasOption("o");
        if (Stream.of(inFormatArg, outFormatArg, inFileArg, outFileArg).anyMatch(Objects::isNull)) {
            ConvertCertificate.usage(out);
            return;
        }
        String inFormat = inFormatArg.toUpperCase(Locale.ENGLISH);
        if (!SUPPORTED_INPUT_FORMATS.contains(inFormat)) {
            out.println("Unsupported input format " + inFormatArg);
            out.println("Input format must be one of " + String.join((CharSequence)", ", SUPPORTED_INPUT_FORMATS));
            return;
        }
        if ("pkcs12".equals(outFormatArg.toLowerCase(Locale.ENGLISH)) && SecurityInitializer.getInstance().isFips()) {
            out.println("Cannot convert to PKCS12 format in FIPS mode. Re-run with '-fips=false'");
            return;
        }
        BICertificateFormatHandler outputHandler = BICertificateFormatHandler.getHandlerFromFormatName(outFormatArg, null);
        if (outputHandler == null) {
            out.println("Unsupported output format " + outFormatArg);
            out.println("Output format must be one of " + String.join((CharSequence)",", SUPPORTED_OUTPUT_FORMATS));
            return;
        }
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath inFilePath = new FilePath(inFileArg);
        BIFile inFile = fs.findFile(inFilePath);
        if (inFile == null) {
            out.println("Could not find input file " + inFilePath);
            return;
        }
        FilePath outFilePath = new FilePath(outFileArg);
        if (fs.findFile(outFilePath) != null && !overwrite) {
            out.println("Output file " + outFilePath + " already exists. Run with -o to overwrite");
            return;
        }
        BAbstractFile outFile = (BAbstractFile)fs.makeFile(outFilePath);
        try (InputStreamReader isr = new InputStreamReader(inFile.getInputStream(), StandardCharsets.UTF_8);
             FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);){
            inputEntry = CertUtils.parseCertificateEntryFromPem((String)"parsed", (Reader)fpr, (String)inPassword);
        }
        BPassword outPassword = null;
        if (outPasswordArg != null) {
            BPasswordStrength passwordStrength = ConvertCertificate.shouldBeFips() ? BPasswordStrength.FIPS_1 : BPasswordStrength.DEFAULT;
            boolean valid = passwordStrength.isPasswordValid(outPasswordArg.toCharArray(), msg -> out.println("Output password does not meet password strength requirements. " + msg.toString(null)));
            if (!valid) {
                return;
            }
            outPassword = BPassword.make((String)outPasswordArg);
        }
        outputHandler.writeCertAndKeyToFile(inputEntry.getPrivateKey(), outPassword != null, outPassword, inputEntry.getCertificates(), outFile);
    }

    private static boolean shouldBeFips() {
        if (SecurityInitializer.getInstance().isFips()) {
            return true;
        }
        try {
            Sys.getLicenseManager().checkFeature("tridium", "fips140-2");
            return true;
        }
        catch (FeatureNotLicensedException e) {
            return false;
        }
    }
}

