/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platCrypto.certs;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.nre.security.SecurityInitializer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.baja.file.BAbstractFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;

@NiagaraType
@NiagaraSingleton
public class BPKCS12CertificateHandler
extends BObject
implements BICertificateFormatHandler {
    @Generated
    public static final BPKCS12CertificateHandler INSTANCE = new BPKCS12CertificateHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BPKCS12CertificateHandler.class);
    private static final LexiconModule LEX = LexiconModule.make(BPKCS12CertificateHandler.class);
    private static final String MIME_TYPE = "application/x-pkcs12";
    private static final String DEFAULT_PKCS12_EXTENSION = "p12";
    private static final Set<String> PKCS12_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("p12", "pfx")));
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final PKCS12SafeBag[] EMPTY_PKCS12_BAG_ARRAY = new PKCS12SafeBag[0];
    private final ASN1ObjectIdentifier outputEncryptorAlgorithm;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPKCS12CertificateHandler() {
        boolean windowsCompatibility = AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty("niagara.platcrypto.pkcs12.windowsCompatibility", "true")));
        this.outputEncryptorAlgorithm = windowsCompatibility ? NISTObjectIdentifiers.id_aes256_CBC : NISTObjectIdentifiers.id_aes256_GCM;
    }

    @Override
    public void writeCertToFile(X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(certFile.getOutputStream());){
            PKCS12PfxPdu pfx = this.convertToPkcs12(null, null, certChain);
            ((OutputStream)outputStream).write(pfx.getEncoded());
        }
        catch (NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new IOException("Could not write certificate and key to file", e);
        }
    }

    @Override
    public void writeKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, BAbstractFile certFile) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(certFile.getOutputStream());){
            PKCS12PfxPdu pfx = this.convertToPkcs12(privateKey, (BPassword)(encryptKey ? encryptionKey : null), null);
            ((OutputStream)outputStream).write(pfx.getEncoded());
        }
        catch (NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new IOException("Could not write certificate and key to file", e);
        }
    }

    @Override
    public void writeCertAndKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(certFile.getOutputStream());){
            PKCS12PfxPdu pfx = this.convertToPkcs12(privateKey, encryptionKey, certChain);
            ((OutputStream)outputStream).write(pfx.getEncoded());
        }
        catch (NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new IOException("Could not write certificate and key to file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String writeCert(X509Certificate[] certChain) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            PKCS12PfxPdu pfx = this.convertToPkcs12(null, null, certChain);
            outputStream.write(pfx.getEncoded());
            outputStream.flush();
            String string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return string;
        }
        catch (NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new IOException("Could not write certificate and key to file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String writeKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            PKCS12PfxPdu pfx = this.convertToPkcs12(privateKey, (BPassword)(encryptKey ? encryptionKey : null), null);
            outputStream.write(pfx.getEncoded());
            outputStream.flush();
            String string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return string;
        }
        catch (NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new IOException("Could not write certificate and key to file", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String writeCertAndKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            PKCS12PfxPdu pfx = this.convertToPkcs12(privateKey, encryptionKey, certChain);
            outputStream.write(pfx.getEncoded());
            outputStream.flush();
            String string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return string;
        }
        catch (NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new IOException("Could not write certificate and key to file", e);
        }
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public Set<String> getSupportedFileExtensions() {
        return PKCS12_EXTENSIONS;
    }

    @Override
    public String getDefaultFileExtension() {
        return DEFAULT_PKCS12_EXTENSION;
    }

    @Override
    public String getCertificateFormatName(Context cx) {
        return LEX.get("cert.format.pkcs12.name", cx);
    }

    @Override
    public String getCertificateFormatFileTypeName(Context cx) {
        return LEX.get("cert.format.pkcs12.file.type", cx);
    }

    @Override
    public boolean supportsPrivateKey() {
        return true;
    }

    @Override
    public boolean supportsFipsMode() {
        return false;
    }

    private PKCS12PfxPdu convertToPkcs12(PrivateKey privateKey, BPassword encryptionKey, X509Certificate[] certChain) throws OperatorCreationException, NoSuchAlgorithmException, IOException, PKCSException {
        PKCS12SafeBag[] pkcs12Certs;
        SubjectKeyIdentifier publicKeyIdentifier;
        if (certChain != null) {
            List sortedChain = CertUtils.sortCertChain(Arrays.asList(certChain));
            PKCS12SafeBag[] publicKey = ((Certificate)sortedChain.get(0)).getPublicKey();
            JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
            publicKeyIdentifier = extensionUtils.createSubjectKeyIdentifier((PublicKey)publicKey);
            pkcs12Certs = new PKCS12SafeBag[sortedChain.size()];
            for (int i = 0; i < sortedChain.size(); ++i) {
                JcaPKCS12SafeBagBuilder builder = new JcaPKCS12SafeBagBuilder((X509Certificate)sortedChain.get(i));
                if (i == 0) {
                    builder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)publicKeyIdentifier);
                }
                pkcs12Certs[sortedChain.size() - 1 - i] = builder.build();
            }
        } else {
            pkcs12Certs = EMPTY_PKCS12_BAG_ARRAY;
            publicKeyIdentifier = null;
        }
        PKCS12PfxPduBuilder pfxPduBuilder = new PKCS12PfxPduBuilder();
        if (encryptionKey == null) {
            for (PKCS12SafeBag pkcs12Cert : pkcs12Certs) {
                pfxPduBuilder.addData(pkcs12Cert);
            }
            if (privateKey != null) {
                pfxPduBuilder.addData(BPKCS12CertificateHandler.buildPrivateKeyBag(privateKey, null, publicKeyIdentifier));
            }
        } else {
            if (pkcs12Certs.length > 0) {
                pfxPduBuilder.addEncryptedData(this.buildOutputEncryptor(encryptionKey), pkcs12Certs);
            }
            if (privateKey != null) {
                pfxPduBuilder.addData(BPKCS12CertificateHandler.buildPrivateKeyBag(privateKey, this.buildOutputEncryptor(encryptionKey), publicKeyIdentifier));
            }
        }
        char[] password = encryptionKey == null ? EMPTY_CHAR_ARRAY : AccessController.doPrivileged(() -> ((BPassword)encryptionKey).getValue()).toCharArray();
        return pfxPduBuilder.build((PKCS12MacCalculatorBuilder)new JcePKCS12MacCalculatorBuilder(), password);
    }

    private static PKCS12SafeBag buildPrivateKeyBag(PrivateKey privateKey, OutputEncryptor outputEncryptor, SubjectKeyIdentifier publicKeyIdentifier) {
        JcaPKCS12SafeBagBuilder keyBagBuilder = outputEncryptor != null ? new JcaPKCS12SafeBagBuilder(privateKey, outputEncryptor) : new JcaPKCS12SafeBagBuilder(privateKey);
        if (publicKeyIdentifier != null) {
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)publicKeyIdentifier);
        }
        return keyBagBuilder.build();
    }

    private OutputEncryptor buildOutputEncryptor(BPassword encryptionKey) throws OperatorCreationException {
        return new JcePKCSPBEOutputEncryptorBuilder(this.outputEncryptorAlgorithm).setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).setPRF(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, (ASN1Encodable)DERNull.INSTANCE)).setIterationCount(2048).build(AccessController.doPrivileged(() -> ((BPassword)encryptionKey).getValue()).toCharArray());
    }
}

