/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.crypto.core.io.CoreTrustStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.BaseSigningRequesterTask;
import com.tridium.platcrypto.signing.CheckOnboardingApproval;
import com.tridium.platcrypto.signing.GenerateCertificateAndSubmitCsr;
import com.tridium.platcrypto.signing.GetSigningResult;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.util.Lexicon;

class InitiateOnboarding
extends BaseSigningRequesterTask {
    private BString comment;

    InitiateOnboarding(BAbstractSigningRequester requester, BString comment, Context cx) {
        super(requester, cx);
        this.comment = comment;
    }

    @Override
    public boolean isOnboardingTaskOnly() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws Exception {
        BAbstractSigningRequester requester = this.getSigningRequester();
        try {
            X509Certificate[] certificateChain = AccessController.doPrivileged(() -> requester.getCertificateSigningResult(true));
            if (certificateChain != null) {
                GetSigningResult.storeSuccessfulSignedCertificate(requester, certificateChain, true);
                return;
            }
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause != null) {
                LocalizableException ex;
                if (cause instanceof LocalizableException && "signingService".equals((ex = (LocalizableException)cause).getLexiconModule()) && "requester.station.cannotConnect".equals(ex.getLexiconKey())) {
                    throw ex;
                }
                Exception priorCause = cause;
                if (priorCause != (cause = cause.getCause())) continue;
            }
        }
        String alias = requester.getRequesterComponent().getCertAlias();
        AtomicBoolean illegalOverwriteAttempt = new AtomicBoolean();
        try {
            AccessController.doPrivileged(() -> {
                ICoreKeyStore keyStore = BAbstractSigningRequester.getKeyStore(true);
                if (((CoreTrustStore)keyStore).containsAlias(alias)) {
                    illegalOverwriteAttempt.set(true);
                    if (!requester.getRequesterComponent().allowExistingCertReplacement()) {
                        BAbsTime certExpiration = requester.getCertificateExpiration(true);
                        if (!certExpiration.isNull() && BAbsTime.now().getMillis() > certExpiration.getMillis()) {
                            Optional<BPassword> certificatePassword = requester.getRequesterComponent().getCertificatePassword();
                            if (certificatePassword.isPresent()) {
                                try {
                                    try (SecretChars secretChars = certificatePassword.get().getSecretChars();){
                                        keyStore.getKey(alias, secretChars.get());
                                    }
                                    keyStore.deleteEntry(alias);
                                    illegalOverwriteAttempt.set(false);
                                    keyStore.save();
                                }
                                catch (Throwable throwable) {}
                            } else {
                                try {
                                    keyStore.getKey(alias, null);
                                    keyStore.deleteEntry(alias);
                                    illegalOverwriteAttempt.set(false);
                                    keyStore.save();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    } else {
                        Optional<BPassword> certificatePassword = requester.getRequesterComponent().getCertificatePassword();
                        if (certificatePassword.isPresent()) {
                            try {
                                try (SecretChars secretChars = certificatePassword.get().getSecretChars();){
                                    keyStore.getKey(alias, secretChars.get());
                                }
                                illegalOverwriteAttempt.set(false);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            try {
                                keyStore.getKey(alias, null);
                                illegalOverwriteAttempt.set(false);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                return null;
            });
        }
        catch (Throwable priorCause) {
            // empty catch block
        }
        if (illegalOverwriteAttempt.get()) {
            throw new LocalizableException("platCrypto", "signingRequester.certificateOverwriteAttempt", new Object[]{alias});
        }
        BString defaultComment = BString.make((String)Lexicon.make((String)"platCrypto", (Context)this.getContext()).getText("signingRequester.defaultOnboardingComment"));
        if (defaultComment.equals((Object)this.comment)) {
            this.comment = BString.DEFAULT;
        }
        requester.initiateOnboarding(this.comment.getString(), this.getContext());
        requester.setRequesterState(BRequesterState.approvalInProgress);
        if (requester.supportsApprovalCheck()) {
            this.scheduleNextTask(new CheckOnboardingApproval(requester, this.getContext()), requester.getApprovalCheckRetryDelay(), TimeUnit.MILLISECONDS);
            return;
        }
        this.submitNextTask(new GenerateCertificateAndSubmitCsr(requester, this.getContext()));
    }
}

