/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BCertificateDnFieldParameter;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.BCommonNamePart;
import com.tridium.session.SessionManager;
import com.tridium.util.CompUtil;
import java.util.Random;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dnField", type="String", defaultValue="CN", flags=1, override=true), @NiagaraProperty(name="prefix", type="BCommonNamePart", defaultValue="BCommonNamePart.DEFAULT"), @NiagaraProperty(name="middle", type="BCommonNamePart", defaultValue="BCommonNamePart.valueOfFormatSlot"), @NiagaraProperty(name="suffix", type="BCommonNamePart", defaultValue="BCommonNamePart.DEFAULT"), @NiagaraProperty(name="custom", type="BFormat", defaultValue="BFormat.make(\"%parent.name%\")"), @NiagaraProperty(name="separator", type="String", defaultValue="-")})
public class BCommonNameTemplate
extends BCertificateDnFieldParameter {
    @Generated
    public static final Property dnField = BCommonNameTemplate.newProperty((int)1, (String)"CN", null);
    @Generated
    public static final Property prefix = BCommonNameTemplate.newProperty((int)0, (BValue)BCommonNamePart.DEFAULT, null);
    @Generated
    public static final Property middle = BCommonNameTemplate.newProperty((int)0, (BValue)BCommonNamePart.valueOfFormatSlot, null);
    @Generated
    public static final Property suffix = BCommonNameTemplate.newProperty((int)0, (BValue)BCommonNamePart.DEFAULT, null);
    @Generated
    public static final Property custom = BCommonNameTemplate.newProperty((int)0, (BValue)BFormat.make((String)"%parent.name%"), null);
    @Generated
    public static final Property separator = BCommonNameTemplate.newProperty((int)0, (String)"-", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCommonNameTemplate.class);
    private BString resolved;
    private static final String DEVICE_TYPE = "driver:Device";
    private static final String NETWORK_TYPE = "driver:DeviceNetwork";
    private static final String NIAGARA_STATION_ADDRESS_PROP_NAME = "niagaraStationAddress";
    private static final Random RANDOM = new Random();
    private static final int UID_LENGTH = 16;

    @Generated
    public BCommonNamePart getPrefix() {
        return (BCommonNamePart)this.get(prefix);
    }

    @Generated
    public void setPrefix(BCommonNamePart v) {
        this.set(prefix, (BValue)v, null);
    }

    @Generated
    public BCommonNamePart getMiddle() {
        return (BCommonNamePart)this.get(middle);
    }

    @Generated
    public void setMiddle(BCommonNamePart v) {
        this.set(middle, (BValue)v, null);
    }

    @Generated
    public BCommonNamePart getSuffix() {
        return (BCommonNamePart)this.get(suffix);
    }

    @Generated
    public void setSuffix(BCommonNamePart v) {
        this.set(suffix, (BValue)v, null);
    }

    @Generated
    public BFormat getCustom() {
        return (BFormat)this.get(custom);
    }

    @Generated
    public void setCustom(BFormat v) {
        this.set(custom, (BValue)v, null);
    }

    @Generated
    public String getSeparator() {
        return this.getString(separator);
    }

    @Generated
    public void setSeparator(String v) {
        this.setString(separator, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BCommonNameTemplate make(BCommonNamePart middle) {
        BCommonNameTemplate template = new BCommonNameTemplate();
        template.setMiddle(middle);
        return template;
    }

    @Override
    public boolean isResolvable() {
        return true;
    }

    @Override
    protected BValue doResolve(Object obj, Context cx) {
        this.resolved = BString.make((String)this.format(obj, cx));
        return this.resolved;
    }

    @Override
    public boolean maySupplyCommonName() {
        return true;
    }

    @Override
    public String supplyCommonName() {
        return this.resolved != null ? this.resolved.toString() : null;
    }

    @Override
    public BCertificateParameter getNewInstanceForCsrGeneration(Context context) {
        BCertificateParameter result = super.getNewInstanceForCsrGeneration(context);
        if (BCommonNamePart.hasNiagaraStationAddress(this.getMiddle()) || BCommonNamePart.hasNiagaraStationAddress(this.getPrefix()) || BCommonNamePart.hasNiagaraStationAddress(this.getSuffix())) {
            BCommonNameTemplate.addDynamicPropForNiagaraStationAddress(result, this, context);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addDynamicPropForNiagaraStationAddress(BCertificateParameter param, BComponent base, Context cx) {
        boolean logNotAdded = true;
        try {
            NiagaraStation remoteStation;
            String foxSessionIdStr;
            FoxSession session;
            if (cx == null) {
                return;
            }
            BObject foxSessionId = cx.getFacet("foxSessionId");
            if (foxSessionId != null && (session = (FoxSession)SessionManager.getNiagaraSession((String)(foxSessionIdStr = foxSessionId.toString()), FoxSession.class)) != null && (remoteStation = (NiagaraStation)((BFoxConnection)session.conn()).getConnectionTarget(NiagaraStation.class).orElse(null)) instanceof BComponent) {
                BOrd addr = (BOrd)((BComponent)remoteStation).get("address").as(BOrd.class);
                OrdQuery[] ordQueries = addr.parse();
                CompUtil.removeIfPresent((BComponent)param, (String)NIAGARA_STATION_ADDRESS_PROP_NAME);
                param.add(NIAGARA_STATION_ADDRESS_PROP_NAME, (BValue)BString.make((String)ordQueries[ordQueries.length - 1].getBody()), 5);
                logNotAdded = false;
            }
        }
        catch (Exception e) {
            logNotAdded = false;
            if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
                BAbstractSigningRequester.LOG.log(Level.FINE, "Reverting to fallback option because the NiagaraStation Address encountered an unexpected error during CSR generation using " + base.toPathString() + " with Context = " + cx, e);
            }
        }
        finally {
            if (logNotAdded && BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
                BAbstractSigningRequester.LOG.fine("Reverting to fallback option because the NiagaraStation Address cannot be computed during CSR generation using " + base.toPathString() + " with Context = " + cx);
            }
        }
    }

    static String getNiagaraStationAddressFromDynamicProp(BCertificateParameter param) {
        String niagaraStationAddress = null;
        BValue niagaraStationAddressVal = param.get(NIAGARA_STATION_ADDRESS_PROP_NAME);
        if (niagaraStationAddressVal != null) {
            niagaraStationAddress = niagaraStationAddressVal.toString();
        }
        return niagaraStationAddress;
    }

    public String format(Object object, Context cx) {
        StringBuilder output = new StringBuilder();
        if (!this.getPrefix().equals((Object)BCommonNamePart.none)) {
            output.append(this.format(object, this.getPrefix(), cx)).append(this.getSeparator());
        }
        output.append(this.format(object, this.getMiddle(), cx));
        if (!this.getSuffix().equals((Object)BCommonNamePart.none)) {
            output.append(this.getSeparator()).append(this.format(object, this.getSuffix(), cx));
        }
        return output.toString();
    }

    private String format(Object object, BCommonNamePart part, Context cx) {
        if (BCommonNamePart.hasNiagaraStationAddress(part)) {
            String niagaraStationAddress = BCommonNameTemplate.getNiagaraStationAddressFromDynamicProp(this);
            if (niagaraStationAddress != null) {
                return niagaraStationAddress;
            }
            if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
                String objString = object instanceof BComponent ? ((BComponent)object).toPathString() : String.valueOf(object);
                BAbstractSigningRequester.LOG.fine("Reverting to fallback option because the NiagaraStation Address cannot be computed during CSR generation for " + objString);
            }
        }
        switch (part.getOrdinal()) {
            case 3: {
                BComplex device = BCommonNameTemplate.getDevice(object);
                return device != null ? device.getName() : "";
            }
            case 4: {
                BComplex network = BCommonNameTemplate.getNetwork(object);
                return network != null ? network.getName() : "";
            }
            case 1: {
                return this.getCustom().format(object, cx);
            }
            case 5: 
            case 9: {
                String host = Sys.getHostName();
                if (host == null || host.isEmpty()) {
                    throw new LocalizableRuntimeException("platCrypto", "commonNameTemplate.no.hostname");
                }
                return Sys.getHostName();
            }
            case 2: {
                return Sys.getStation().getStationName();
            }
            case 6: {
                byte[] buffer = new byte[16];
                RANDOM.nextBytes(buffer);
                return ByteArrayUtil.toHexString((byte[])buffer);
            }
            case 7: 
            case 10: {
                return BCommonNameTemplate.getIpAddress();
            }
            case 8: 
            case 11: {
                String hostName = Sys.getHostName();
                return hostName != null && !hostName.isEmpty() ? hostName : BCommonNameTemplate.getIpAddress();
            }
        }
        return "";
    }

    private static String getIpAddress() {
        return IPAddressUtil.getLocalHost().getHostAddress();
    }

    private static BComplex getDevice(Object object) {
        return BCommonNameTemplate.getParentWithType(object, DEVICE_TYPE);
    }

    private static BComplex getNetwork(Object object) {
        return BCommonNameTemplate.getParentWithType(object, NETWORK_TYPE);
    }

    private static BComplex getParentWithType(Object object, String wantedTypeSpec) {
        TypeInfo wantedType = Sys.getRegistry().getType(wantedTypeSpec);
        while (true) {
            if (object instanceof BComplex && ((BComplex)object).getType().is(wantedType)) {
                return (BComplex)object;
            }
            if (!(object instanceof BComplex)) break;
            object = ((BComplex)object).getParent();
        }
        return null;
    }
}

