/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.NGeneralName;
import com.tridium.crypto.core.cert.ext.NSubjectAlternativeName;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.json.JSONObject;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.BCommonNameTemplate;
import com.tridium.util.FormatUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Extension;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="parameterType", type="String", defaultValue="EXTENSION", flags=1, override=true), @NiagaraProperty(name="extensionOid", type="String", defaultValue="")})
public class BCertificateExtensionParameter
extends BCertificateParameter {
    @Generated
    public static final Property parameterType = BCertificateExtensionParameter.newProperty((int)1, (String)"EXTENSION", null);
    @Generated
    public static final Property extensionOid = BCertificateExtensionParameter.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateExtensionParameter.class);
    private static final String HOST_TOKEN = "hostname";
    private static final String IP_TOKEN = "ipAddress";
    private static final String HOST_OR_IP_TOKEN = "hostnameOrIpAddress";
    private static final String NIAGARA_STATION_ADDRESS_OR_HOST_TOKEN = "niagaraStationAddressOrHostname";
    private static final String NIAGARA_STATION_ADDRESS_OR_IP_TOKEN = "niagaraStationAddressOrIpAddress";
    private static final String NIAGARA_STATION_ADDRESS_OR_HOST_OR_IP_TOKEN = "niagaraStationAddressOrHostnameOrIpAddress";
    public static final String PLACEHOLDER_IP = "0.0.0.0";
    public static final String CN_FORMAT = "%commonName%";
    public static final String HOSTNAME_FORMAT = "%hostname%";
    public static final String IP_FORMAT = "%ipAddress%";
    public static final String HOST_OR_IP_FORMAT = "%hostnameOrIpAddress%";
    public static final String NIAGARA_STATION_ADDRESS_OR_HOST_FORMAT = "%niagaraStationAddressOrHostname%";
    public static final String NIAGARA_STATION_ADDRESS_OR_IP_FORMAT = "%niagaraStationAddressOrIpAddress%";
    public static final String NIAGARA_STATION_ADDRESS_OR_HOST_OR_IP_FORMAT = "%niagaraStationAddressOrHostnameOrIpAddress%";
    public static final BString FIELD_EDITOR = BString.make((String)"platCrypto:CertificateExtensionParameterFE");
    public static final BString UX_FIELD_EDITOR = BString.make((String)"platCrypto:SingleExtensionEditor");

    @Generated
    public String getExtensionOid() {
        return this.getString(extensionOid);
    }

    @Generated
    public void setExtensionOid(String v) {
        this.setString(extensionOid, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void added(Property property, Context context) {
        if (property.getName().equals("value")) {
            Slot valueSlot = this.getSlot("value");
            this.setFacets(valueSlot, BFacets.make((BFacets)this.getSlotFacets(valueSlot), (String)"fieldEditor", (BIDataValue)FIELD_EDITOR));
            this.setFacets(valueSlot, BFacets.make((BFacets)this.getSlotFacets(valueSlot), (String)"uxFieldEditor", (BIDataValue)UX_FIELD_EDITOR));
            this.updateExtensionOid();
        }
    }

    public void changed(Property property, Context context) {
        if (property.getName().equals("value")) {
            this.updateExtensionOid();
        }
    }

    public static BCertificateExtensionParameter make(String oid, String value) {
        BCertificateExtensionParameter parameter = new BCertificateExtensionParameter();
        parameter.setExtensionOid(oid);
        parameter.setValue((BValue)BString.make((String)value));
        return parameter;
    }

    @Override
    public boolean isResolvable() {
        return true;
    }

    @Override
    protected BValue doResolve(Object obj, Context cx) {
        NSubjectAlternativeName subjectAlternativeName;
        if (this.isSANExtension() && (subjectAlternativeName = (NSubjectAlternativeName)this.makeExtension()) != null) {
            try {
                subjectAlternativeName = this.replaceTokens(subjectAlternativeName, obj, cx);
                return BString.make((String)subjectAlternativeName.encodeToString());
            }
            catch (IOException e) {
                BAbstractSigningRequester.LOG.log(Level.WARNING, String.format("Failed to encode certificate parameter: %s of type %s", this.getName(), this.getParameterType()), e);
            }
        }
        return null;
    }

    @Override
    public BCertificateParameter getNewInstanceForCsrGeneration(Context context) {
        BCertificateParameter result = super.getNewInstanceForCsrGeneration(context);
        BCommonNameTemplate.addDynamicPropForNiagaraStationAddress(result, this, context);
        return result;
    }

    @Override
    public boolean equivalent(Object obj) {
        if (!(obj instanceof BCertificateExtensionParameter)) {
            return false;
        }
        BCertificateExtensionParameter other = (BCertificateExtensionParameter)obj;
        boolean sameOid = other.getExtensionOid().equals(this.getExtensionOid());
        if (this.isSANExtension()) {
            return sameOid && this.getValue().equivalent((Object)other.getValue());
        }
        return sameOid;
    }

    private void updateExtensionOid() {
        this.setExtensionOid(this.extractOidFromJsonValue());
    }

    public boolean hasJsonExtValue() {
        JSONObject json;
        String strVal = ((BString)this.getValue().as(BString.class)).getString();
        if (!strVal.isEmpty() && (json = new JSONObject(strVal)).has("value")) {
            Object value = json.get("value");
            return !value.equals(JSONObject.NULL) && !value.equals("");
        }
        return false;
    }

    public IX509Extension makeExtension() {
        String json;
        if (this.getValue() instanceof BString && this.hasJsonExtValue() && !(json = ((BString)this.getValue().as(BString.class)).getString()).isEmpty()) {
            try {
                return NX509Extension.decodeFromString((String)json);
            }
            catch (CertificateParseException | IOException e) {
                BAbstractSigningRequester.LOG.log(Level.WARNING, String.format("Failed to decode certificate parameter: %s of type %s with value %s", this.getName(), this.getParameterType(), json), e);
            }
        }
        return null;
    }

    private boolean isSANExtension() {
        return this.getExtensionOid().equals(Extension.subjectAlternativeName.getId());
    }

    private NSubjectAlternativeName replaceTokens(NSubjectAlternativeName original, Object obj, Context cx) throws IOException {
        Context replacements = this.buildReplacements(cx);
        Collection formatted = original.getNames().stream().map(name -> BCertificateExtensionParameter.format(name, obj, replacements)).collect(Collectors.toList());
        return NSubjectAlternativeName.make((boolean)original.isCritical(), (Collection)formatted);
    }

    private Context buildReplacements(Context cx) {
        String hostName = Sys.getHostName();
        String ipAddress = IPAddressUtil.getLocalHost().getHostAddress();
        boolean hostNameExists = hostName != null && !hostName.isEmpty();
        String niagaraStationAddress = BCommonNameTemplate.getNiagaraStationAddressFromDynamicProp(this);
        boolean niagaraStationAddressExists = niagaraStationAddress != null && !niagaraStationAddress.isEmpty();
        BFacets defaultFacets = BFacets.make((String[])new String[]{HOST_TOKEN, IP_TOKEN, HOST_OR_IP_TOKEN, NIAGARA_STATION_ADDRESS_OR_HOST_TOKEN, NIAGARA_STATION_ADDRESS_OR_IP_TOKEN, NIAGARA_STATION_ADDRESS_OR_HOST_OR_IP_TOKEN}, (BIDataValue[])new BIDataValue[]{BString.make((String)hostName), BString.make((String)ipAddress), BString.make((String)(hostNameExists ? hostName : ipAddress)), BString.make((String)(niagaraStationAddressExists ? niagaraStationAddress : hostName)), BString.make((String)(niagaraStationAddressExists ? niagaraStationAddress : ipAddress)), BString.make((String)(niagaraStationAddressExists ? niagaraStationAddress : (hostNameExists ? hostName : ipAddress)))});
        return cx != null ? BFacets.make((BFacets)cx.getFacets(), (BFacets)defaultFacets) : defaultFacets;
    }

    private static NGeneralName format(NGeneralName generalName, Object obj, Context replacements) {
        String original = generalName.getValueAsString().trim();
        if (generalName.getTagNo() == 7 && PLACEHOLDER_IP.equals(original)) {
            original = IP_FORMAT;
        }
        String resolved = FormatUtil.formatFromContextFacets((String)original, (Context)replacements);
        if ((resolved = BFormat.make((String)resolved).format(obj, replacements)).isEmpty() || FormatUtil.FORMAT_TOKEN.matcher(resolved).matches()) {
            throw new LocalizableRuntimeException("platCrypto", "certificateExtensionParameter.san.unresolved", new Object[]{original});
        }
        int tagNo = generalName.getTagNo();
        if ((HOST_OR_IP_FORMAT.equals(original) || NIAGARA_STATION_ADDRESS_OR_IP_FORMAT.equals(original) || NIAGARA_STATION_ADDRESS_OR_HOST_OR_IP_FORMAT.equals(original) || CN_FORMAT.equals(original)) && IPAddressUtil.isNumericAddrFormat((String)resolved)) {
            tagNo = 7;
        }
        return NGeneralName.make((GeneralName)new GeneralName(tagNo, resolved));
    }

    private String extractOidFromJsonValue() {
        Object oid;
        JSONObject json;
        String strVal = ((BString)this.getValue().as(BString.class)).getString();
        if (!strVal.isEmpty() && (json = new JSONObject(strVal)).has("oid") && !(oid = json.get("oid")).equals(JSONObject.NULL) && !oid.equals("")) {
            return oid.toString();
        }
        return "";
    }
}

