/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreProviderInfo;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.Version;
import com.tridium.platcrypto.fox.ChannelBase;
import com.tridium.platcrypto.fox.ChannelExemptionStore;
import com.tridium.platcrypto.fox.ChannelKeyStore;
import com.tridium.platcrypto.fox.ChannelProviderInfo;
import com.tridium.platcrypto.fox.ChannelTrustStore;
import java.io.IOException;
import javax.baja.sys.BComponent;

public class ChannelCryptoManager
extends ChannelBase
implements ICoreCryptoManager {
    private final BComponent parent;

    public ChannelCryptoManager(BComponent parent) {
        super(parent);
        this.parent = parent;
    }

    public ICoreKeyStore getKeyStore() throws Exception {
        return new ChannelKeyStore(this.parent, CryptoStoreId.USER_KEY_STORE);
    }

    public ICoreTrustStore getUserTrustStore() throws Exception {
        return new ChannelTrustStore(this.parent, CryptoStoreId.USER_TRUST_STORE);
    }

    public ICoreTrustStore getUserUntrustedStore() throws Exception {
        return new ChannelTrustStore(this.parent, CryptoStoreId.USER_UNTRUSTED_STORE);
    }

    public ICoreTrustStore getSystemTrustStore() throws Exception {
        return new ChannelTrustStore(this.parent, CryptoStoreId.SYSTEM_TRUST_STORE);
    }

    public ICoreExemptionStore getExemptionStore() throws Exception {
        return new ChannelExemptionStore(this.parent);
    }

    public ICoreProviderInfo getProviderInfo() throws Exception {
        return new ChannelProviderInfo(this.parent);
    }

    public int generateSelfSignedCert(NX509CertificateBuilder builder, NKeyPairGenerator generator, SecretChars newPassword) throws Exception {
        return this.generateSelfSignedCert(builder, generator, null, newPassword);
    }

    public int generateSelfSignedCert(NX509CertificateBuilder builder, NKeyPairGenerator generator, SecretChars existingPassword, SecretChars newPassword) throws Exception {
        this.checkChannel();
        Version remoteVersion = this.getCryptoManagerVersion();
        if (remoteVersion.compareTo((Object)ADVANCED_CERT_GEN_VERSION) >= 0) {
            return this.channel.mgrGenerateSelfSignedCert(builder, generator, existingPassword, newPassword);
        }
        throw new UnsupportedOperationException("builder generated certificates are not supported by peer station");
    }

    @Deprecated
    public int generateSelfSignedCert(NCertificateParameters certParams) throws Exception {
        Version remoteVersion = this.getCryptoManagerVersion();
        if (remoteVersion.compareTo((Object)ADVANCED_CERT_GEN_VERSION) < 0) {
            return this.channel.mgrGenerateSelfSignedCert(certParams);
        }
        return this.generateSelfSignedCert(CertUtils.createCertBuilderFromParameters((NCertificateParameters)certParams), (NKeyPairGenerator)new NRsaKeyPairGenerator(certParams.getKeySize()), null, SecretChars.fromString((String)certParams.getPassword()));
    }

    public int resetUserKeyStore() throws Exception {
        this.checkChannel();
        return this.channel.mgrResetUserKeyStore();
    }

    public int getCertGenerationStatus(int requestId) throws Exception {
        return this.channel.mgrGetCertGenerationStatus(requestId);
    }

    public NPKCS10CertificationRequest generateCSR(String alias, String passwd) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGenerateCSR(alias, passwd);
    }

    public boolean canGenerateCertificate() {
        return true;
    }

    public Version getCryptoManagerVersion() throws IOException {
        this.checkChannel();
        return new Version(this.channel.getFoxSession().getConnection().getRemoteVersion().toString());
    }
}

