/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.daemon.messages.CryptoServletMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import javax.baja.nre.security.SharedSecretKey;

public class GetKeyMessage
extends KeyStoreMessage {
    private SecretChars password = null;

    public GetKeyMessage(String keyStoreType, String alias, char[] password, SharedSecretKey sharedKey) {
        super(keyStoreType);
        this.add("alias", alias);
        this.sharedSecretKey = sharedKey;
        if (password != null && password.length > 0) {
            this.password = new SecretChars(password, false);
        }
    }

    @Override
    public synchronized String getMessageString() {
        this.add("sharedKeyName", this.sharedSecretKey.getName());
        if (this.password != null) {
            String encryptedPassword = this.prepareMessage(this.password, this.sharedSecretKey);
            this.add("passwd", encryptedPassword, CryptoServletMessage.EncodingMask.key);
            this.password.close();
            this.password = null;
        }
        return super.getMessageString();
    }

    @Override
    public String getAction() {
        return "getKey";
    }
}

