/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.daemon.messages.CryptoServletMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import javax.baja.nre.security.SharedSecretKey;

public class GenerateCsrMessage
extends KeyStoreMessage {
    private SecretChars password = null;

    public GenerateCsrMessage(String keyStoreType, String alias, String passwd, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.add("alias", alias);
        if (passwd != null) {
            this.password = SecretChars.fromString((String)passwd);
        }
        this.sharedSecretKey = sharedSecretKey;
    }

    @Override
    public synchronized String getMessageString() {
        if (this.password != null) {
            this.add("passwd", this.prepareMessage(this.password, this.sharedSecretKey), CryptoServletMessage.EncodingMask.key);
            this.add("sharedKeyName", this.sharedSecretKey.getName());
            this.password.close();
            this.password = null;
        }
        return super.getMessageString();
    }

    @Override
    public String getAction() {
        return "generateCsr";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

