/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.nre.security.SecretBytes;
import com.tridium.platcrypto.daemon.messages.CryptoServletMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.baja.nre.security.SharedSecretKey;

public class GenerateCertificateMessage
extends KeyStoreMessage {
    private SecretBytes certParams;

    public GenerateCertificateMessage(String keyStoreType, NCertificateParameters certParams, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.sharedSecretKey = sharedSecretKey;
        try {
            this.certParams = SecretBytes.fromString((String)certParams.encodeToString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized String getMessageString() {
        if (this.certParams != null) {
            this.add("certParams", this.prepareMessage(this.certParams, this.sharedSecretKey), CryptoServletMessage.EncodingMask.key);
            this.add("sharedKeyName", this.sharedSecretKey.getName());
            this.certParams.close();
            this.certParams = null;
        }
        return super.getMessageString();
    }

    @Override
    public String getAction() {
        return "generateCert";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

