/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.cert.NX509CertificateBuilderBundle;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.daemon.messages.CryptoServletMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.util.logging.Level;
import javax.baja.nre.security.SharedSecretKey;

public class GenerateCertificateBuilderMessage
extends KeyStoreMessage {
    private SecretBytes genCertMessage;

    public GenerateCertificateBuilderMessage(String keyStoreType, NX509CertificateBuilder builder, NKeyPairGenerator generator, SecretChars password, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.sharedSecretKey = sharedSecretKey;
        try {
            NX509CertificateBuilderBundle bundle = new NX509CertificateBuilderBundle(builder, generator, password);
            this.genCertMessage = SecretBytes.fromString((String)bundle.encodeToString());
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Could not create GenerateCertificateMessage", e);
            }
            LOG.log(Level.WARNING, "Could not create GenerateCertificateMessage");
        }
    }

    @Override
    public synchronized String getMessageString() {
        if (this.genCertMessage != null) {
            this.add("certBuilder", this.prepareMessage(this.genCertMessage, this.sharedSecretKey), CryptoServletMessage.EncodingMask.key);
            this.add("sharedKeyName", this.sharedSecretKey.getName());
        }
        return super.getMessageString();
    }

    @Override
    public String getAction() {
        return "generateCert";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }
}

