/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.nre.security.KeyStorePermission;
import com.tridium.platcrypto.daemon.BPlatCryptoBase;
import com.tridium.platcrypto.daemon.messages.DeleteExemptionMessage;
import com.tridium.platcrypto.daemon.messages.GetExemptionMessage;
import com.tridium.platcrypto.daemon.messages.GetExemptionsMessage;
import com.tridium.platcrypto.daemon.messages.SaveExemptionMessage;
import com.tridium.platcrypto.daemon.messages.SetExemptionMessage;
import com.tridium.platform.daemon.BDaemonSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BPlatExemptionStore
extends BPlatCryptoBase
implements ICoreExemptionStore {
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatExemptionStore.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPlatExemptionStore() {
    }

    public BPlatExemptionStore(BDaemonSession newSession) {
        super(newSession);
    }

    public long getLastModified() throws Exception {
        return 0L;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Enumeration<NHostExemption> exemptions() throws Exception {
        KeyStorePermission.checkRead((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        XElem[] exemptions = this.send(new GetExemptionsMessage(), "exemption");
        ArrayList<NHostExemption> exemptionList = new ArrayList<NHostExemption>(exemptions != null ? exemptions.length : 0);
        if (exemptions != null) {
            for (XElem exemption : exemptions) {
                exemptionList.add(NHostExemption.decodeFromString((String)exemption.text().string()));
            }
            return Collections.enumeration(exemptionList);
        }
        return null;
    }

    public NHostExemption getExemption(String host) throws Exception {
        KeyStorePermission.checkRead((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        XElem[] exemptions = this.send(new GetExemptionMessage(host), "exemption");
        if (exemptions != null && exemptions.length > 0) {
            return NHostExemption.decodeFromString((String)exemptions[0].text().string());
        }
        return null;
    }

    public void setExemption(NHostExemption exemption) throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        this.send(new SetExemptionMessage(exemption));
    }

    public void deleteExemption(String host) throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        this.send(new DeleteExemptionMessage(host));
    }

    public void load() throws Exception {
    }

    public void save() throws Exception {
        KeyStorePermission.checkWrite((String)CryptoStoreId.USER_EXEMPTION_STORE.getValue());
        this.send(new SaveExemptionMessage());
    }
}

