/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.core;

import com.tridium.crypto.core.io.ICoreTrustStore;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.baja.nre.security.IX509CertificateEntry;

public class WbAppletTrustStore
implements ICoreTrustStore {
    private final KeyStore keyStore;

    public WbAppletTrustStore() throws Exception {
        File trustStoreFile = null;
        String trustStoreName = AccessController.doPrivileged(() -> System.getProperty("javax.net.ssl.trustStore"));
        String trustStorePassword = AccessController.doPrivileged(() -> System.getProperty("javax.net.ssl.trustStorePassword", "changeit"));
        if (trustStoreName != null) {
            trustStoreFile = new File(trustStoreName);
        }
        if (trustStoreName == null || !trustStoreFile.exists()) {
            trustStoreFile = new File(AccessController.doPrivileged(() -> System.getProperty("java.home")), "lib/security/jssecacerts");
        }
        if (!trustStoreFile.exists()) {
            trustStoreFile = new File(AccessController.doPrivileged(() -> System.getProperty("java.home")), "lib/security/cacerts");
        }
        this.keyStore = KeyStore.getInstance("BCFKS");
        if (trustStoreFile.exists()) {
            try (FileInputStream in = new FileInputStream(trustStoreFile);){
                this.keyStore.load(in, trustStorePassword.toCharArray());
            }
        }
    }

    public Enumeration<String> aliases() throws Exception {
        return this.keyStore.aliases();
    }

    public boolean containsAlias(String alias) throws Exception {
        return this.keyStore.containsAlias(alias);
    }

    public void deleteEntry(String alias) throws Exception {
        throw new UnsupportedOperationException("not supported by the applet");
    }

    public X509Certificate getCertificate(String alias) throws Exception {
        return (X509Certificate)this.keyStore.getCertificate(alias);
    }

    public String getCertificateAlias(X509Certificate cert) throws Exception {
        return this.keyStore.getCertificateAlias(cert);
    }

    public X509Certificate[] getCertificateChain(String alias) throws Exception {
        return (X509Certificate[])this.keyStore.getCertificateChain(alias);
    }

    public Date getCreationDate(String alias) throws Exception {
        return this.keyStore.getCreationDate(alias);
    }

    public boolean isKeyEntry(String alias) throws Exception {
        return this.keyStore.isKeyEntry(alias);
    }

    public boolean isCertificateEntry(String alias) throws Exception {
        return this.keyStore.isCertificateEntry(alias);
    }

    public void setCertificateEntry(String alias, X509Certificate cert) throws Exception {
        throw new UnsupportedOperationException("not supported by the applet");
    }

    public int size() throws Exception {
        return this.keyStore.size();
    }

    public long getLastModified() throws Exception {
        throw new UnsupportedOperationException("not supported by the applet");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void load() throws Exception {
    }

    public void save() throws Exception {
        throw new UnsupportedOperationException("not supported by the applet");
    }

    public Iterable<IX509CertificateEntry> getCertificateEntries() throws Exception {
        return null;
    }

    public Iterable<IX509CertificateEntry> getFullCertificateEntries() {
        return null;
    }

    public String findCertificate(X509Certificate cert) throws Exception {
        return null;
    }

    public void deleteEntries(String[] aliases) throws Exception {
        throw new UnsupportedOperationException("not supported by the applet");
    }

    public KeyStore getKeyStore() throws Exception {
        throw new UnsupportedOperationException("not supported by the applet");
    }
}

