/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;

public final class ForgeUtils {
    private static final Logger log = Logger.getLogger("cloudLink.forge");

    private ForgeUtils() {
    }

    public static String getStringValue(BValue value) {
        if (value instanceof BDouble) {
            BDouble doubleValue = (BDouble)value;
            try {
                return doubleValue.encodeToString();
            }
            catch (IOException e) {
                log.warning("Unable to encode double value to string: " + e.getMessage());
                return "";
            }
        }
        if (value instanceof BFloat) {
            BFloat floatValue = (BFloat)value;
            try {
                return floatValue.encodeToString();
            }
            catch (IOException e) {
                log.warning("Unable to encode float value to string: " + e.getMessage());
                return "";
            }
        }
        return value.toString();
    }

    public static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x <= upper;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.warning("URL encoding of \"" + value + "\" with \"" + StandardCharsets.UTF_8.name() + "\" not supported.");
            return value;
        }
    }

    public static String makeHeaderString(Map<String, Object> messageHeaders) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : messageHeaders.entrySet()) {
            stringBuilder.append('[');
            stringBuilder.append(entry.getKey());
            stringBuilder.append("]=[");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("], ");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("Empty Map, ");
        }
        return stringBuilder.toString();
    }
}

