/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.util;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.forge.channel.BForgeModelChannelConfig;
import com.tridium.cloudLink.forge.model.BModelIdSourceState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Id;

public final class CloudLinkForgeTagUtil {
    private static final Logger log = Logger.getLogger("cloudLink.tag");
    private static final Id DRIVER_POINT_ID_TAG_ID = Id.newId((String)"nc", (String)"driverPointId");

    private CloudLinkForgeTagUtil() {
    }

    public static String getOrAddCloudId(BForgeModelChannelConfig forgeConfig, BIEntity entity) {
        Function<BIEntity, String> idFunction;
        Objects.requireNonNull(entity);
        if (forgeConfig.getPointIdSource() == BModelIdSourceState.cloudId) {
            log.finer("Model Config set to use Cloud Id.");
            idFunction = forgeConfig.getCloudIdFunction();
        } else {
            log.finer("Model Config set to use Driver Point Id.  Checking for PropertySuppliedTag PointId.");
            idFunction = CloudLinkForgeTagUtil.makeIdFunction(forgeConfig.getCloudIdFunction());
        }
        String cloudId = TagUtil.getOrAddCloudId((BIEntity)entity, idFunction);
        log.finer(() -> "Setting Cloud Id to " + cloudId);
        return cloudId;
    }

    private static Function<BIEntity, String> makeIdFunction(Function<BIEntity, String> defaultFunction) {
        return e -> {
            Optional optCloudId = e.tags().get(DRIVER_POINT_ID_TAG_ID);
            if (optCloudId.isPresent()) {
                return ((BIDataValue)optCloudId.orElseThrow(TagUtil.makeCloudIdExceptionSupplier((BIEntity)e))).toString();
            }
            return (String)defaultFunction.apply((BIEntity)e);
        };
    }
}

