/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.IFileUploadInfo;
import com.tridium.cloudLink.forge.msg.ForgeHttpStartFileUploadResult;
import com.tridium.cloudLink.msg.ISensitiveMessageBuilder;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.CertificateAliasAndPasswordWrapper;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeHttpStartFileUploadHandler
implements IStartFileUploadHandler,
ISensitiveMessageBuilder {
    private FileUploadRequest uploadRequest;
    private final BChannelConfig config;
    private Map<String, IValueWrapper<?>> connectionInfo;
    protected JSONWriter jsonSerializer;
    protected StringWriter stringWriter;
    private static final Logger log = Logger.getLogger("cloudLink.file.upload");
    public static final String FORGE_FILE_UPLOAD_URL_TEMPLATE = "https://%s/api/systems/%s/fileuploadrequest";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_DETAILS = "fileDetails";

    public ForgeHttpStartFileUploadHandler(BChannelConfig channelConfig) {
        this.config = channelConfig;
        this.stringWriter = new StringWriter();
        this.jsonSerializer = QuickJSONWriter.make((Appendable)this.stringWriter);
    }

    public void loadSensitives() {
        this.connectionInfo = this.config.getAuthenticator(IStartFileUploadHandler.getOperationId()).getConnectionInfo(null);
    }

    public int add(FileUploadRequest value) {
        this.uploadRequest = value;
        return 0;
    }

    public IMessage toMessage(boolean isFinal) {
        if (this.connectionInfo == null || this.connectionInfo.isEmpty()) {
            throw new RuntimeException("Connection information unavailable");
        }
        URL url = null;
        try {
            url = new URI(String.format(FORGE_FILE_UPLOAD_URL_TEMPLATE, StringWrapper.getString(this.connectionInfo.get("hostName")), StringWrapper.getString(this.connectionInfo.get("id")))).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.log(Level.WARNING, "Unable to build URL for start file upload request", log.isLoggable(Level.FINE) ? ex : null);
        }
        this.jsonSerializer.object();
        this.jsonSerializer.key(FILE_NAME).value((Object)this.uploadRequest.getFileName());
        Map metadata = this.uploadRequest.getMetadata();
        if (!metadata.isEmpty()) {
            this.jsonSerializer.key(FILE_DETAILS).object();
            for (Map.Entry entry : metadata.entrySet()) {
                this.jsonSerializer.key((String)entry.getKey()).value(entry.getValue());
            }
            this.jsonSerializer.endObject();
        }
        this.jsonSerializer.endObject();
        this.stringWriter.flush();
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending file upload request message with correlation " + correlationId);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("x-activity-id", correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, requestHeaders).mimeType("application/json").body(this.stringWriter.toString()).certificateAliasAndPassword(CertificateAliasAndPasswordWrapper.getCertificateAliasAndPassword(this.connectionInfo.get("certAliasAndPassword"))).build();
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<IFileUploadInfo> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> reqFuture = new CompletableFuture<IMessageResponse>();
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage response = (HttpResponseMessage)resp;){
                    ForgeHttpStartFileUploadResult startFileUploadResult = new ForgeHttpStartFileUploadResult(response.getBodyAsString());
                    channelFuture.complete(startFileUploadResult);
                }
                catch (Exception ex) {
                    channelFuture.completeExceptionally(ex);
                }
            }
        });
        return reqFuture;
    }
}

