/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.msg.ForgeSendHeartbeatResult;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeAmqpSendHeartbeatHandler
extends ForgeAmqpHandler
implements ISendHeartbeatHandler {
    private final IForgeChannelConfig config;
    public static final String COMMAND = "HeartbeatRequest";
    public static final String EVENT_ID = "EventId";
    public static final String SYSTEM_TIME = "SystemTime";
    public static final String VERSION = "1";
    private static final int MSG_END_SIZE = 1;
    private static final Logger log = Logger.getLogger("cloudLink.channel.heartbeat");

    public ForgeAmqpSendHeartbeatHandler(BChannelConfig channelConfig) {
        this.config = (IForgeChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        log.finer(() -> "Heartbeat message event id " + this.messageHeaders.get(EVENT_ID));
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<SendHeartbeatResult> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Heartbeat message received error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(new ForgeSendHeartbeatResult(false));
            } else {
                log.finer("Heartbeat message sent successfully");
                channelFuture.complete(new ForgeSendHeartbeatResult(true));
            }
        });
        return future;
    }

    public int add(Map<String, Object> properties) {
        properties.forEach((k, v) -> this.jsonSerializer.key(k).value(v));
        return this.stringWriter.getBuffer().length() + 1;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.messageHeaders.put(EVENT_ID, UUID.randomUUID().toString());
        this.jsonSerializer.object();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(ISendHeartbeatHandler.getOperationId());
    }
}

