/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpCommandChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.msg.IRegisterCommandsHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeAmqpRegisterCommandsHandler
extends ForgeAmqpHandler
implements IRegisterCommandsHandler {
    private final BForgeAmqpCommandChannelConfig config;
    public static final String COMMAND = "RegisterCommandsRequest";
    public static final String VERSION = "1";
    private static final String SEPARATOR = "\\.";
    private static final int MSG_END_SIZE = 2;
    private static final Logger log = Logger.getLogger("cloudLink.channel.command");

    public ForgeAmqpRegisterCommandsHandler(BChannelConfig channelConfig) {
        this.config = (BForgeAmqpCommandChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    public int add(String value) {
        String[] parts = value.split(SEPARATOR, 2);
        this.jsonSerializer.object();
        this.jsonSerializer.key("CommandType").value((Object)parts[0]);
        this.jsonSerializer.key("Version").value((Object)parts[1]);
        this.jsonSerializer.endObject();
        return this.stringWriter.getBuffer().length() + 2;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Register commands message got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Register commands message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("SystemGuid");
        this.jsonSerializer.value((Object)this.config.getSystemGuid());
        this.jsonSerializer.key("RegisterCommands");
        this.jsonSerializer.array();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(IRegisterCommandsHandler.getOperationId());
    }
}

