/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeAmqpCommandChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.forge.msg.IForgePointWriteCommandHandler;
import com.tridium.cloudLink.msg.IPointWriteCommandHandler;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;

public class ForgeAmqpPointWriteCommandHandler
extends ForgeAmqpHandler
implements IForgePointWriteCommandHandler {
    private final BForgeAmqpCommandChannelConfig config;
    private String correlationId;
    public static final String COMMAND = "PointWriteResponse";
    public static final String VERSION = "1";
    private static final int MSG_END_SIZE = 1;
    private static final Logger log = Logger.getLogger("cloudLink.channel.command");

    public ForgeAmqpPointWriteCommandHandler(BChannelConfig channelConfig) {
        this.config = (BForgeAmqpCommandChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, this.config);
        this.initializeMessage();
    }

    @Override
    public void addError(int code, String message) {
        this.jsonSerializer.key("Status").value((Object)message);
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int add(Boolean value) {
        this.jsonSerializer.key("WriteTime").value((Object)BAbsTime.now().encodeToString());
        this.jsonSerializer.key("Status").value((Object)(value != false ? "Success" : "Error: Invalid point write"));
        return this.stringWriter.getBuffer().length() + 1;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endObject();
        AmqpMessage msg = (AmqpMessage)super.toMessage(isFinal);
        if (this.correlationId != null) {
            msg.getMessage().setCorrelationId((Object)this.correlationId);
            this.correlationId = null;
        }
        return msg;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Boolean> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Point write command response got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.complete(false);
            } else {
                log.finer("Point write command response message sent successfully");
                channelFuture.complete(true);
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(IPointWriteCommandHandler.getOperationId());
    }
}

