/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import com.tridium.cloudLink.forge.util.ForgeUtils;
import com.tridium.cloudLink.msg.MessageOverflowException;
import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public abstract class ForgeAmqpHandler {
    protected StringWriter stringWriter;
    protected JSONWriter jsonSerializer;
    protected Map<String, Object> messageHeaders;
    private String contentType = "application/json";
    protected String correlationId;
    private static final int COMPRESSION_CUTOFF = 150;
    private static final Logger log = Logger.getLogger("cloudLink.forge.msg");

    public IMessage toMessage(boolean isFinal) {
        BAbstractTransport transport;
        byte[] compressedPayload;
        this.stringWriter.flush();
        String messageId = UUID.randomUUID().toString();
        String payloadString = this.stringWriter.toString();
        byte[] payload = payloadString.getBytes(StandardCharsets.UTF_8);
        String messageContentType = this.contentType;
        if (payload.length > 150 && (compressedPayload = (transport = this.getTransport()).compressData(payload, messageId)).length < payload.length) {
            int payloadSize = payload.length;
            payload = compressedPayload;
            messageContentType = messageContentType + transport.getCompressionExtension();
            log.finer(() -> String.format("Compressed Message is smaller than original payload: messageId=[%s], correlationId=[%s], compressedSize=[%d], originalSize=[%d]", messageId, this.correlationId, compressedPayload.length, payloadSize));
        }
        if (payload.length > 262144) {
            this.initializeMessage();
            throw new MessageOverflowException("Message too large for AMQP transport", (long)payload.length, 262144L);
        }
        this.messageHeaders.put("MessageContentType", messageContentType);
        AmqpMessage msg = new AmqpMessage(payload, this.messageHeaders);
        msg.getMessage().setCorrelationId((Object)this.correlationId);
        msg.getMessage().setMessageId((Object)messageId);
        log.fine(() -> String.format("Created %s message: messageId=[%s] correlationId=[%s]", this.messageHeaders.get("ObjectType"), messageId, this.correlationId));
        log.finest(() -> String.format("Sending message, headers: %spayload [%s]", ForgeUtils.makeHeaderString(this.messageHeaders), payloadString));
        if (!isFinal) {
            this.messageHeaders = new HashMap<String, Object>(this.messageHeaders);
            this.initializeMessage();
        }
        return msg;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected final void finalize() throws Throwable {
    }

    protected void makeMessageHeaders(String command, String version, IForgeChannelConfig config) {
        this.messageHeaders = new HashMap<String, Object>();
        this.messageHeaders.put("ObjectType", command);
        this.messageHeaders.put("ObjectVersion", version);
        this.messageHeaders.put("SystemGuid", config.getSystemGuid());
        this.messageHeaders.put("From", config.getSystemGuid());
    }

    protected void initializeMessage() {
        this.stringWriter = new StringWriter();
        this.jsonSerializer = QuickJSONWriter.make((Appendable)this.stringWriter);
        this.correlationId = UUID.randomUUID().toString();
        this.messageHeaders.put("CorrelationId", this.correlationId);
    }

    protected abstract BAbstractTransport getTransport();
}

