/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BMultiTransportChannelConfig;
import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import com.tridium.cloudLink.forge.msg.ForgeAmqpGetLastTimestampResult;
import com.tridium.cloudLink.forge.msg.ForgeAmqpHandler;
import com.tridium.cloudLink.msg.GetLastTimestampsResult;
import com.tridium.cloudLink.msg.IGetLastTimestampsHandler;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ForgeAmqpGetLastTimestampsHandler
extends ForgeAmqpHandler
implements IGetLastTimestampsHandler {
    private final BMultiTransportChannelConfig config;
    public static final String COMMAND = "IoTPlatformMessage";
    public static final String VERSION = "1";
    public static final String TYPE = "iot.platform.pointhistory.pointslasttimestamp.request";
    private static final int MSG_END_SIZE = 5;
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");

    public ForgeAmqpGetLastTimestampsHandler(BChannelConfig channelConfig) {
        if (!(channelConfig instanceof BMultiTransportChannelConfig) || !(channelConfig instanceof IForgeChannelConfig)) {
            throw new IllegalStateException("The channel config must be a BMultiTransportChannelConfig and implement IForgeChannelConfig.");
        }
        this.config = (BMultiTransportChannelConfig)channelConfig;
        this.makeMessageHeaders(COMMAND, VERSION, (IForgeChannelConfig)this.config);
        this.initializeMessage();
    }

    public int add(Collection<String> historyIds) {
        historyIds.forEach(arg_0 -> ((JSONWriter)this.jsonSerializer).value(arg_0));
        return this.stringWriter.getBuffer().length() + 5;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        this.jsonSerializer.endObject();
        this.jsonSerializer.endArray();
        this.jsonSerializer.endObject();
        return super.toMessage(isFinal);
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<GetLastTimestampsResult> channelFuture, IMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        String correlationId = message.getMetadata().get("CorrelationId").toString();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                log.log(Level.WARNING, "Get last timestamp message got error", log.isLoggable(Level.FINE) ? err : null);
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                log.finer("Get last timestamp message sent successfully");
                ((BAbstractConnectedTransport)this.config.getTransport("getLastTimestamp")).setMessageResponseCallback(correlationId, msg -> {
                    try {
                        log.finer("Get last timestamp response received");
                        ForgeAmqpGetLastTimestampResult result = new ForgeAmqpGetLastTimestampResult(new JSONObject(new String(msg.getPayload(), StandardCharsets.UTF_8)), log);
                        channelFuture.complete(result);
                    }
                    catch (Exception ex) {
                        log.log(Level.INFO, "Error parsing get last timestamp response: " + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
                        channelFuture.completeExceptionally(ex);
                    }
                });
            }
        });
        return future;
    }

    @Override
    protected void initializeMessage() {
        super.initializeMessage();
        this.jsonSerializer.object();
        this.jsonSerializer.key("Messages").array();
        this.jsonSerializer.object();
        this.jsonSerializer.key("MessageType").value((Object)TYPE);
        this.jsonSerializer.key("MessageVersion").value((Object)VERSION);
        this.jsonSerializer.key("Body").object();
        this.jsonSerializer.key("PointIds").array();
    }

    @Override
    protected BAbstractTransport getTransport() {
        return this.config.getTransport(IGetLastTimestampsHandler.getOperationId());
    }
}

