/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.command.CommandEvent;
import com.tridium.cloudLink.forge.channel.BForgeMonoTransportChannelConfig;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.cloudLink.msg.IEventSerializer;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.util.UUID;
import javax.baja.sys.BAbsTime;

public class ForgeAmqpCommandEventSerializer
implements IEventSerializer<CommandEvent> {
    private static final String creatorId = "NiagaraFramework";
    private static final String creatorType = "Niagara4";

    public void serialize(CommandEvent commandEvent, BChannelConfig config, JSONWriter jsonWriter) {
        JSONObject bodyValue;
        BForgeMonoTransportChannelConfig forgeConfig = (BForgeMonoTransportChannelConfig)config;
        jsonWriter.key("Id").value((Object)UUID.randomUUID());
        jsonWriter.key("CreatedTime").value((Object)BAbsTime.now().encodeToString());
        jsonWriter.key("CreatorId").value((Object)creatorId);
        jsonWriter.key("CreatorType").value((Object)creatorType);
        jsonWriter.key("TargetId").value((Object)commandEvent.getCorrelationId());
        jsonWriter.key("TargetType").value((Object)"Device");
        jsonWriter.key("TargetContext").value((Object)"Command");
        jsonWriter.key("Body");
        jsonWriter.object();
        jsonWriter.key("Type").value((Object)"TextualBody");
        if (commandEvent instanceof ForgeCommandDataEvent) {
            bodyValue = ((ForgeCommandDataEvent)commandEvent).getBody();
        } else {
            bodyValue = new JSONObject();
            bodyValue.put("CorrelationId", (Object)commandEvent.getCorrelationId());
            bodyValue.put("ResponseCode", BForgeCommandContainer.getCode(commandEvent.getEventCode()));
            bodyValue.put("ErrorMessage", (Object)BForgeCommandContainer.getMessage(commandEvent.getEventCode()));
        }
        jsonWriter.key("Value").value((Object)bodyValue.toString());
        jsonWriter.key("Format").value((Object)"application/json");
        jsonWriter.endObject();
        jsonWriter.key("BodyProperties").array();
        jsonWriter.object().key("Key").value((Object)"SystemType").key("Value").value((Object)forgeConfig.getSystemType()).endObject();
        jsonWriter.object().key("Key").value((Object)"SystemGuid").key("Value").value((Object)forgeConfig.getSystemGuid()).endObject();
        jsonWriter.endArray();
        jsonWriter.key("EventType").value((Object)"system command update");
    }
}

