/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.msg;

import com.tridium.cloudLink.alarm.AlarmCountEvent;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.forge.channel.BForgeMonoTransportChannelConfig;
import com.tridium.cloudLink.msg.IEventSerializer;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.util.UUID;
import javax.baja.sys.BAbsTime;

public class ForgeAmqpAlarmCountEventSerializer
implements IEventSerializer<AlarmCountEvent> {
    private static final String TARGET_TYPE_VALUE = "AlarmCountEvent";
    private static final String TARGET_CONTEXT_VALUE = "StationAlarmMetadata";

    public void serialize(AlarmCountEvent eventObject, BChannelConfig config, JSONWriter jsonWriter) {
        BForgeMonoTransportChannelConfig forgeConfig = (BForgeMonoTransportChannelConfig)config;
        jsonWriter.key("Id").value((Object)UUID.randomUUID());
        jsonWriter.key("CreatedTime").value((Object)BAbsTime.now().encodeToString());
        jsonWriter.key("CreatorId").value((Object)"NiagaraFramework");
        jsonWriter.key("CreatorType").value((Object)"Niagara4");
        jsonWriter.key("TargetId").value(BAbsTime.now().getMillis());
        jsonWriter.key("TargetType").value((Object)TARGET_TYPE_VALUE);
        jsonWriter.key("TargetContext").value((Object)TARGET_CONTEXT_VALUE);
        jsonWriter.key("Body");
        jsonWriter.object();
        jsonWriter.key("Type").value((Object)"TextualBody");
        JSONObject bodyValue = new JSONObject();
        eventObject.getSources().forEach(sac -> {
            JSONObject counts = new JSONObject();
            sac.getCounts().forEach((i, c) -> counts.put(i, c));
            bodyValue.put(sac.getSourceId(), (Object)counts);
        });
        jsonWriter.key("Value").value((Object)bodyValue.toString());
        jsonWriter.key("Format").value((Object)"application/json");
        jsonWriter.endObject();
        jsonWriter.key("BodyProperties").array();
        jsonWriter.object().key("Key").value((Object)"SystemType").key("Value").value((Object)forgeConfig.getSystemType()).endObject();
        jsonWriter.object().key("Key").value((Object)"SystemGuid").key("Value").value((Object)forgeConfig.getSystemGuid()).endObject();
        jsonWriter.endArray();
        jsonWriter.key("EventType").value((Object)"alarm count");
    }
}

