/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.model;

import com.tridium.json.JSONException;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.util.EscUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;

public final class ModelEncoderPlugin
implements ValueDocEncoder.IEncoderPlugin {
    public static final String PROPERTY_NAME = "p";
    public static final String TYPE_NAME = "t";
    public static final String HANDLE_NAME = "h";
    public static final List<String> UNESCAPED_ATTRS = Arrays.asList("n", "n:name", "n:history");
    private final JSONWriter w;
    private OutputStream out;
    private OutputStreamWriter outw;
    private final EscUtil escUtil = EscUtil.slot;

    public ModelEncoderPlugin(File file) throws IOException {
        this(Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }

    public ModelEncoderPlugin(OutputStream out) throws IOException {
        this.out = new BufferedOutputStream(out);
        this.outw = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        this.w = QuickJSONWriter.make((Appendable)this.outw);
    }

    public ModelEncoderPlugin(JSONWriter writer) throws IOException {
        this.w = writer;
    }

    public ValueDocEncoder.IEncoderPlugin encodeDocStart() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin encodeDocEnd() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin encodeDocument(ValueDocEncoder encoder, BValue value) throws IOException {
        encoder.encode(value);
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin start(String name) throws IOException {
        try {
            if (!PROPERTY_NAME.equals(name)) {
                this.w.object().key("nm").value((Object)name);
            } else {
                this.w.object();
            }
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin startArray(String name) throws IOException {
        try {
            this.w.key(name).array();
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin endArray() throws IOException {
        try {
            this.w.endArray();
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin end() throws IOException {
        try {
            this.w.endObject();
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin end(String name) throws IOException {
        return this.end();
    }

    public ValueDocEncoder.IEncoderPlugin endAttr() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin newLine() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin endProp() throws IOException {
        try {
            this.w.endObject();
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin key(String key) throws IOException {
        try {
            this.w.key(key);
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, boolean val) throws IOException {
        try {
            this.w.key(key).value(val);
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, double val) throws IOException {
        try {
            if (Double.POSITIVE_INFINITY == val) {
                this.w.key(key).value((Object)"Infinity");
            } else if (Double.NEGATIVE_INFINITY == val) {
                this.w.key(key).value((Object)"-Infinity");
            } else if (Double.isNaN(val)) {
                this.w.key(key).value((Object)"NaN");
            } else {
                this.w.key(key).value(val);
            }
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, long val) throws IOException {
        try {
            this.w.key(key).value(val);
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attr(String key, String str) throws IOException {
        if (HANDLE_NAME.equals(key)) {
            return this;
        }
        try {
            if (UNESCAPED_ATTRS.contains(key)) {
                String unescStr = this.escUtil.unescape(str);
                this.w.key(key).value((Object)unescStr);
            } else {
                this.w.key(key).value((Object)str);
            }
        }
        catch (JSONException jsonExcept) {
            throw new ModelEncoderIoException(jsonExcept);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin attrSafe(String key, String str) throws IOException {
        return this.attr(key, str);
    }

    public ValueDocEncoder.IEncoderPlugin value(String str) throws IOException {
        try {
            this.w.value((Object)str);
        }
        catch (JSONException e) {
            throw new ModelEncoderIoException(e);
        }
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin comment(String text) throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin incrementIndent() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin decrementIndent() throws IOException {
        return this;
    }

    public ValueDocEncoder.IEncoderPlugin indent() throws IOException {
        return this;
    }

    public int getIndent() {
        return -1;
    }

    public ValueDocEncoder.IEncoderPlugin encodeType(Type type) throws IOException {
        return this.attr(TYPE_NAME, type.toString());
    }

    public void flush() throws IOException {
        if (this.outw != null) {
            this.outw.flush();
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        try (OutputStream closingOut = this.out;
             OutputStreamWriter closingOutw = this.outw;){
            this.flush();
            this.outw = null;
            this.out = null;
        }
    }

    public boolean isZipped() {
        return false;
    }

    public void setZipped(boolean zipped) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static class ModelEncoderIoException
    extends IOException {
        private static final long serialVersionUID = 3909741189989770548L;

        private ModelEncoderIoException(JSONException cause) {
            super(cause.getMessage());
            this.initCause(cause);
        }
    }
}

