/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BWriteTagCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeWriteMultiTagSystemCommand
extends BWriteTagCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeWriteMultiTagSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudMultiTagWriteCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        JSONArray tags = payload.getJSONArray("TagWrites");
        JSONArray results = new JSONArray();
        boolean success = false;
        for (int lcv = 0; lcv < tags.length(); ++lcv) {
            JSONObject tag = tags.getJSONObject(lcv);
            String pointId = JSONUtil.getString((JSONObject)tag, (String)"PointId");
            String namespace = JSONUtil.getString((JSONObject)tag, (String)"Namespace");
            String tagName = JSONUtil.getString((JSONObject)tag, (String)"TagName");
            Object value = tag.opt("Value");
            Object tagValue = value == null ? BMarker.DEFAULT : (value instanceof String ? BString.make((String)((String)value)) : (value instanceof Boolean ? BBoolean.make((boolean)((Boolean)value)) : (value instanceof BigDecimal ? BDouble.make((double)((BigDecimal)value).doubleValue()) : (value instanceof Double ? BDouble.make((double)((Double)value)) : (value instanceof Long ? BLong.make((long)((Long)value)) : (value instanceof Integer ? BInteger.make((int)((Integer)value)) : BString.make((String)value.toString())))))));
            boolean result = this.writeTag(messageId, pointId, namespace, tagName, (BIDataValue)tagValue, cx);
            JSONObject pointData = new JSONObject();
            pointData.put("PointId", (Object)pointId);
            pointData.put("Namespace", (Object)namespace);
            pointData.put("TagName", (Object)tagName);
            pointData.put("Status", (Object)(result ? "Success" : "Error: Invalid tag write"));
            results.put((Object)pointData);
            success |= result;
        }
        JSONObject body = new JSONObject();
        body.put("TagWriteDetails", (Object)results);
        if (success) {
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

