/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BWriteRelationCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeWriteMultiRelationSystemCommand
extends BWriteRelationCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeWriteMultiRelationSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudMultiRelationWriteCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        JSONArray tags = payload.getJSONArray("RelationWrites");
        JSONArray results = new JSONArray();
        boolean success = false;
        for (int lcv = 0; lcv < tags.length(); ++lcv) {
            JSONObject tag = tags.getJSONObject(lcv);
            String sourceId = JSONUtil.getString((JSONObject)tag, (String)"SourceId");
            String targetId = JSONUtil.getString((JSONObject)tag, (String)"TargetId");
            String namespace = JSONUtil.getString((JSONObject)tag, (String)"Namespace");
            String relationName = JSONUtil.getString((JSONObject)tag, (String)"RelationName");
            boolean result = this.writeRelation(messageId, sourceId, targetId, namespace, relationName, cx);
            JSONObject pointData = new JSONObject();
            pointData.put("SourceId", (Object)sourceId);
            pointData.put("TargetId", (Object)targetId);
            pointData.put("Namespace", (Object)namespace);
            pointData.put("RelationName", (Object)relationName);
            pointData.put("Status", (Object)(result ? "Success" : "Error: Invalid relation write"));
            results.put((Object)pointData);
            success |= result;
        }
        JSONObject body = new JSONObject();
        body.put("RelationWriteDetails", (Object)results);
        if (success) {
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

