/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BWriteAlarmCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.cloudLink.msg.WriteAlarmResult;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeWriteMultiAlarmSystemCommand
extends BWriteAlarmCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeWriteMultiAlarmSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudMultiAlarmWriteCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject body = new JSONObject();
        JSONObject alarmDatasResponse = null;
        try {
            JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
            Iterator alarmWritesRequest = payload.getJSONArray("AlarmWrites").iterator();
            String callingIdentity = JSONUtil.getString((JSONObject)data, (String)"CallingIdentity");
            String appName = JSONUtil.getString((JSONObject)payload, (String)"WritingApplicationName");
            this.openSession(cx);
            JSONObject alarmWritesResponse = new JSONObject();
            while (alarmWritesRequest.hasNext()) {
                JSONObject alarmWriteRequest = (JSONObject)alarmWritesRequest.next();
                String alarmId = alarmWriteRequest.optString("AlarmId", "");
                JSONObject alarmDatasRequest = alarmWriteRequest.optJSONObject("AlarmData", new JSONObject());
                JSONObject alarmWriteResponse = new JSONObject();
                try {
                    Map alarmDataResults = this.writeAlarmData(messageId, alarmId, callingIdentity, appName, alarmDatasRequest, cx);
                    alarmDatasResponse = new JSONObject();
                    for (Map.Entry entry : alarmDataResults.entrySet()) {
                        WriteAlarmResult alarmDataResult = (WriteAlarmResult)entry.getValue();
                        JSONObject alarmDataResponse = new JSONObject();
                        alarmDataResponse.put("IsSuccessful", alarmDataResult.getStatus());
                        alarmDataResponse.put("Message", (Object)alarmDataResult.getMessage());
                        alarmDatasResponse.put((String)entry.getKey(), (Object)alarmDataResponse);
                    }
                    alarmWriteResponse.put("IsSuccessful", true);
                    alarmWriteResponse.put("Message", (Object)"Success");
                }
                catch (BWriteAlarmCommand.AlarmWriteException alarmWriteExcept) {
                    alarmWriteResponse.put("IsSuccessful", false);
                    alarmWriteResponse.put("Message", (Object)alarmWriteExcept.getMessage());
                    alarmDatasResponse = null;
                }
                alarmWriteResponse.put("AlarmData", (Object)alarmDatasResponse);
                alarmWritesResponse.put(alarmId, (Object)alarmWriteResponse);
            }
            body.put("AlarmWrites", (Object)alarmWritesResponse);
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        }
        catch (JSONException jsonExcept) {
            body.put("AlarmWrites", (Object)new JSONArray());
            body.put("ResponseCode", 400);
            body.put("ErrorMessage", (Object)"Error: Bad Request");
            code = 400;
        }
        catch (IllegalStateException except) {
            body.put("AlarmWrites", (Object)new JSONArray());
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        finally {
            this.closeSession();
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

