/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BReadPointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeReadPointSystemCommand
extends BReadPointCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeReadPointSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudPointReadCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        String pointId = JSONUtil.getString((JSONObject)payload, (String)"PointId");
        BReadPointCommand.StatusWrapper result = this.readPoint(messageId, pointId, cx);
        JSONObject body = new JSONObject();
        if (result != null) {
            BasicContext conversionContext = new BasicContext(cx, BFacets.make((String)"precision", (BIDataValue)result.getPrecision()));
            JSONObject pointData = new JSONObject();
            pointData.put("Status", (Object)result.getValue().getStatus().toString());
            pointData.put("Value", (Object)result.getValue().getValueValue().toString((Context)conversionContext));
            body.put(pointId, (Object)pointData);
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

