/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BReadPointInputPropertiesCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.cloudLink.msg.PointInputResult;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeReadMultiPointInputPropertiesSystemCommand
extends BReadPointInputPropertiesCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeReadMultiPointInputPropertiesSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "CloudMultiPointReadInputPropertiesCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject body = new JSONObject();
        JSONObject pointData = new JSONObject();
        try {
            JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
            Iterator pointIdsItr = payload.getJSONArray("PointIds").iterator();
            boolean success = false;
            while (pointIdsItr.hasNext()) {
                String pointId = (String)pointIdsItr.next();
                TreeMap inputProperties = this.getInputProperties(messageId, pointId, cx);
                pointData.put(pointId, (Object)this.getInputs(inputProperties));
                if (inputProperties == null) continue;
                success = true;
            }
            body.put("PointInputs", (Object)pointData);
            if (success) {
                body.put("ResponseCode", 200);
                body.put("ErrorMessage", (Object)"Status: OK");
                code = 200;
            } else {
                body.put("ResponseCode", 403);
                body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
                code = 403;
            }
        }
        catch (JSONException e) {
            body.put("PointInputs", (Object)pointData);
            body.put("ResponseCode", 400);
            body.put("ErrorMessage", (Object)"Error: Bad Request");
            code = 400;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }

    public JSONArray getInputs(TreeMap<BPriorityLevel, PointInputResult> inputProperties) {
        if (inputProperties == null) {
            return new JSONArray().put((Object)new JSONObject().put("Status", (Object)"Error: Access Not Allowed"));
        }
        List inputsList = inputProperties.entrySet().stream().map(e -> {
            JSONObject input = new JSONObject();
            BStatusValue statusValue = ((PointInputResult)e.getValue()).getStatusValue();
            input.put("Priority", (Object)((BPriorityLevel)e.getKey()).toString());
            input.put("Status", (Object)statusValue.getStatus().toString());
            input.put("Value", (Object)statusValue.getValueValue().toString());
            BAbsTime expiration = ((PointInputResult)e.getValue()).getExpiration();
            input.put("Expiration", (Object)(expiration == BAbsTime.NULL ? "" : expiration.encodeToString()));
            input.put("Source", (Object)((PointInputResult)e.getValue()).getSource());
            return input;
        }).collect(Collectors.toList());
        return new JSONArray(inputsList);
    }
}

