/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.ICloudLinkMessageHandler;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BCommandsChannel;
import com.tridium.cloudLink.command.BReadPointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.msg.IForgeMultiPointReadCommandHandler;
import com.tridium.cloudLink.msg.IPointReadCommandHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeReadMultiPointCommand
extends BReadPointCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeReadMultiPointCommand.class);
    public static final String COMMAND = "MultiPointReadCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "MultiPointReadCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public ICloudLinkMessageHandler<Boolean> getErrorResponse(BAbstractCloudLinkHandlerFactory msgFactory, BChannelConfig channelConfig, String commandId, int code, String message) {
        IForgeMultiPointReadCommandHandler handler = (IForgeMultiPointReadCommandHandler)msgFactory.getMessageHandler(IForgeMultiPointReadCommandHandler.class, channelConfig);
        handler.addError(code, message);
        handler.setCorrelationId(commandId);
        return handler;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        JSONArray pointIds = data.getJSONArray("PointIds");
        BCommandsChannel channel = this.getChannel();
        if (channel == null) {
            future.completeExceptionally(new IOException("no channel"));
            return future;
        }
        BChannelConfig config = channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IPointReadCommandHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("unable to send command response transport down " + messageId);
            future.completeExceptionally(new IOException("transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IForgeMultiPointReadCommandHandler handler = (IForgeMultiPointReadCommandHandler)msgFactory.getMessageHandler(IForgeMultiPointReadCommandHandler.class, config);
        handler.setCorrelationId(messageId);
        for (int lcv = 0; lcv < pointIds.length(); ++lcv) {
            String pointId = JSONUtil.getString((JSONArray)pointIds, (int)lcv);
            BReadPointCommand.StatusWrapper result = this.readPoint(messageId, pointId, cx);
            if (result == null) {
                handler.addError(pointId, 403, "Error: Access Not Allowed");
                continue;
            }
            handler.add(pointId, result);
        }
        MessageWrapper wrapper = new MessageWrapper(handler.toMessage(), handler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(IPointReadCommandHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }
}

