/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.command.BListPointsCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeListPointsSystemCommand
extends BListPointsCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeListPointsSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "RetrieveCloudPointsCommand";
    public static final String VERSION = "1";
    private static final int BATCH_SIZE = 1024;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        List points = this.listPoints(messageId, cx);
        ArrayWrapper pointArray = new ArrayWrapper();
        int pointCount = 0;
        int msgTotal = points.size() / 1024 + (points.size() % 1024 == 0 ? 0 : 1);
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        for (BControlPoint point : points) {
            if (pointCount > 0 && pointCount % 1024 == 0) {
                this.sendSegment(messageId, pointArray, pointCount / 1024 - 1, msgTotal, container);
            }
            TagUtil.getCloudIdString((BIObject)point).ifPresent(id -> pointArray.put((String)id));
            ++pointCount;
        }
        if (pointCount == 0) {
            JSONObject body = new JSONObject();
            body.put("sequenceNum", 0);
            body.put("SegmentTotal", 1);
            body.put("Points", (Object)pointArray.getArray());
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            return container.sendDataEvent(new ForgeCommandDataEvent(messageId, 403, body));
        }
        return this.sendSegment(messageId, pointArray, msgTotal - 1, msgTotal, container);
    }

    private CompletableFuture<Boolean> sendSegment(String messageId, ArrayWrapper pointArray, int seqNum, int msgTotal, BForgeCommandContainer container) {
        JSONObject body = new JSONObject();
        body.put("sequenceNum", seqNum);
        body.put("SegmentTotal", msgTotal);
        body.put("Points", (Object)pointArray.getArray());
        body.put("ResponseCode", 200);
        body.put("ErrorMessage", (Object)"Status: OK");
        pointArray.clear();
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, 200, body));
    }

    private static class ArrayWrapper {
        private JSONArray array = new JSONArray();

        public void put(String value) {
            this.array.put((Object)value);
        }

        public JSONArray getArray() {
            return this.array;
        }

        public void clear() {
            this.array = new JSONArray();
        }
    }
}

