/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BCommand;
import com.tridium.cloudLink.command.BListCommandsCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeListCommandsSystemCommand
extends BListCommandsCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeListCommandsSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "ListCloudCommandsCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        BCommand[] commands = this.listCommands(messageId, cx);
        JSONArray results = new JSONArray();
        for (BCommand command : commands) {
            if (!(command instanceof BIForgeCommand)) continue;
            BIForgeCommand forgeCommand = (BIForgeCommand)command;
            JSONObject commandInfo = new JSONObject();
            String[] parts = forgeCommand.getRoute().split("\\.", 2);
            commandInfo.put("CommandType", (Object)parts[0]);
            commandInfo.put("Version", (Object)parts[1]);
            commandInfo.put("CommandName", (Object)forgeCommand.getCommandName());
            commandInfo.put("Enabled", command.getEnabled());
            results.put((Object)commandInfo);
        }
        JSONObject body = new JSONObject();
        body.put("Command", (Object)results);
        body.put("ResponseCode", 200);
        body.put("ErrorMessage", (Object)"Status: OK");
        int code = 200;
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

