/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BInvokeActionCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeInvokeActionSystemCommand
extends BInvokeActionCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeInvokeActionSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "InvokeCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        BControlPoint point;
        JSONObject payload = new JSONObject(JSONUtil.getString((JSONObject)data.getJSONObject("CommandParameters"), (String)"CommandPayload"));
        BOrd ord = payload.has("PointId") ? ((point = CloudLinkUtils.findPoint((String)messageId, (String)JSONUtil.getString((JSONObject)payload, (String)"PointId"))) != null ? point.getHandleOrd() : BOrd.NULL) : BOrd.make((String)JSONUtil.getString((JSONObject)payload, (String)"ComponentOrd"));
        String actionName = JSONUtil.getString((JSONObject)payload, (String)"Action");
        BValue argument = null;
        int code = 200;
        JSONObject body = new JSONObject();
        if (payload.has("Argument")) {
            try {
                argument = BsonDecoderPlugin.unmarshal((JSONObject)payload.getJSONObject("Argument"), null);
            }
            catch (Exception e) {
                log.warning(String.format("Failed to decode argument: %s %s", e.getMessage(), messageId));
                code = 400;
                body.put("ResponseCode", 400);
                body.put("ErrorMessage", (Object)"Error: Bad Request");
            }
        }
        if (code == 200) {
            try {
                BValue result = this.invokeAction(messageId, ord, actionName, argument, cx);
                if (result != null) {
                    body.put("ReturnValue", (Object)new JSONObject(BsonEncoderPlugin.marshal((BValue)result)));
                }
                body.put("ResponseCode", 200);
                body.put("ErrorMessage", (Object)"Status: OK");
            }
            catch (UnresolvedException uEx) {
                log.warning(String.format("Unable to resolve ord: %s: %s %s", ord, uEx.getMessage(), messageId));
                body.put("ResponseCode", 400);
                body.put("ErrorMessage", (Object)"Error: Bad Request");
                code = 400;
            }
            catch (ClassCastException ccEx) {
                log.warning(String.format("The provided ord does not resolve to a BComponent: %s %s", ord.toString(), messageId));
                body.put("ResponseCode", 400);
                body.put("ErrorMessage", (Object)"Error: Bad Request");
                code = 400;
            }
            catch (BInvokeActionCommand.ActionNotFoundException anfEx) {
                log.warning(String.format("Invalid action for resolved component: %s %s", anfEx.getMessage(), messageId));
                body.put("ResponseCode", 400);
                body.put("ErrorMessage", (Object)"Error: Bad Request");
                code = 400;
            }
            catch (PermissionException pEx) {
                log.warning(String.format("Insufficient permissions to invoke action: %s %s", pEx.getMessage(), messageId));
                body.put("ResponseCode", 403);
                body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
                code = 403;
            }
            catch (Exception ex) {
                log.warning(String.format("Failed to invoke action: %s, %s", ex.getMessage(), messageId));
                body.put("ResponseCode", 400);
                body.put("ErrorMessage", (Object)"Error: Bad Request");
                code = 400;
            }
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

