/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BAckAlarmCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.cloudLink.msg.AckAlarmResult;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeAckAlarmSystemCommand
extends BAckAlarmCommand
implements BIForgeCommand {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeAckAlarmSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String COMMAND_NAME = "AlarmAckCommand";
    public static final String VERSION = "1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        JSONObject payload = new JSONObject(data.getJSONObject("CommandParameters").getString("CommandPayload"));
        String alarmId = JSONUtil.getString((JSONObject)payload, (String)"AlarmId");
        String callingIdentity = JSONUtil.getString((JSONObject)data, (String)"CallingIdentity");
        String appName = JSONUtil.getString((JSONObject)payload, (String)"AcknowledgingApplicationName");
        AckAlarmResult value = this.acknowledgeAlarm(messageId, alarmId, callingIdentity, appName, cx);
        JSONObject body = new JSONObject();
        JSONObject alarmData = new JSONObject();
        alarmData.put("IsSuccessful", (Object)value.getStatus());
        alarmData.put("Message", (Object)value.getMessage());
        body.put(alarmId, (Object)alarmData);
        if (value.getStatus().booleanValue()) {
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        } else {
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }
}

