/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.channel;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.channel.BMessageChannelConfig;
import com.tridium.cloudLink.channel.BTransportConfig;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeMessageChannelConfig
extends BMessageChannelConfig {
    @Generated
    public static final Type TYPE = Sys.loadType(BForgeMessageChannelConfig.class);
    private static final String CHANNEL_CONFIG_STRING = "Messaging Channel Config: AMQP/HTTP";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getAuthenticatorId().isEmpty()) {
            this.getChannel().flatMap(c -> c.getConnectionService()).ifPresent(ccs -> {
                List authenticators = ccs.getAuthenticators().getAuthenticators();
                if (!authenticators.isEmpty()) {
                    this.setAuthenticatorId(((BAbstractClientAuthenticator)authenticators.get(0)).getAuthenticatorId());
                }
            });
        }
        super.started();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.doConfigureTransports();
    }

    public void doConfigureTransports() {
        super.doConfigureTransports();
        BTransportConfig amqpTransportConfig = (BTransportConfig)this.get("AMQP");
        if (amqpTransportConfig != null) {
            BFacets maxMsgSizeFacets = amqpTransportConfig.getSlotFacets((Slot)BTransportConfig.maxMessageSize);
            amqpTransportConfig.setFacets((Slot)BTransportConfig.maxMessageSize, BFacets.make((BFacets)maxMsgSizeFacets, (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)2000000))));
        } else {
            log.config("Unable to locate AMQP transport to set max message size limit");
        }
    }

    public String getPlatformType() {
        return "Forge";
    }

    public String toString(Context cx) {
        return CHANNEL_CONFIG_STRING;
    }
}

