/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.forge.auth.ConnectionInfo;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.security.BPassword;

public class ForgeSystemConnectionsResponse {
    protected static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private final int statusCode;
    private Map<String, ConnectionInfo> connectionsMap;
    private static final String BOOTSTRAP_ERROR_MSG_TEMPLATE = "Forge connections info response body is not in %s format, response body is %s";
    private static final String END_POINT = "Path";
    private static final String KEY = "ServerType";
    private static final String USER = "UserName";
    private static final String TOKEN = "Password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeSystemConnectionsResponse(HttpResponseMessage message) {
        try {
            this.statusCode = message.getStatusCode();
            List headers = (List)message.getHeaders().get("content-type");
            if (headers == null || !headers.contains("application/json; charset=utf-8")) {
                log.config(() -> String.format(BOOTSTRAP_ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
                return;
            }
            JSONArray connectionsJson = new JSONArray(message.getBodyAsString());
            this.connectionsMap = new HashMap<String, ConnectionInfo>(connectionsJson.length());
            for (int lcv = 0; lcv < connectionsJson.length(); ++lcv) {
                JSONObject info = connectionsJson.getJSONObject(lcv);
                if (!info.has(KEY) || !info.has(USER) || !info.has(TOKEN) || !info.has(END_POINT)) continue;
                this.connectionsMap.put(info.getString(KEY), new ConnectionInfo(info.getString(USER), BPassword.make((String)info.getString(TOKEN)), info.getString(END_POINT)));
            }
            log.finest(() -> String.format("Forge connections info response status = %d, connection info count = %d", this.statusCode, this.connectionsMap.size()));
        }
        finally {
            if (message != null) {
                try {
                    message.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.connectionsMap != null && !this.connectionsMap.isEmpty();
    }

    public Map<String, ConnectionInfo> getConectionsMap() {
        return this.connectionsMap;
    }
}

