/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class ForgeSystemConnectionsRequest
implements IMessageBuilder {
    private final String registrationHost;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String API_PATH = "/api/v2/systems/connections";

    public ForgeSystemConnectionsRequest(String server, BCertificateAliasAndPassword certAliasAndPass) {
        this.registrationHost = server;
        this.certAliasAndPass = certAliasAndPass;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        try {
            url = new URL("https://" + this.registrationHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Forge connection info request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Forge connection info request with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").certificateAliasAndPassword(this.certAliasAndPass).build();
    }
}

