/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class ForgeRegistrationResponse {
    private final int statusCode;
    private String resultMessage;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String STATUS = "status";
    private static final String ERROR_MESSAGE = "errorMsg";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeRegistrationResponse(HttpResponseMessage message) {
        try {
            this.statusCode = message.getStatusCode();
            List headers = (List)message.getHeaders().get("content-type");
            if (headers == null || !headers.contains("application/json")) {
                log.info("registration response, expected JSON" + (headers == null || headers.isEmpty() ? "" : " but got " + (String)headers.get(0)));
                return;
            }
            JSONObject data = new JSONObject(message.getBodyAsString());
            Object tmp = data.opt(STATUS);
            this.resultMessage = tmp == null || tmp == JSONObject.NULL ? data.optString(ERROR_MESSAGE, null) : tmp.toString();
        }
        finally {
            if (message != null) {
                try {
                    message.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 || this.statusCode == 202;
    }

    public String getMessage() {
        return this.resultMessage;
    }
}

