/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeCsrRenewalResponse {
    private final int statusCode;
    private X509Certificate deviceCert;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String CERT_WRAPPER = "-----BEGIN PKCS7-----\n%s\n-----END PKCS7-----";
    private static final String ERROR_MSG_TEMPLATE = "Forge renewal CSR response body is not in %s format, response body is %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeCsrRenewalResponse(HttpResponseMessage message) {
        try {
            this.statusCode = message.getStatusCode();
            List headers = (List)message.getHeaders().get("content-type");
            if (headers == null || !headers.contains("application/pkcs7-mime")) {
                log.config(() -> String.format(ERROR_MSG_TEMPLATE, "application/pkcs7-mime", message.getBodyAsString()));
                return;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(String.format(CERT_WRAPPER, message.getBodyAsString()).getBytes(StandardCharsets.UTF_8));
                this.deviceCert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                log.finest(() -> String.format("Forge renewal CSR response status = %d, Device cert = %s", this.statusCode, this.deviceCert));
            }
            catch (Exception ex) {
                log.log(Level.INFO, "Error processing Forge renewal CSR response", log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        finally {
            if (message != null) {
                try {
                    message.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.deviceCert != null;
    }

    public X509Certificate getDeviceCert() {
        return this.deviceCert;
    }
}

