/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.forge.auth.BDevTestComponent;
import com.tridium.cloudLink.forge.auth.BSystemAuthenticationState;
import com.tridium.cloudLink.forge.auth.BSystemRegistrationState;
import com.tridium.cloudLink.provisioning.BCloudLinkProvisioning;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.util.CompUtil;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="registrationState", type="BSystemRegistrationState", defaultValue="BSystemRegistrationState.DEFAULT", flags=257), @NiagaraProperty(name="authenticationState", type="BSystemAuthenticationState", defaultValue="BSystemAuthenticationState.DEFAULT", flags=259), @NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_FEDERATED)", flags=1, override=true), @NiagaraProperty(name="userCode", type="String", defaultValue="", flags=3), @NiagaraProperty(name="deviceCode", type="String", defaultValue="", flags=7), @NiagaraProperty(name="userRegistrationUrl", type="BOrd", defaultValue="BOrd.NULL", flags=3), @NiagaraProperty(name="codeExpiration", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="registrationHost", type="BString", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="deviceUuidDelay", type="BRelTime", defaultValue="BRelTime.make(10000)", flags=5), @NiagaraProperty(name="hostId", type="BString", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="provisioning", type="BCloudLinkProvisioning", defaultValue="BCloudLinkProvisioning.DEFAULT", flags=5), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="statusMessage", type="String", defaultValue="", flags=259)})
@NiagaraActions(value={@NiagaraAction(name="startRegistration", flags=257), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
@NiagaraTopic(name="certificateUpdate", eventType="BString", flags=4)
public class BFederatedIdentityAuthenticator
extends BAbstractClientAuthenticator
implements BIAlarmSource {
    @Generated
    public static final Property registrationState = BFederatedIdentityAuthenticator.newProperty((int)257, (BValue)BSystemRegistrationState.DEFAULT, null);
    @Generated
    public static final Property authenticationState = BFederatedIdentityAuthenticator.newProperty((int)259, (BValue)BSystemAuthenticationState.DEFAULT, null);
    @Generated
    public static final Property authenticatorId = BFederatedIdentityAuthenticator.newProperty((int)1, (BValue)BString.make((String)"FederatedIdentity"), null);
    @Generated
    public static final Property userCode = BFederatedIdentityAuthenticator.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property deviceCode = BFederatedIdentityAuthenticator.newProperty((int)7, (String)"", null);
    @Generated
    public static final Property userRegistrationUrl = BFederatedIdentityAuthenticator.newProperty((int)3, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property codeExpiration = BFederatedIdentityAuthenticator.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property registrationHost = BFederatedIdentityAuthenticator.newProperty((int)5, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property deviceUuidDelay = BFederatedIdentityAuthenticator.newProperty((int)5, (BValue)BRelTime.make((long)10000L), null);
    @Generated
    public static final Property hostId = BFederatedIdentityAuthenticator.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property provisioning = BFederatedIdentityAuthenticator.newProperty((int)5, (BValue)BCloudLinkProvisioning.DEFAULT, null);
    @Generated
    public static final Property alarmSourceInfo = BFederatedIdentityAuthenticator.newProperty((int)0, (BValue)BFederatedIdentityAuthenticator.initAlarmSourceInfo(), null);
    @Generated
    public static final Property statusMessage = BFederatedIdentityAuthenticator.newProperty((int)259, (String)"", null);
    @Generated
    public static final Action startRegistration = BFederatedIdentityAuthenticator.newAction((int)257, null);
    @Generated
    public static final Action ackAlarm = BFederatedIdentityAuthenticator.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Topic certificateUpdate = BFederatedIdentityAuthenticator.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFederatedIdentityAuthenticator.class);
    private ScheduledExecutorService executor;
    private AlarmSupport alarmSupport;
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final Lexicon lex = Lexicon.make(BFederatedIdentityAuthenticator.class);
    private static final String DEV_CONFIGURER_NAME = "DevConfigurer";

    @Generated
    public BSystemRegistrationState getRegistrationState() {
        return (BSystemRegistrationState)this.get(registrationState);
    }

    @Generated
    public void setRegistrationState(BSystemRegistrationState v) {
        this.set(registrationState, (BValue)v, null);
    }

    @Generated
    public BSystemAuthenticationState getAuthenticationState() {
        return (BSystemAuthenticationState)this.get(authenticationState);
    }

    @Generated
    public void setAuthenticationState(BSystemAuthenticationState v) {
        this.set(authenticationState, (BValue)v, null);
    }

    @Generated
    public String getUserCode() {
        return this.getString(userCode);
    }

    @Generated
    public void setUserCode(String v) {
        this.setString(userCode, v, null);
    }

    @Generated
    public String getDeviceCode() {
        return this.getString(deviceCode);
    }

    @Generated
    public void setDeviceCode(String v) {
        this.setString(deviceCode, v, null);
    }

    @Generated
    public BOrd getUserRegistrationUrl() {
        return (BOrd)this.get(userRegistrationUrl);
    }

    @Generated
    public void setUserRegistrationUrl(BOrd v) {
        this.set(userRegistrationUrl, (BValue)v, null);
    }

    @Generated
    public BAbsTime getCodeExpiration() {
        return (BAbsTime)this.get(codeExpiration);
    }

    @Generated
    public void setCodeExpiration(BAbsTime v) {
        this.set(codeExpiration, (BValue)v, null);
    }

    @Generated
    public String getRegistrationHost() {
        return this.getString(registrationHost);
    }

    @Generated
    public void setRegistrationHost(String v) {
        this.setString(registrationHost, v, null);
    }

    @Generated
    public BRelTime getDeviceUuidDelay() {
        return (BRelTime)this.get(deviceUuidDelay);
    }

    @Generated
    public void setDeviceUuidDelay(BRelTime v) {
        this.set(deviceUuidDelay, (BValue)v, null);
    }

    @Generated
    public String getHostId() {
        return this.getString(hostId);
    }

    @Generated
    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    @Generated
    public BCloudLinkProvisioning getProvisioning() {
        return (BCloudLinkProvisioning)this.get(provisioning);
    }

    @Generated
    public void setProvisioning(BCloudLinkProvisioning v) {
        this.set(provisioning, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    @Generated
    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    @Generated
    public void startRegistration() {
        this.invoke(startRegistration, null, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public void fireCertificateUpdate(BString event) {
        this.fire(certificateUpdate, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        if (this.getConnectionService().map(c -> c.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        super.serviceStarted();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.executor = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"federatedIdentityAuth", (long)2L, (TimeUnit)TimeUnit.MINUTES);
    }

    public void started() throws Exception {
        super.started();
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            log.info("Forge Federated Identity Authenticator scheduling migration");
            this.migrateToCloudLink();
        }));
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.alarmSupport = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
        if (!this.isOperational()) {
            log.info("Cannot supply certificate to message handler because authenticator is disabled");
            return;
        }
    }

    public Map<String, Object> getPlatformProperties() {
        return new HashMap<String, Object>();
    }

    void migrateToCloudLink() {
        this.executor.schedule(() -> {
            log.info("Migrating Federated Identity Authenticator to the proper module...");
            try {
                com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator newFedIdAuth = new com.tridium.cloudLink.auth.BFederatedIdentityAuthenticator();
                newFedIdAuth.setEnabled(this.getEnabled());
                newFedIdAuth.setSystemId(this.getSystemId());
                newFedIdAuth.setRegistrationState(this.getRegistrationState().toFedIdRegistrationState());
                newFedIdAuth.setAuthenticatorId(this.getAuthenticatorId());
                newFedIdAuth.setUserRegistrationUrl(this.getUserRegistrationUrl());
                newFedIdAuth.setRegistrationHost(this.getRegistrationHost());
                newFedIdAuth.setDeviceUuidDelay(this.getDeviceUuidDelay());
                newFedIdAuth.setHostId(this.getHostId());
                newFedIdAuth.add("migratedFrom", (BValue)this.getOrdInSession(), 5, BFacets.DEFAULT, null);
                this.setEnabled(false);
                BDevTestComponent[] dtcs = (BDevTestComponent[])this.getChildren(BDevTestComponent.class);
                if (dtcs.length != 0) {
                    BDevTestComponent dtc0 = dtcs[0];
                    Property p = dtc0.getPropertyInParent();
                    try {
                        BTypeSpec tsDevCfg = BTypeSpec.make((String)"cloudLinkInternal:AuthDevConfigurer");
                        BValue devCfg = tsDevCfg.getResolvedType().getInstance().asValue();
                        this.getConnectionService().ifPresent(svc -> CompUtil.setOrAdd((BComponent)svc.getAuthenticators(), (String)DEV_CONFIGURER_NAME, (BValue)devCfg, (int)this.getFlags((Slot)p), (BFacets)this.getSlotFacets((Slot)p), null));
                    }
                    catch (ClassCastException | IllegalArgumentException | ModuleException | TypeException except) {
                        log.log(Level.FINEST, "The necessary internal modules are not loaded to apply the dev configurer to the migrated federated identity authenticator", log.isLoggable(Level.FINEST) ? except : null);
                    }
                }
                this.getParent().asComponent().add(this.getName() + '?', (BValue)newFedIdAuth);
            }
            catch (Exception except) {
                log.log(Level.WARNING, "Unable to create migration target FederatedIdentityAuthenticator: " + except, log.isLoggable(Level.FINE) ? except : null);
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    public boolean canAuthenticate() {
        return this.isOperational() && this.getCertAlias() != null;
    }

    public boolean isRegistered() {
        return this.getRegistrationState().isRegistered();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        log.info("This authenticator can no longer supply connection information and must be migrated");
        return Collections.emptyMap();
    }

    public BBoolean doAckAlarm(BAlarmRecord alarmRecord) {
        try {
            boolean ack = this.alarmSupport.ackAlarm(alarmRecord);
            if (ack) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
            return BBoolean.make((boolean)ack);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot process alarm ack:" + ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
            return BBoolean.FALSE;
        }
    }

    public void doStartRegistration() {
        log.config("This authenticator can no longer register and must be migrated");
    }

    protected void checkRegistered() {
        log.config("Skipping registered check, this authenticator must be migrated");
    }

    protected void makeBootstrapCSR() {
        log.config("Cannot make bootstrap CSR, this authenticator must be migrated");
    }

    protected CompletableFuture<IMessageResponse> makeRollingCsr() {
        log.config("Cannot make rolling CSR, this authenticator must be migrated");
        return null;
    }

    protected CompletableFuture<IMessageResponse> makeBootstrapRenewalCsr() {
        log.config("Cannot make bootstrap renewal CSR, this authenticator must be migrated");
        return null;
    }

    protected void deviceProvisioning() {
        log.config("Cannot perform device provisioning, authenticator must be migrated");
    }

    protected void iotHubRegistration() {
        log.config("Cannot perform iothub registration, authenticator must be migrated");
    }

    protected void iotHubRegistrationStatus() {
        log.config("Cannot check iothub registration status, authenticator must be migrated");
    }

    protected IX509CertificateEntry makeX509Certificate(KeyPair keyPair, String alias, int months) throws Exception {
        String dn = String.format("CN=%s", this.getSystemId());
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(2, months);
        Date notAfter = cal.getTime();
        NCertificateParameters parameters = new NCertificateParameters(alias, dn, dn, notBefore, notAfter, 0, KeyPurpose.CLIENT_CERT, null, null, null);
        IX509CertificateEntry cert = CertUtils.generateSelfSignedCert((KeyPair)keyPair, (NCertificateParameters)parameters);
        return cert;
    }

    protected String getInitError(Throwable err) {
        return lex.get("fdi.generalError");
    }

    protected String getCertAlias() {
        try {
            IKeyStore userKeyStore = CertManagerFactory.getInstance().getKeyStore();
            String alias = this.getRollingKeyStorePrefix() + this.getSystemId();
            X509Certificate cert = userKeyStore.getCertificate(alias);
            if (cert != null && cert.getNotAfter().after(Date.from(Instant.now()))) {
                return alias;
            }
            alias = this.getBootstrapKeyStorePrefix() + this.getSystemId();
            cert = userKeyStore.getCertificate(alias);
            if (cert != null) {
                return alias;
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "error getting FDI cert", log.isLoggable(Level.FINE) ? ex : null);
        }
        return null;
    }

    protected String getBootstrapKeyStorePrefix() {
        return "FedIdBootstrap_";
    }

    protected String getRollingKeyStorePrefix() {
        return "FedId_";
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"CloudLink %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(cloudLinkForge:fdi.cert.failure)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(cloudLinkForge:fdi.cert.success)%"));
        return asi;
    }
}

