/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="resetConnector")
public class BDevTestComponent
extends BAbstractService {
    @Generated
    public static final Action resetConnector = BDevTestComponent.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDevTestComponent.class);
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String NIAGARA_SYSTEM_ID_TEST = "Tst";
    private boolean isJace8000;
    private static SecureRandom sRand;

    @Generated
    public void resetConnector() {
        this.invoke(resetConnector, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "developer");
    }

    public void started() throws Exception {
        super.started();
        this.setJace8000(Sys.getHostId().contains("TITAN"));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractClientAuthenticator;
    }

    public void doResetConnector(Context cx) throws Exception {
        log.info("Could not reset connector info, this component is obsolete");
    }

    public String makeSystemId(String stationName) {
        String sysIdTemplate = this.makeSystemIdTemplate();
        return String.format(sysIdTemplate, stationName);
    }

    public String makeSystemIdTemplate() {
        StringBuilder sb = new StringBuilder();
        sb.append("N4").append(":").append("%s").append(":").append(this.makeHostId());
        log.finest("Created dummy systemId " + sb);
        return sb.toString();
    }

    public String makeHostId() {
        StringBuilder sb = new StringBuilder();
        sb.append(NIAGARA_SYSTEM_ID_TEST);
        if (this.isJace8000) {
            sb.append('-').append("TITAN");
        }
        for (int i = 0; i < 4; ++i) {
            byte[] b = new byte[2];
            sRand.nextBytes(b);
            String s = String.format("-%02X%02X", b[0], b[1]);
            sb.append(s);
        }
        return sb.toString();
    }

    public void setJace8000(boolean isJace8000) {
        this.isJace8000 = isJace8000;
    }

    static {
        try {
            sRand = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            sRand = new SecureRandom();
        }
    }
}

