/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.crl;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.CRLProvider;
import com.tridium.crypto.core.io.TrustAnchorProvider;
import com.tridium.driver.crl.BBaseCrlDescriptor;
import com.tridium.util.CompUtil;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.BX509Certificate;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="issuerCertificate", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(value="BFacets.make(\"warningText\", \"%lexicon(driver:caCertEditor.warningText)%\")")}), @NiagaraProperty(name="useCrlDistributionPointInIssuer", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.SECURITY", value="true")}), @NiagaraProperty(name="crlDistributionPointUrls", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.SECURITY", value="true"), @Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="crlDescriptor", type="BBaseCrlDescriptor", defaultValue="new BBaseCrlDescriptor()"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()")})
@NiagaraActions(value={@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4), @NiagaraAction(name="checkCrlExpiration", flags=4)})
public class BCaCertAndCrl
extends BComponent
implements BIAlarmSource,
BIStatus {
    @Generated
    public static final Property status = BCaCertAndCrl.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property issuerCertificate = BCaCertAndCrl.newProperty((int)0, (BValue)BX509Certificate.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"warningText", (String)"%lexicon(driver:caCertEditor.warningText)%")));
    @Generated
    public static final Property useCrlDistributionPointInIssuer = BCaCertAndCrl.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (boolean)true));
    @Generated
    public static final Property crlDistributionPointUrls = BCaCertAndCrl.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"security", (boolean)true), (BFacets)BFacets.make((String)"multiLine", (boolean)true)));
    @Generated
    public static final Property crlDescriptor = BCaCertAndCrl.newProperty((int)0, (BValue)new BBaseCrlDescriptor(), null);
    @Generated
    public static final Property alarmSourceInfo = BCaCertAndCrl.newProperty((int)0, (BValue)BCaCertAndCrl.initAlarmSourceInfo(), null);
    @Generated
    public static final Action ackAlarm = BCaCertAndCrl.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action checkCrlExpiration = BCaCertAndCrl.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCaCertAndCrl.class);
    private static final BasicContext UPDATE_CONTEXT = new BasicContext();
    private static final String CRL_EXTENSION = ".crl";
    protected static final String LEGACY_BACNET_DIR = "bacnet" + File.separator + "crls";
    private String cachedUrls = "";
    private String crlFilename;
    private File crlDir = null;
    protected AlarmSupport alarmSupport;
    private final AtomicReference<Clock.Ticket> expirationCheckTicket = new AtomicReference();
    private Instant crlExpirationInstant;
    public static final LexiconModule LEXICON = LexiconModule.make((String)"driver");
    protected static final Logger logger = Logger.getLogger("driver.crl");

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BX509Certificate getIssuerCertificate() {
        return (BX509Certificate)this.get(issuerCertificate);
    }

    @Generated
    public void setIssuerCertificate(BX509Certificate v) {
        this.set(issuerCertificate, (BValue)v, null);
    }

    @Generated
    public boolean getUseCrlDistributionPointInIssuer() {
        return this.getBoolean(useCrlDistributionPointInIssuer);
    }

    @Generated
    public void setUseCrlDistributionPointInIssuer(boolean v) {
        this.setBoolean(useCrlDistributionPointInIssuer, v, null);
    }

    @Generated
    public String getCrlDistributionPointUrls() {
        return this.getString(crlDistributionPointUrls);
    }

    @Generated
    public void setCrlDistributionPointUrls(String v) {
        this.setString(crlDistributionPointUrls, v, null);
    }

    @Generated
    public BBaseCrlDescriptor getCrlDescriptor() {
        return (BBaseCrlDescriptor)this.get(crlDescriptor);
    }

    @Generated
    public void setCrlDescriptor(BBaseCrlDescriptor v) {
        this.set(crlDescriptor, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public void checkCrlExpiration() {
        this.invoke(checkCrlExpiration, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.crlExpirationInstant = this.generateCrlExpirationInstant();
        if (this.crlExpirationInstant != null) {
            this.generateExpirationTicket(this.crlExpirationInstant);
        }
        this.updateAlarm();
        if (Sys.isStationStarted()) {
            this.updateTrustAnchors();
            this.updateCrls();
        }
    }

    public void stopped() throws Exception {
        if (Sys.isStationStarted()) {
            this.updateTrustAnchors();
            this.updateCrls();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(issuerCertificate)) {
            if (this.getUseCrlDistributionPointInIssuer()) {
                this.updateCrlDistributionPointFromCertificate();
                this.getCrlDescriptor().updateStatus();
            }
            this.deleteCrl();
            this.crlFilename = this.generateCrlFilename();
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("issuerCertificate property has been changed in " + this.getType().getTypeSpec().getTypeName() + " " + this.getNavOrd().toString(context) + ": CRL has been deleted");
            }
            this.updateTrustAnchors();
            this.updateCrls();
            this.getCrlDescriptor().updateStatus();
        } else if (property.equals(useCrlDistributionPointInIssuer)) {
            if (this.getUseCrlDistributionPointInIssuer()) {
                this.setFlags((Slot)crlDistributionPointUrls, this.getFlags((Slot)crlDistributionPointUrls) | 1);
                this.cachedUrls = this.getCrlDistributionPointUrls();
                this.updateCrlDistributionPointFromCertificate();
            } else {
                this.setFlags((Slot)crlDistributionPointUrls, this.getFlags((Slot)crlDistributionPointUrls) & 0xFFFFFFFE);
                this.set(crlDistributionPointUrls, (BValue)BString.make((String)this.cachedUrls), (Context)UPDATE_CONTEXT);
            }
            this.getCrlDescriptor().updateStatus();
        } else if (property.equals(crlDistributionPointUrls) && context != UPDATE_CONTEXT) {
            if (this.getUseCrlDistributionPointInIssuer()) {
                this.getLogger().info("CRL Distribution Point URLs was modified, but is configured to use values from the CA certificate. Reverting to CRL distributions points found in the CA certificate.");
                this.updateCrlDistributionPointFromCertificate();
            }
            this.getCrlDescriptor().updateStatus();
        }
        super.changed(property, context);
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.updateTrustAnchors();
        this.updateCrls();
    }

    private void updateCrlDistributionPointFromCertificate() {
        X509Certificate configuredIssuer = this.getIssuerCertificate().getX509Certificate();
        if (configuredIssuer == null) {
            this.getLogger().info("CA is configured to use CRL distribution points from the certificate, but no CA is configured");
            return;
        }
        List crlDistributionPoints = CertUtils.getCrlDistributionPointsFromCertificate((X509Certificate)configuredIssuer);
        if (crlDistributionPoints.isEmpty()) {
            this.getLogger().info(String.format("CA <%s> is configured to use CRL distribution points from the certificate, but the certificate has no CRL distribution points", configuredIssuer.getSubjectX500Principal().toString()));
            this.set(crlDistributionPointUrls, (BValue)BString.make((String)""), (Context)UPDATE_CONTEXT);
            return;
        }
        this.set(crlDistributionPointUrls, (BValue)BString.make((String)String.join((CharSequence)"\n", crlDistributionPoints)), (Context)UPDATE_CONTEXT);
    }

    void validateCrl(X509CRL crl) throws Exception {
        X509Certificate crlIssuer = this.getIssuerCertificate().getX509Certificate();
        if (crlIssuer == null) {
            throw new Exception("CRL cannot be validated. " + this.getDisplayName(null) + " is not set.");
        }
        crl.verify(crlIssuer.getPublicKey());
    }

    void saveCrl(X509CRL crl) throws Exception {
        File crlDir = this.getCrlDir();
        if (crlDir == null) {
            throw new Exception("Could not save CRL for " + this.getNavOrd().toString(null) + ": Directory does not exist and could not be created.");
        }
        String crlFilename = this.getCrlFilename();
        if (crlFilename.isEmpty()) {
            throw new Exception("Could not save CRL for " + this.getNavOrd().toString(null) + ": Filename not generated");
        }
        Path crlPath = new File(crlDir, crlFilename).toPath();
        try {
            AccessController.doPrivileged(() -> {
                Files.write(crlPath, crl.getEncoded(), new OpenOption[0]);
                return null;
            });
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("CRL was saved for " + this.getNavOrd().toString(null) + "; directory: " + crlDir + ", filename: " + crlFilename);
            }
        }
        catch (PrivilegedActionException e) {
            throw new Exception("Could not write CRL for " + this.getNavOrd().toString(null), e.getException());
        }
        this.crlExpirationInstant = crl.getNextUpdate().toInstant();
        this.generateExpirationTicket(this.crlExpirationInstant);
        this.updateAlarm();
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("CRL has been saved for property " + this.getNavOrd().toString(null) + ": signaling that trust anchors have been updated");
        }
        this.doCrlSaved();
    }

    protected void doCrlSaved() {
        this.updateCrls();
    }

    private void deleteCrl() {
        String crlFilename;
        File crlDir = this.getCrlDir();
        if (crlDir == null) {
            this.getLogger().warning("Could not delete CRL for " + this.getNavOrd().toString(null) + ": Directory does not exist and could not be created");
        }
        if ((crlFilename = this.getCrlFilename()).isEmpty()) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("Filename has not yet been generated for " + this.getNavOrd().toString(null) + ": skipping delete");
            }
            return;
        }
        Path crlPath = new File(crlDir, crlFilename).toPath();
        try {
            boolean wasDeleted = AccessController.doPrivileged(() -> Files.deleteIfExists(crlPath));
            if (wasDeleted) {
                this.doCrlDeleted();
            }
            if (this.getLogger().isLoggable(Level.FINE)) {
                if (wasDeleted) {
                    this.getLogger().fine("CRL was deleted for " + this.getNavOrd().toString(null) + "; directory: " + crlDir + ", filename: " + crlFilename);
                } else {
                    this.getLogger().fine("CRL was not deleted because it did not exist for " + this.getNavOrd().toString(null) + "; directory: " + crlDir + ", filename: " + crlFilename);
                }
            }
        }
        catch (PrivilegedActionException e) {
            this.getLogger().log(Level.WARNING, "Could not delete CRL for " + this.getNavOrd().toString(null) + "; directory: " + crlDir + ", filename: " + crlFilename, this.getLogger().isLoggable(Level.FINE) ? e.getException() : null);
        }
        Clock.Ticket ticket = this.expirationCheckTicket.getAndSet(null);
        if (ticket != null) {
            ticket.cancel();
        }
        this.crlExpirationInstant = null;
        this.updateAlarm();
    }

    protected void doCrlDeleted() {
        this.updateCrls();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<X509CRL> getCrl() throws CRLException {
        if (!this.isConfiguredForCrls()) {
            return Optional.empty();
        }
        File crlDir = this.getCrlDir();
        String crlFilename = this.getCrlFilename();
        if (crlDir == null) return Optional.empty();
        if (crlFilename.isEmpty()) {
            return Optional.empty();
        }
        File crlFile = new File(crlDir, crlFilename);
        if (!AccessController.doPrivileged(crlFile::exists).booleanValue()) {
            this.getCrlDescriptor().execute();
            throw new CRLException("CRLs are configured for " + this.getName() + " but could not find CRL.");
        }
        try (FileInputStream fileInputStream = AccessController.doPrivileged(() -> new FileInputStream(crlFile));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(fileInputStream);
            this.validateCrl(crl);
            Optional<X509CRL> optional = Optional.of(crl);
            return optional;
        }
        catch (Exception e) {
            if (!(e instanceof PrivilegedActionException)) throw new CRLException("CRLs are configured for " + this.getName() + " but could not retrieve CRL from file.", e);
            e = ((PrivilegedActionException)e).getException();
            throw new CRLException("CRLs are configured for " + this.getName() + " but could not retrieve CRL from file.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Instant generateCrlExpirationInstant() {
        if (!this.isConfiguredForCrls()) {
            return null;
        }
        File crlDir = this.getCrlDir();
        String crlFilename = this.getCrlFilename();
        if (crlDir == null) return null;
        if (crlFilename.isEmpty()) {
            return null;
        }
        File crlFile = new File(crlDir, crlFilename);
        if (AccessController.doPrivileged(crlFile::exists) == false) return null;
        try (FileInputStream inputStream = AccessController.doPrivileged(() -> new FileInputStream(crlFile));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(inputStream);
            Instant instant = crl.getNextUpdate().toInstant();
            return instant;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            this.getLogger().log(Level.WARNING, "Could not load CRL for " + this.getName() + " to get expiration date", this.getLogger().isLoggable(Level.FINE) ? e : null);
        }
        return null;
    }

    public boolean hasValidCrlFilename() {
        return this.getCrlDir() != null && !this.getCrlFilename().isEmpty();
    }

    private boolean isConfiguredForCrls() {
        return !this.getCrlDistributionPointUrls().isEmpty() && !this.getIssuerCertificate().isNull();
    }

    private void generateExpirationTicket(Instant expirationInstant) {
        Clock.Ticket ticket = this.expirationCheckTicket.getAndSet(null);
        if (ticket != null) {
            ticket.cancel();
        }
        if (expirationInstant != null) {
            this.expirationCheckTicket.set(Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((long)expirationInstant.plusSeconds(5L).toEpochMilli()), (Action)checkCrlExpiration, null));
        }
    }

    public void doCheckCrlExpiration() {
        this.updateAlarm();
    }

    protected void updateCrls() {
        Optional crlProvider = CompUtil.closestAncestor((BComplex)this, CRLProvider.class);
        crlProvider.ifPresent(CRLProvider::crlsUpdated);
    }

    private String generateCrlFilename() {
        X509Certificate issuerCert = this.getIssuerCertificate().getX509Certificate();
        if (issuerCert == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA256");
            byte[] digest = md.digest(issuerCert.getSubjectX500Principal().getName().getBytes());
            return ByteArrayUtil.toHexString((byte[])digest) + CRL_EXTENSION;
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().log(Level.SEVERE, "Could not generate CRL filename for " + this.getName(), this.getLogger().isLoggable(Level.FINE) ? e : null);
            return "";
        }
    }

    public final File getCrlDir() {
        if (this.crlDir == null) {
            this.crlDir = BCaCertAndCrl.fetchCrlDir(this.getCrlSubDir());
        }
        return this.crlDir;
    }

    String getCrlFilename() {
        if (this.crlFilename == null) {
            this.crlFilename = this.generateCrlFilename();
        }
        return this.crlFilename;
    }

    protected static File fetchCrlDir(String subDir) {
        File protectedStationHome = Sys.getProtectedStationHome();
        if (protectedStationHome == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(() -> {
                File dir = BCaCertAndCrl.getCorrectedDirectory(protectedStationHome, subDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    logger.warning("Failed to retrieve or create directory for CRLs");
                    return null;
                }
                return dir;
            });
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrieve or create directory for CRLs", e);
            return null;
        }
    }

    protected String getCrlSubDir() {
        return "";
    }

    private static File getCorrectedDirectory(File protectedStationHome, String subDir) {
        if (subDir.equals(LEGACY_BACNET_DIR)) {
            return new File(protectedStationHome, LEGACY_BACNET_DIR);
        }
        return new File(protectedStationHome, "crls" + File.separator + subDir);
    }

    protected void updateTrustAnchors() {
        Optional trustAnchorProvider = CompUtil.closestAncestor((BComplex)this, TrustAnchorProvider.class);
        trustAnchorProvider.ifPresent(TrustAnchorProvider::trustAnchorsUpdated);
    }

    private void updateAlarm() {
        if (this.crlExpirationInstant != null && Instant.now().isAfter(this.crlExpirationInstant)) {
            this.alarmOffNormal();
        } else {
            this.alarmNormal();
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            boolean alarmAck = this.alarmSupport.ackAlarm(ackRequest);
            if (alarmAck) {
                this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
            }
            return BBoolean.make((boolean)alarmAck);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to ack alarm for " + BOrdList.make((BOrd)this.getNavOrd()), this.getLogger().isLoggable(Level.FINE) ? e : null);
            return BBoolean.FALSE;
        }
    }

    private void alarmOffNormal() {
        if (this.getStatus().isAlarm() || !this.shouldGenerateAlarmOnExpiration() || !this.isRunning()) {
            return;
        }
        try {
            boolean ackRequired = this.alarmSupport.isAckRequired(BSourceState.offnormal);
            this.alarmSupport.newOffnormalAlarm();
            int statusBits = this.getStatus().getBits();
            statusBits |= 8;
            if (ackRequired) {
                statusBits |= 0x80;
            }
            this.setStatus(BStatus.make((int)statusBits));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to send offNormal alarm for " + this.alarmSupport.getSourceOrd(), this.getLogger().isLoggable(Level.FINE) ? e : null);
        }
    }

    private void alarmNormal() {
        if (!this.getStatus().isAlarm() || !this.isRunning()) {
            return;
        }
        try {
            this.alarmSupport.toNormal(null);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to send toNormal alarm for " + this.alarmSupport.getSourceOrd(), e);
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo alarmSourceInfo = new BAlarmSourceInfo();
        alarmSourceInfo.setSourceName(BFormat.make((String)"%parent.displayName%.%displayName%"));
        alarmSourceInfo.setToOffnormalText(BFormat.make((String)"%lexicon(driver:caCertAndCrl.crlExpired)%"));
        alarmSourceInfo.setToNormalText(BFormat.make((String)"%lexicon(driver:caCertAndCrl.crlNotExpired)%"));
        return alarmSourceInfo;
    }

    protected boolean shouldGenerateAlarmOnExpiration() {
        return true;
    }

    protected Logger getLogger() {
        return logger;
    }
}

