/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.crl;

import com.tridium.driver.crl.BCaCertAndCrl;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make(BTime.make(2,0,0), BDaysOfWeekBits.monday))", override=true)
public class BBaseCrlDescriptor
extends BAbstractDescriptor
implements BIRestrictedComponent {
    @Generated
    public static final Property executionTime = BBaseCrlDescriptor.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make((BTime)BTime.make((int)2, (int)0, (int)0), (BDaysOfWeekBits)BDaysOfWeekBits.monday)), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBaseCrlDescriptor.class);
    protected static final List<String> CRL_ENCODING_TYPES = Arrays.asList("application/pkix-crl", "application/x-pkcs7-crl");
    private boolean fatalFault;
    public static final LexiconModule LEXICON = LexiconModule.make((String)"driver");
    protected static final Logger logger = Logger.getLogger("driver.crl");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.updateStatus();
        this.doStarted();
    }

    protected void doStarted() throws Exception {
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentType((Type)TYPE, (Type)this.getParent().getType(), (Type[])new Type[]{BCaCertAndCrl.TYPE});
        BIRestrictedComponent.checkForDuplicate((BComponent)this, (BComponent)parent);
    }

    @Override
    public void doExecute() {
        if (this.isUnoperational()) {
            logger.log(Level.FINE, "CRLDescriptor is unoperational, skipping execute");
            this.setState(BDescriptorState.idle);
            return;
        }
        this.executeInProgress();
        try {
            String[] urls;
            BCaCertAndCrl certAndCrl = (BCaCertAndCrl)this.getParent();
            if (certAndCrl == null) {
                logger.fine("CRLDescriptor is unparented, skipping execute");
                this.executeFail(LEXICON.getText("baseCrlDescriptor.execute.unparented", null));
                return;
            }
            String distPoints = certAndCrl.getCrlDistributionPointUrls();
            if (distPoints.isEmpty()) {
                logger.fine("CaCertAndCrl has no distribution points configured, skipping execute");
                this.executeFail(LEXICON.getText("baseCrlDescriptor.execute.urlsEmpty", null));
                return;
            }
            if (certAndCrl.getCrlFilename().isEmpty()) {
                logger.fine("CaCertAndCrl could not generate a CRL filename, skipping execute");
                this.executeFail(LEXICON.getText("baseCrlDescriptor.execute.noFilename", null));
                return;
            }
            X509CRL crl = null;
            for (String url : urls = distPoints.split("\n")) {
                block34: {
                    URL distPointUrl;
                    try {
                        distPointUrl = new URL(url.trim());
                    }
                    catch (MalformedURLException e) {
                        logger.log(Level.INFO, "Could not create URL from " + url, logger.isLoggable(Level.FINE) ? e : null);
                        continue;
                    }
                    try {
                        HttpURLConnection connection = (HttpURLConnection)distPointUrl.openConnection();
                        connection.setInstanceFollowRedirects(true);
                        connection.connect();
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 200) {
                            logger.info("Received bad response code " + responseCode + " from " + url + ". Expected 200");
                            continue;
                        }
                        String encodingType = connection.getHeaderField("Content-Type");
                        if (encodingType == null || !CRL_ENCODING_TYPES.contains(encodingType.toLowerCase(Locale.ENGLISH))) {
                            logger.info("Received bad encoding type '" + encodingType + "' from " + url + ". Expected 'application/pkix-crl' or 'application/x-pkcs7-crl'");
                            continue;
                        }
                        try (InputStream inputStream = connection.getInputStream();){
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            crl = (X509CRL)cf.generateCRL(inputStream);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Found a CRL at " + url);
                            }
                            if (!logger.isLoggable(Level.FINEST)) break block34;
                            logger.finest("CRL found:\n" + crl.toString());
                            break block34;
                        }
                        catch (CertificateException e) {
                            logger.log(Level.SEVERE, "Could not find 'X.509' algorithm to parse CRL", logger.isLoggable(Level.FINE) ? e : null);
                            this.executeFail(e.getLocalizedMessage());
                            return;
                        }
                        catch (CRLException e) {
                            logger.log(Level.INFO, "Could not parse CRL from " + url, logger.isLoggable(Level.FINE) ? e : null);
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Could not connect to " + url, logger.isLoggable(Level.FINE) ? e : null);
                    }
                    continue;
                }
                try {
                    certAndCrl.validateCrl(crl);
                    break;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not validate CRL for " + certAndCrl.getName(), logger.isLoggable(Level.FINE) ? e : null);
                    crl = null;
                }
            }
            if (crl == null) {
                logger.warning("Could not acquire CRL from distribution points for " + certAndCrl.getName());
                this.executeFail(LEXICON.getText("baseCrlDescriptor.execute.getFailed", null));
                return;
            }
            try {
                certAndCrl.saveCrl(crl);
                this.executeOk();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not save CRL for " + this.getType().getTypeSpec().getTypeName() + " " + this.getNavOrd().toString(), logger.isLoggable(Level.FINE) ? e : null);
                this.executeFail(LEXICON.getText("baseCrlDescriptor.execute.saveFailed", null));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Execute failed", logger.isLoggable(Level.FINE) ? e : null);
            this.executeFail(LEXICON.getText("baseCrlDescriptor.execute.failed", null));
        }
    }

    @Override
    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        newStatus = !this.getEnabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.isFatalFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    @Override
    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        Thread thread = new Thread((Runnable)new Invocation((BComponent)this, action, arg, cx), "BaseCrlDescriptor");
        thread.start();
        return null;
    }

    @Override
    public boolean isUnoperational() {
        return this.fatalFault || super.isUnoperational();
    }

    public boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        if (!this.isMounted()) {
            this.setFaultCause(LEXICON.getText("baseCrlDescriptor.fault.notMounted", null));
            this.fatalFault = true;
            return;
        }
        if (((BCaCertAndCrl)this.getParent()).getCrlDir() == null) {
            this.setFaultCause(LEXICON.getText("baseCrlDescriptor.fault.couldNotCreateCrlDir", null));
            this.fatalFault = true;
            return;
        }
        if (this.doCheckFatalFault()) {
            this.fatalFault = true;
            return;
        }
        this.fatalFault = false;
        this.setFaultCause("");
    }

    protected boolean doCheckFatalFault() {
        return false;
    }
}

