/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.fox;

import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import java.net.ConnectException;
import java.util.logging.Level;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationName", type="String", defaultValue=""), @NiagaraProperty(name="ord", type="BOrd", defaultValue="BOrd.NULL")})
public class BFoxWeatherProvider
extends BWeatherProvider {
    @Generated
    public static final Property stationName = BFoxWeatherProvider.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property ord = BFoxWeatherProvider.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxWeatherProvider.class);
    private static final BIcon icon = BIcon.std((String)"fox.png");

    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    @Generated
    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void updateReport() {
        BWeatherReport report = (BWeatherReport)this.getParent();
        if (report.getStatus().isFault()) {
            return;
        }
        BNiagaraNetwork niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (!niagaraNetwork.isRunning()) {
            return;
        }
        try {
            BFoxSession session = null;
            try {
                session = BFoxWeatherProvider.getSession(this.getStationName());
                session.engageNoRetry(this.getType().toString());
                OrdTarget ordTarget = this.getOrd().resolve(BOrd.make((String)"station:").get((BObject)session));
                BWeatherReport foxReport = (BWeatherReport)ordTarget.get();
                foxReport.lease(3);
                BForecast[] foxForcast = foxReport.getForecast();
                BForecast[] forcast = new BForecast[foxForcast.length];
                for (int i = 0; i < forcast.length; ++i) {
                    SlotCursor c = foxForcast[i].getProperties();
                    forcast[i] = new BForecast();
                    while (c.next()) {
                        Property p = c.property();
                        if (!p.isFrozen()) continue;
                        forcast[i].set(p, foxForcast[i].get(p).newCopy(true));
                    }
                }
                report.setForecast(forcast);
                SlotCursor c = report.getCurrent().getProperties();
                while (c.next()) {
                    Property p = c.property();
                    report.getCurrent().set(p, foxReport.getCurrent().get(p).newCopy(true));
                }
                report.setStatus(BStatus.ok);
            }
            catch (ConnectException ce) {
                BWeatherService.log.log(Level.SEVERE, "Unable to connect to station " + this.getStationName(), ce);
                report.setStatus(BStatus.down);
                throw ce;
            }
            catch (UnresolvedException ue) {
                BWeatherService.log.log(Level.SEVERE, "Weather source not found for " + report.getName(), ue);
                report.setStatus(BStatus.fault);
                throw ue;
            }
            catch (Exception e) {
                BWeatherService.log.log(Level.SEVERE, "Updating failed for " + report.getName(), e);
                report.setStatus(BStatus.down);
                throw e;
            }
            finally {
                if (session != null) {
                    session.disengage(this.getType().toString());
                }
            }
        }
        catch (Exception e) {
            BForecast[] children;
            for (BForecast child : children = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.stale);
            }
            report.getCurrent().setStatus(BStatus.stale);
        }
    }

    private static BFoxSession getSession(String stationName) throws Exception {
        BNiagaraStation station;
        BNiagaraNetwork niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (!niagaraNetwork.isRunning()) {
            return null;
        }
        try {
            station = (BNiagaraStation)niagaraNetwork.getStation(stationName);
        }
        catch (Exception e) {
            throw new Exception("Station not found in Niagara Network: " + stationName, e);
        }
        station.lease(1);
        BIpHost host = (BIpHost)station.getRemoteHost();
        BFoxSession session = BFoxSession.make((String)station.getName(), (BHost)host, (int)station.getFoxPort(), (FoxConnectionTypeEnum)BFoxClientWebsocketBehavior.getFoxConnectionType((BFoxClientWebsocketBehavior)station.getClientConnection().getFoxOverWebsocket(), (boolean)station.getClientConnection().getUseFoxs()), (int)station.getClientConnection().getFoxOverWebsocketPort());
        if (session == null) {
            throw new RuntimeException("Unable to connect to station " + stationName);
        }
        BIUserCredentials credentials = station.getClientConnection().getCredentials();
        session.setCredentials((BICredentials)credentials);
        session.getConnection().setCredentials(credentials);
        return session;
    }

    public String toString(Context context) {
        StringBuilder out = new StringBuilder();
        if (!this.getStationName().isEmpty()) {
            out.append("station:");
            out.append(this.getStationName());
            if (!this.getOrd().isNull()) {
                out.append('|');
                out.append(this.getOrd().toString());
            }
        }
        return out.toString();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BWeatherReport report = (BWeatherReport)this.getParent();
        report.updateWeatherReport();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

