/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.baja.data.BIDataValue;
import javax.baja.neql.Expression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public class LiteralExpression
extends Expression {
    private final BIDataValue value;
    private Collection<BIDataValue> evaluation = null;

    public LiteralExpression(BIDataValue value) {
        Objects.requireNonNull(value, "value must not be null");
        this.value = value;
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    @Override
    public String getNodeDisplay() {
        return this.value.toString();
    }

    public BIDataValue getValue() {
        return this.value;
    }

    public Collection<BIDataValue> evaluate(Entity entity, Context context) {
        if (this.evaluation == null) {
            this.evaluation = Collections.singletonList(this.getValue());
        }
        return this.evaluation;
    }

    @Override
    protected boolean evalBoolean(Entity entity, Context context) {
        return this.value != BBoolean.FALSE;
    }
}

