/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.NeqlUtil;
import java.util.Collection;
import javax.baja.neql.Expression;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;

public class GetRelationExpression
extends Expression {
    private final String namespace;
    private final String key;
    private final int direction;
    private final Id cachedId;

    public GetRelationExpression(String namespace, String key) {
        this(namespace, key, 3);
    }

    public GetRelationExpression(String namespace, String key, int direction) {
        this.namespace = namespace;
        this.key = key;
        this.direction = direction;
        this.cachedId = namespace != null && !namespace.isEmpty() ? Id.newId((String)namespace, (String)key) : null;
    }

    @Override
    public int getNodeType() {
        return 4;
    }

    @Override
    public String getNodeDisplay() {
        String directionStr;
        switch (this.direction) {
            case 1: {
                directionStr = "<-";
                break;
            }
            case 2: {
                directionStr = "->";
                break;
            }
            default: {
                directionStr = "";
            }
        }
        if (this.namespace == null) {
            return this.key + directionStr;
        }
        return this.namespace + ':' + this.key + directionStr;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public Collection<Relation> evaluate(Entity entity, Context context) {
        Id id = NeqlUtil.getExpressionId(this.key, this.namespace, context);
        return entity.relations().getAll(id, this.direction);
    }

    @Override
    protected boolean evalBoolean(Entity entity, Context context) {
        Id id = this.getId(context);
        return entity.relations().get(id, this.direction).isPresent();
    }

    public Id getId(Context context) {
        if (this.cachedId != null) {
            return this.cachedId;
        }
        String contextNamespace = context != null ? NeqlUtil.getNamespaceFromContext(context) : "";
        return Id.newId((String)contextNamespace, (String)this.key);
    }
}

